static char *SccsId = "@(#)dmcellst.c 3.8 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 17-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/

#include "dmstd.h"

/*
** This functions reads the kernel tables and allocates
** some memory in which the celllist for
** the specified view is written.
** A pointer to the area is returned.
*/

char  **_dmCelllist (dmproject, view)
DM_PROJECT * dmproject;
char   *view;
{
    FILE * fp;
    register char **clp;
    char * cellbuf[DM_MAXCELLS + 1];
    char   buf[DM_MAXNAME + 10];
    char   path[MAXLINE];
    int	   view_entry;
    register int i;

    if ((view_entry = _dmValidView (view)) == -1) {
	return (NULL);
    }

    if (_dmCh_project (dmproject) != 0) {
	dmError ("project key");
	return (NULL);
    }

    if ((clp = dmproject -> celllist[view_entry]) != NULL) {
	/* a (possibly inconsistent) celllist is already present: free it */
        while (*clp != NULL) {
	    _dmStrFree (*clp++);
	}
	dmFree (dmproject -> celllist[view_entry], DM_UNKNOWN_SIZE);
    	dmproject -> celllist[view_entry] = NULL;
    }

    _dmSprintf (path, "%s/%s/celllist", dmproject -> dmpath, view);

    if (!(fp = fopen (path, "r"))) {
	dmerrno = DME_NOCELLL;
	dmError ("_dmCelllist");
	return (NULL);
    }

    i = 0;

    while (fscanf (fp, "%s", buf) != EOF) {
	cellbuf[i] = _dmStrSave (buf);
	if (++i > DM_MAXCELLS)
	    _dmFatal ("_dmCelllist: too many cells", "", "");
    }
    cellbuf[i] = NULL;
    fclose (fp);

    if ((clp =
	(char **) malloc ((unsigned) ((i + 1) * sizeof (char *)))) == NULL) {
	dmerrno = DME_CORE;
	dmError ("_dmCelllist");
	return (NULL);
    }

    dmproject -> celllist[view_entry] = clp;

    for (i = 0;;) {
	if ((*clp++ = cellbuf[i++]) == NULL) break;
    }

#ifdef DM_DEBUG
    IFDEBUG {
	fprintf (stderr, "_dmCelllist: ");
	clp = dmproject -> celllist[view_entry];
	while (*clp != NULL) {
	    fprintf (stderr, "%s\n", *clp++);
	}
    }
#endif /* DM_DEBUG */

    return (dmproject -> celllist[view_entry]);
}
