/* SccsId = "@(#)dmproto.h 3.4 (TU-Delft) 04/28/93" */
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    T.G.R. van Leuken
                    N. van der Meijs
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : S. de Graaf
Modification date : 17-May-1988
Modified by       : P. Bingley
Modification date : 15-Nov-1989


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA Delft
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1988, All rights reserved
**********************************************************/

#ifndef _DMPROTO_INCLUDED
#define _DMPROTO_INCLUDED /* allows multiple inclusion */
#  ifdef __STDC__
DM_CELL *dmCheckOut(DM_PROJECT *dmproject, char *cell, char *versionstatus, int versionnumber, char *view, int mode);
DM_PROJECT *dmFindProjKey(int loc_imp, char *local_name, DM_PROJECT *father_proj, char **rem_namep, char *view);
DM_PROJECT *dmOpenProject(char *projectname, int mode);
DM_STREAM *dmOpenStream(DM_CELL *key, char *stream, char *mode);
char *dmAttrPrint(char *attr, char *last, char *par, char *val);
char *dmAttrScan(char *attr, char **par, char **val);
int dmCheckIn(DM_CELL *key, int mode);
int dmCkinAll(int mode);
int dmCloseCellStreams(DM_CELL *cellkey, int mode);
int dmCloseProject(DM_PROJECT *dmproject, int mode);
int dmCloseProjectContinue(DM_PROJECT *dmproject);
int dmCloseStream(DM_STREAM *dmfile, int mode);
int dmError(char *s);
int dmError2(char *s1, char *s2);
int dmGetDataEscape(DM_STREAM *dmfile, int fmt);
int dmGetDesignData(DM_STREAM *dmfile, int fmt);
int dmInit(char *progname);
int dmPerror(char *s);
int dmPrintf(DM_STREAM *iop, char *format, ...);
int dmPutDataEscape(DM_STREAM *dmfile, int fmt);
int dmPutDesignData(DM_STREAM *dmfile, int fmt);
int dmQuit(void);
int dmRemoveCell(DM_PROJECT *dmproject, char *cell, char *versionstatus, int versionnumber, char *view);
int dmRmCellForce(DM_PROJECT *dmproject, char *cell, char *versionstatus, int versionnumber, char *view, int force);
int dmScanf(DM_STREAM *iop, char *fmt, ...);
int dmSeek(DM_STREAM *dmfile, long offset, long ptrname);
/* gcc 2.3.3 warns about using "struct stat" here... */
typedef struct stat _STRUCT_STAT_;
int dmStat(DM_CELL *key, char *file, _STRUCT_STAT_ *buf);
long dmTell(DM_STREAM *dmfile);
int dmTestname(char *name);
int dmUnlink(DM_CELL *key, char *file);
char *dmGetMetaDesignData(int reqid, DM_PROJECT *projectid, ...);
char *dmPutMetaDesignData(int reqid, DM_PROJECT *projectid, ...);
char *dmSubstituteEnvironmentVars(const char *path);
int dmMemoryOptions(int);
#  else /* not __STDC__ */
DM_CELL *dmCheckOut();
DM_PROJECT *dmFindProjKey();
DM_PROJECT *dmOpenProject();
DM_STREAM *dmOpenStream();
char *dmAttrPrint();
char *dmAttrScan();
int dmCheckIn();
int dmCkinAll();
int dmCloseCellStreams();
int dmCloseProject();
int dmCloseProjectContinue();
int dmCloseStream();
int dmError();
int dmError2();
int dmGetDataEscape();
int dmGetDesignData();
int dmInit();
int dmPerror();
int dmPrintf();
int dmPutDataEscape();
int dmPutDesignData();
int dmQuit();
int dmRemoveCell();
int dmRmCellForce();
int dmScanf();
int dmSeek();
int dmStat();
long dmTell();
int dmTestname();
int dmUnlink();
char *dmGetMetaDesignData();
char *dmPutMetaDesignData();
char *dmSubstituteEnvironmentVars();
int dmMemoryOptions();
#  endif /* else not __STDC__ */
#endif /* _DMPROTO_INCLUDED */
