;;;; cemacs.el
;;;; by Stephen G. Simpson <simpson@math.psu.edu>
;;;; originally created February 1991
;;;; last revised 28 October 1993

;;
;; DESCRIPTION
;; This code enables Emacs to edit Chinese files within cxterm
;; or other Chinese terminal emulators.
;;
;; SOFTWARE REQUIREMENTS
;; It is assumed that you are running Version 19 of GNU Emacs.
;;
;; BUGS
;; This code is very primitive.  If you make any improvements, please
;; send them to Steve Simpson <simpson@math.psu.edu>.
;;
;; AVAILABILITY
;; I will try to keep the latest version of this file in
;; math.psu.edu:/pub/simpson/chinese/cemacs/emacs-19/cemacs.el.
;;

;;
;; HOW TO USE THIS FILE
;; 
;; Place this file, cemacs.el, in a directory
;; with other Emacs Lisp code so that your Emacs will be able to find
;; it.  Then go into your cxterm or other Chinese terminal emulator,
;; start Emacs, type
;; 
;;   ESC x load-library RET cemacs RET
;; 
;; and your Emacs will now be able to display and edit Chinese.  If you
;; want to automate this procedure, you can put the following line
;; into your ~/.cshrc.
;; 
;;   alias cemacs 'emacs -nw \!* -l cemacs'
;; 
;; You can then invoke cemacs within cxterm to edit Chinese files.
;;

;; the main thing is, we have to put Emacs into 8-bit mode

(require 'disp-table)
(standard-display-8bit 160 255)
(set-input-mode
  (car (current-input-mode)) (car (cdr (current-input-mode))) 0)

;; redefine some keys

(substitute-key-definition 'forward-char 'cemacs-forward-char global-map)
(substitute-key-definition 'backward-char 'cemacs-backward-char global-map)
(substitute-key-definition 'delete-char 'cemacs-delete-char global-map)
(substitute-key-definition 'delete-backward-char
  'cemacs-backward-delete-char global-map)
(substitute-key-definition 'backward-delete-char
  'cemacs-backward-delete-char global-map)
(substitute-key-definition 'backward-delete-char-untabify
  'cemacs-backward-delete-char-untabify global-map)

;; Because local keymaps override the global keymap,
;; it's sometimes hard to keep DEL bound to the command we want.
;; But maybe the following will help.
(define-key text-mode-map "\177" 'cemacs-backward-delete-char-untabify)
(define-key lisp-mode-map "\177" 'cemacs-backward-delete-char-untabify)
(define-key c-mode-map "\177" 'cemacs-backward-delete-char-untabify)
(defun cemacs-rebind-del-key ()
  "rebind DEL to its appropriate cemacs command, if necessary.\n"
  (interactive)
  (let ((cemacs-old-del (lookup-key (current-local-map) "\177")))
    (cond
     ((eq cemacs-old-del 'backward-delete-char-untabify)
      (local-set-key "\177" 'cemacs-backward-delete-char-untabify))
     ((or (eq cemacs-old-del 'backward-delete-char)
	  (eq cemacs-old-del 'delete-backward-char))
      (local-set-key "\177" 'cemacs-backward-delete-char)))))
(cemacs-rebind-del-key)
;; make C-l not only recenter the screen but also rebind DEL if necessary.
(defun cemacs-recenter (&optional arg)
  "recenter, and rebind DEL if necessary.\n"
  (interactive "P") (recenter arg) (cemacs-rebind-del-key))
(substitute-key-definition 'recenter 'cemacs-recenter global-map)

;; define cemacs commands

;; NOTE: The code below will not work very will with Big5 in mixed
;; Chinese/ASCII files.  The problem is that, in Big5, the second byte
;; of a Chinese character can be an ASCII byte, so it is harder to
;; distinguish Chinese from ASCII.  Can someone suggest a way to get
;; around this problem?

;; replacement for forward-char
(defun cemacs-forward-char (&optional arg)
  "cemacs replacement for forward-char\n
Move point right ARG characters.
On reaching end of buffer, stop and signal error.
ARG defaults to 1.\n
arguments: (&optional n)\n"
  (interactive "p")
  (while (> arg 0)
    (setq arg (- arg 1))
    (cond
      ((= (point) (point-max))
       (message "End of buffer")
       (setq arg 0))
      ((>= (char-after (point)) 160)
       (forward-char 1)
       (forward-char 1))
      (t (forward-char 1)))
))

;; replacement for backward-char
(defun cemacs-backward-char (&optional arg)
  "cemacs replacement for backward-char\n
Move point left ARG characters.
On reaching end of buffer, stop and signal error.
ARG defaults to 1.\n
arguments: (&optional n)\n"
  (interactive "p")
  (while (> arg 0)
    (setq arg (- arg 1))
    (cond
      ((= (point) (point-min))
       (message "Beginning of buffer")
       (setq arg 0))
      ((>= (char-after (- (point) 1)) 160)
       (backward-char 1)
       (backward-char 1))
      (t (backward-char 1)))
))

;; replacement for delete-char
(defun cemacs-delete-char (&optional arg)
  "cemacs replacement for delete-char\n
Delete the following ARG characters.
On reaching end of buffer, stop and signal error.
ARG defaults to 1.\n
arguments: (&optional n)\n"
  (interactive "p")
  (while (> arg 0)
    (setq arg (- arg 1))
    (cond
      ((= (point) (point-max))
       (message "End of buffer")
       (setq arg 0))
      ((>= (char-after (point)) 160)
       (delete-char 1)
       (delete-char 1))
      (t (delete-char 1)))
))

;; replacement for backward-delete-char and delete-backward-char
(defun cemacs-backward-delete-char (&optional arg)
  "cemacs replacement for backward-delete-char and delete-backward-char\n
Delete ARG characters backward, changing tabs into spaces.
On reaching end of buffer, stop and signal error.
ARG defaults to 1.\n
arguments: (&optional n)\n"
  (interactive "p")
  (while (> arg 0)
    (setq arg (- arg 1))
    (cond
      ((= (point) (point-min))
       (message "Beginning of buffer")
       (setq arg 0))
      ((>= (char-after (- (point) 1)) 160)
       (backward-delete-char 1)
       (backward-delete-char 1))
      (t (backward-delete-char 1)))
))

;; replacement for backward-delete-char-untabify
(defun cemacs-backward-delete-char-untabify (&optional arg)
  "cemacs replacement for backward-delete-char-untabify\n
Delete ARG characters backward, changing tabs into spaces.
On reaching end of buffer, stop and signal error.
ARG defaults to 1.\n
arguments: (&optional n)\n"
  (interactive "p")
  (while (> arg 0)
    (setq arg (- arg 1))
    (cond
      ((= (point) (point-min))
       (message "Beginning of buffer")
       (setq arg 0))
      ((>= (char-after (- (point) 1)) 160)
       (backward-delete-char-untabify 1)
       (backward-delete-char-untabify 1))
      (t (backward-delete-char-untabify 1)))
))

;; last but not least, provide this package
(provide 'cemacs)


