#!/bin/sh
# setup the account for cxterm

# definitions

: ${ECHONONL:="echo -n"}

# add CXterm.ins to .Xdefaults ...

if [ -f ./cxterm.ins ]; then
    . ./cxterm.ins
else
    CXTERM_AD=cxterm/CXterm.ad
fi

if   [ -f $HOME/.Xdefaults ]; then
    X_RES=$HOME/.Xdefaults
elif [ -f $HOME/.Xdefaults-`hostname` ]; then
    X_RES=$HOME/.Xdefaults-`hostname`
elif [ -f $HOME/.Xresource ]; then
    X_RES=$HOME/.Xresource
else
    X_RES=$HOME/.Xdefaults
fi

echo "I am putting $CXTERM_AD into your X resource file"
echo "$X_RES.  If this is a wrong place, please make the adjustment"
echo "yourself.  Refer to Doc/x-resrc file for more information."

mv ${X_RES} ${X_RES}.bak
awk '/! BEGIN_CXTERM_RESOURCE/,/! END_CXTERM_RESOURCE/ { next }
     {print}' ${X_RES}.bak > ${X_RES}
cat $CXTERM_AD >> $X_RES

if [ "$XFONTDIR" = "" ]; then
    cat << _FONT_DIR_

Usually you need to add the following line at an appropriate place
in your X window startup files (such as ~/.xinitrc, or ~/.xsession):

        xset fp+ $font_dir

(X terminal users may need a different command, see Doc/CXTERM.FAQ.)
_FONT_DIR_

fi

echo ""
echo "Finally, remember to add the directory where you installed cxterm,"
echo "$BINDIR, to your PATH (in .cshrc or .profile, etc.)"

