//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#ifndef _TERMMETER_H_
#define _TERMMETER_H_

#include "timer.h"

class TermMeter {
public:
  TermMeter( void );
  ~TermMeter( void );

  static void checkevent( void );
  float incoming( void ){ 
    return (incoming_[(index_+1)%2] - incoming_[index_]) 
           * 1000000 / lastinterval_; 
  }
  float outgoing( void ){ 
    return (outgoing_[(index_+1)%2] - outgoing_[index_])
      * 1000000 / lastinterval_; 
  }
protected:
  static float incoming_[2], outgoing_[2];
  static Timer timer_;
  static int index_, termsocket_;
  static float lastinterval_;

  static void stat( int local, int st );
private:
};

#endif
