//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "cpumeter.h"
#include <sys/pstat.h>


static const char COLORS[4][33] = { "blue", "yellow", "red", "green" };


CPUMeter::CPUMeter( XOSView *parent, int x, int y, int width, int height )
: FieldMeter( parent, x, y, width, height, 4, "CPU", "USR/NICE/SYS/FREE" ){
  for ( int i = 0 ; i < 2 ; i++ )
    for ( int j = 0 ; j < 4 ; j++ )
      cputime_[i][j] = 0;
  cpuindex_ = 0;

  for ( i = 0 ; i < 4 ; i++ )
    setfieldcolor( i, COLORS[i] );
}

CPUMeter::~CPUMeter( void ){
}

void CPUMeter::checkevent( void ){
  getcputime();
  drawfields();
}

void CPUMeter::getcputime( void ){
  total_ = 0;
  struct pst_dynamic stats;

  pstat_getdynamic( &stats, sizeof( struct pst_dynamic ), 1, 0 );

  cputime_[cpuindex_][0] = stats.psd_cpu_time[0];
  cputime_[cpuindex_][1] = stats.psd_cpu_time[1];
  cputime_[cpuindex_][2] = stats.psd_cpu_time[2];
  cputime_[cpuindex_][3] = stats.psd_cpu_time[3];

  int oldindex = (cpuindex_+1)%2;
  for ( int i = 0 ; i < 4 ; i++ ){
    fields_[i] = cputime_[cpuindex_][i] - cputime_[oldindex][i];
    total_ += fields_[i];
  }
  cpuindex_ = (cpuindex_ + 1) % 2;
}
