#ifndef _XGROUPS_H
#define _XGROUPS_H
#include <X11/xpm.h>
#include <signal.h>
#include <limits.h>

#define VERSION "Xgroups 1.3"

/*
	the # of chars in a pathname (defined in limits.h ???)
*/

#ifndef PATH_MAX
#define PATH_MAX 1024
#endif

/*
	the directory where is placed xgroups
*/

#ifndef GRPDIR
#define GRPDIR "/usr/local/lib/xgroups"
#endif

/*
	the name of the group that is opened if you do not supply a argument in
	the command line
*/

#ifndef STARTGRP
#define STARTGRP "start"
#endif

/*
	the name of the group that is opened when your start X with the
	command: "xgroups_boot"
*/

#ifndef BOOTGRP
#define BOOTGRP "boot"
#endif

/*
	the icon that is used if xgroup cannot open a requested icon
*/

#ifndef DEFAULTICON
#define DEFAULTICON	"/usr/local/lib/xgroups/default.xpm"
#endif

/*
	the maximum number of entryes in a group
*/

#ifndef MAXGRUPPO
#define MAXGRUPPO 256
#endif

/*
	the maximum number of icons
*/

#ifndef MAXICONS
#define MAXICONS 512
#endif

/*
	ICONLIST is the file that is used as a archive for the icons names
	PICONLIST is the icon file of each user (only the filename w/o path)
*/

#ifndef ICONLIST
#define ICONLIST	"/usr/local/lib/xgroups/icons.lst"
#endif

#ifndef PICONLIST
#define PICONLIST	"icons.lst"
#endif

/*
	looks this man nice ?
*/

#ifndef BEPPE
#define BEPPE	"/usr/local/lib/xgroups/beppe.xpm"
#endif

/*
	types of icons
*/

#define BITMAP 0
#define PIXMAP 1

/*
	the max. dimensions for a icon
	and the number of icons in a row
*/

#define WICONA 70
#define HICONA 70
#define INAROW 6

/*
	the options that xgroups(_newg) can provide
*/

#define ADD_GRP 0
#define ADD_PRG 1 
#define DEL_ITM 2
#define SEL_ALL 3
#define SEL_NONE 4

/*
	i use this structure for a icon
*/

typedef struct _XpmIcon
{
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
} XpmIcon;

/*
	this is the structure that contains the data for a single program
	i'm sorry, but i'm italian and i initially wrote the program in
	my natural language ("nome" is "name" ...).
*/

typedef struct T_Programma
{
	int type;
    char nome[255];
    char file_icona[255];
    char comando[255];
	int selected;
    XpmIcon icona;
    int x,y;
	int width, height;
	Window	window;
} Programma;

/*
	some prototypes
*/

void Read_icona(Window parent, char * iconFile, Programma *p);
void Paint_icona( Window parent, Programma *p, void (*function)(int), int arg);
void Destroy_icona(Programma *p);
void sleep_a_little(int n);
int DoubleClick(void);
void Select_icona(Window parent, Programma *p);
void UnSelect_icona(Window parent, Programma *p);

#endif

