/*********************************************************
 Copyright (C) 1994 Patrick Voigt
*********************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <X11/cursorfont.h>
#include <Xm/DragDrop.h>
#include <Xm/ScrolledW.h>
#include <Xm/List.h>
#include <Xm/Form.h>
#include <Xm/SelectioB.h>
#include <Xm/ToggleB.h>

#include "fm.h"
#include "file.h"

extern Widget form, pb2, frame, textf, mainw, label;
extern int table_anz;
extern char **table;
extern int timer_id;
extern Atom ICON_INFO;

Widget toggle;
struct dir *v_head, *v_actual;
char f_name[2048];
int list_nr = 1;				// Anzahl offener Verzeichnisse

/********************************************************************************
  generiert eine Infos ueber die letzte, aktuelle Liste
  und bringt diese zur Anzeige 
********************************************************************************/
void list_info ()
{
  XmString message;
  char info[70];
  int i, k, anz = v_actual->p.get_anz();
  int dirs = 0, files = 0, size = 0;
  int type;
  char str[20];
  char str1[20];
 
  for (i = 2; i < anz; i++)
  {
    type = v_actual->p.get_st_type (i);
    if (type == IS_DIR || type == IS_LNKD)
      dirs++;
    if (type == IS_REG)
    {
      size += v_actual->p.get_st_size (i);
      files++;
    }
  }
  strcpy (info, "Subdirs:  ");
  sprintf (str, "%4-d", dirs);
  strcat (info, str);
  strcat (info, "       Files:  ");
  sprintf (str, "%4-d", files);
  strcat (info, str);
  strcat (info, "       Size:  ");
  sprintf (str, "%15-d", size);

  anz = 0;
  while (str[anz] != ' ')
   anz++;
  str[anz--] = '\0';
  k = 19;
  i = 0;
  str1[k] = '\0';

  while (anz >= 0)
  {
    k--;
    if (i < 3)
      str1[k] = str[anz];
    else
    {
      i = -1;
      str1[k] = '.';
      anz++;
    }
    i++;
    anz--;
  }
 
  strcat (info, &str1[k]);
  strcat (info, " Bytes");
  message = XmStringCreateSimple (info);
  XtVaSetValues (label, XmNlabelString, message, NULL);
  XmStringFree (message);
}

/********************************************************************************
  prueft, ob alle Listen ins Fenster passen und loescht die erste,
  falls dies nicht der Fall ist 
********************************************************************************/

void check_size (void)
{
 Dimension main_size, list_size, sum = 0;
 struct dir *help = v_head;

 XtVaGetValues (mainw, XmNwidth, &main_size, NULL);
 while (help)
 {
  XtVaGetValues (help->scroll, XmNwidth, &list_size, NULL);
  sum += list_size;
  help = help->next;
 } 
 if (sum > main_size - 4)
 {
  kill_first (NULL,NULL,NULL);
  if (!v_head->next)
   return;
  check_size ();
 }
};

/********************************************************************************
 ist die main-dispatch-loop oder genauer die
 Default-Action-Callback-Routine der Listwidgets

 jeder Doppelklick in einem Verzeichnis landet hier
 stellt fest was zu tun ist
********************************************************************************/

void doubleclick (Widget w, XtPointer cl_data, XmListCallbackStruct *cbs)
{
 void time_check (void *data, XtIntervalId *id);
 int which = cbs->item_position - 1;	     	// von wo kam Ereignis
 struct dir *help;
 int i, top;
 int client_data = (int) cl_data;

 if ((which == 0) & (client_data == list_nr))	// erste Position & letzte Liste ?
  return;					// ja: raus

 if (client_data < list_nr)                     // Ereignis nicht vom letzten Verzeichnis ?
 {						// ja
  help = v_head;
  if (which >= 1)
   for (i = 1; i < client_data ; i++)
    help = help->next;
  else
   for (i = 1; i < client_data -1 ; i++)
    help = help->next;
  if ((help->p.get_st_type (which + 1) == IS_REG) ||
      (help->p.get_st_type (which + 1) == IS_LNKR))
  {
   execute (help, which + 1);
   return;
  }

  if ((help->p.get_st_type (which + 1) != IS_DIR) &&
      (help->p.get_st_type (which + 1) != IS_LNKD))
   return;

  if (!which)					// obersten Eintrag (".") ?
  {						// ja
   if (client_data > 1)				// nicht erste  Liste ?
   {						// ja
    strcpy (f_name, help->next->p.get_path());	
    delete_list (help->next);
    help->next = v_actual = create_list (f_name, help->scroll, ++list_nr, True);
    check_size();
    list_info();
    return;
   }
   else
   {						//nein, erste Liste
    strcpy (f_name, help->p.get_path());
    delete_list (help);
    v_head = v_actual = create_list (f_name, form, ++list_nr, True);
    check_size();
    sensitiv_check();
    list_info();
    return;
   }
  }
  else
  {						// nein, nicht erster Eintrag
   if ((help->p.get_st_type (which + 1) != IS_DIR) &&
       (help->p.get_st_type (which + 1) != IS_LNKD))
    return;
   strcpy (f_name, help->p.get_path()); 
   strcat (f_name, help->p.get_name (which + 1));
   strcat (f_name, "/");

   if (access (f_name, R_OK))
   {
    XmString deny;
    deny = XmStringCreateSimple ("Cannot access this directory, permission denied!");
    XtRemoveTimeOut (timer_id);
    time_check (NULL, NULL);
    XtVaSetValues (label, XmNlabelString, deny,
                          XmNuserData, -1,  NULL);
    XmStringFree (deny);
    return;
   }

   delete_list (help->next);
   help->next = v_actual = create_list (f_name, help->scroll, ++list_nr, True);
   check_size();
   list_info();
   return;
  }
 }

 // Ereignis von letzter Liste

 strcpy (f_name, v_actual->p.get_path()); 

 if ((v_actual->p.get_st_type (which + 1) == IS_DIR) ||
     (v_actual->p.get_st_type (which + 1) == IS_LNKD))
 {
  strcat (f_name, v_actual->p.get_name (which + 1));
  strcat (f_name, "/");

  if (access (f_name, R_OK))
  {
   XmString deny;
   deny = XmStringCreateSimple ("Cannot access this directory, permission denied!");
   XtRemoveTimeOut (timer_id);
   time_check (NULL, NULL);
   XtVaSetValues (label, XmNlabelString, deny,
                         XmNuserData, -1, NULL);
   XmStringFree (deny);
   return;
  }

  which = XmListGetKbdItemPos (v_actual->list);
  XtUnmanageChild (v_actual->list);
  XtVaGetValues (v_actual->list, XmNtopItemPosition, &top, NULL);
  light_list (v_actual);
  XmListSetPos (v_actual->list, top);
  XmListSelectPos (v_actual->list, which, False);
  XtManageChild (v_actual->list);
  v_actual->next = v_actual = create_list (f_name, v_actual->scroll, ++list_nr, True);

  check_size();
  sensitiv_check();
  list_info();
  return;
 }
 if ((v_actual->p.get_st_type (which + 1) == IS_REG) ||
     (v_actual->p.get_st_type (which + 1) == IS_LNKR))
  execute (v_actual, which + 1);
};


/********************************************************************************
  Funktion loescht alle Listen nach und einschliesslich der auf die
  k zeigt 
********************************************************************************/
void delete_list (struct dir *k)
{
 struct dir *help;

 help = k;
 while (help != NULL)
 {
  help = k->next;
  XtDestroyWidget (k->list);
  XtDestroyWidget (k->scroll);
  list_nr--;
  delete k;
  k = help;
 } 
};

/********************************************************************************
  Funktion liesst in bestehendes List-Widget nur die Dateinamen ein 
  und behaelt das(die) vorher selektierte(n) Item(s) bei 
********************************************************************************/
void light_list (struct dir *k)
{
  void HandleDrop (Widget w, XtPointer client_data, XtPointer call_data);
  int anz = k->p.get_anz();
  XmStringTable str;
  XmStringTable contain, selected;
  int i, *pos, cnt;
  Boolean got;
  Arg args[5];
  struct dir *help = v_head;
  Atom importList;

  got = XmListGetSelectedPos (k->list, &pos, &cnt);
  if (got)
  {
    XtVaGetValues (k->list, XmNitems, &contain, NULL);
    selected = (XmStringTable) new XmString[cnt];
    for (i = 0; i < cnt; i++)
      selected[i] = XmStringCopy (contain[pos[i] - 1]);
    delete []pos;
  }

  XtDestroyWidget (k->list);

  str = (XmStringTable) new XmString[anz];
  for (i = 0; i < anz; i++)
    if (k->p.get_st_type (i) == IS_DIR || k->p.get_st_type (i) == IS_LNKD)
      str[i] = XmStringCreateLtoR (k->p.get_name (i), "charset1");
    else 
      str[i] = XmStringCreateLtoR (k->p.get_name (i), "charset2");

  k->list = XtVaCreateWidget ("list", xmListWidgetClass, k->scroll,
			      XmNselectionPolicy, XmEXTENDED_SELECT,
			      XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE,
			      XmNborderWidth, 0,
			      XmNitems, str,
			      XmNitemCount, anz ,
			      XmNvisibleItemCount, anz , 0);

  XmListDeletePos (k->list, 2);
  XtManageChild (k->list);
  XtVaSetValues (form, XmNwidth, 0, 0);		 // to force resizing the ScrolledList

  i = 1;
  while (help != k)
  {
    i++;
    help = help->next;
  }

  XtVaSetValues (k->list, XmNuserData, -i, NULL);
  XtAddCallback (k->list, XmNdefaultActionCallback, doubleclick, (XtPointer) i);
  XtOverrideTranslations (k->list, XtParseTranslationTable ("<Btn2Down>: drag()"));
  XtOverrideTranslations (k->list, XtParseTranslationTable ("<Btn3Down>: popup()"));

  importList = ICON_INFO;
  i = 0;
  XtSetArg (args[i], XmNdropSiteOperations, XmDROP_COPY); i++;
  XtSetArg (args[i], XmNnumImportTargets, 1); i++;
  XtSetArg (args[i], XmNdropProc, HandleDrop); i++;
  XtSetArg (args[i], XmNimportTargets, &importList); i++;

  XmDropSiteRegister (k->list, args, i);

  for (i = 0; i < anz; i++)
    XmStringFree (str[i]);
  delete []str;

  if (got)
  {
    XtVaSetValues (k->list, XmNselectionPolicy, XmMULTIPLE_SELECT, 0);
    for (i = 0; i < cnt; i++)
      if (XmListItemExists (k->list, selected[i])) 
        XmListSelectItem (k->list, selected[i], False);
    XtVaSetValues (k->list, XmNselectionPolicy, XmEXTENDED_SELECT, 0);

    for (i = 0; i < cnt; i++)
      XmStringFree (selected[i]);
    delete []selected;
  }
};

/********************************************************************************
 erzeugt neuen Cursor
********************************************************************************/
void busy_cursor (Widget w, Boolean busy)
{
  static Cursor watch;

  if (busy)
  {
    watch = XCreateFontCursor(XtDisplay (w), XC_watch);
    XDefineCursor (XtDisplay (w), XtWindow (w), watch);
  }
  else
  {
    XUndefineCursor (XtDisplay (w), XtWindow (w));
    XFreeCursor (XtDisplay (w), watch);
  }
  XmUpdateDisplay (w);
}

/********************************************************************************
 erzeugt neue Liste des Verzeichnisses name
 full gibt an, ob mehr als nur die Dateinamen angezeigt werden sollen
********************************************************************************/
struct dir *create_list (char *name, Widget w, int callback_nr, Boolean full)
{
  extern void HandleDrop (Widget w, XtPointer client_data, XtPointer call_data);
  extern Atom ICON_INFO;
  struct dir *help; 
  int i;
  int anz;                                       // Anzahl Verzeichniseintraege
  char csize[10];                                // Zugriffsrechte 
  char f[80];                                    // Infostring 
  XmStringTable str_table1;
  Arg args[10];
  Atom importList;

  busy_cursor (mainw, True);

  help = new dir;
  help->next = NULL;
  help->p.readmdir (name);
  anz = help->p.get_anz();

  str_table1 = (XmStringTable) new XmString[anz];

  for (i = 0; i < anz ; i++)
  {
    if (full)
    {
      strcpy (f, permissions (help->p.get_st_mode(i), help->p.get_st_type(i)));
      sprintf (csize, "%9d", help->p.get_st_size(i));
      strcat (f, csize);
      strcat (f, mtime(help->p.get_st_mtime(i)));
      strcat (f, "  ");
      strncat (f, help->p.get_name(i), 30);
      if (strlen (help->p.get_name(i)) > 30)
        strcat (f, "..");
    }
    else
      strcpy (f, help->p.get_name (i));

    if (help->p.get_st_type (i) == IS_DIR || help->p.get_st_type (i) == IS_LNKD)
      str_table1[i] = XmStringCreateLtoR (f, "charset1");
    else 
      str_table1[i] = XmStringCreateLtoR (f, "charset2");
  }

  help->scroll = XtVaCreateManagedWidget ("scroll", xmScrolledWindowWidgetClass, form,
					XmNtopAttachment, XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_WIDGET,
					XmNbottomWidget, frame,
					XmNleftAttachment, XmATTACH_WIDGET,
					XmNleftWidget, w, 0);

  help->list = XtVaCreateWidget ("list", xmListWidgetClass, help->scroll,
				XmNselectionPolicy, XmEXTENDED_SELECT,
				XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE,
				XmNborderWidth, 0,
				XmNitems, str_table1,
				XmNitemCount, anz ,
				XmNvisibleItemCount, anz , 0);

  XmListDeletePos (help->list, 2);
  XtManageChild (help->list);
  XtVaSetValues (form, XmNwidth, 0, 0);		 // to force resizing the ScrolledList

  XtAddCallback (help->list, XmNdefaultActionCallback, doubleclick,
                 (XtPointer) callback_nr);
  XtOverrideTranslations (help->list, XtParseTranslationTable ("<Btn2Down>: drag()"));
  XtOverrideTranslations (help->list, XtParseTranslationTable ("<Btn3Down>: popup()"));

  for (i = 0; i < anz; i++)
    XmStringFree (str_table1[i]);
  delete []str_table1;

  if (full)
    XtVaSetValues (textf, XmNvalue, help->p.get_path(), 0);

  importList = ICON_INFO;
  i = 0;
  XtSetArg (args[i], XmNdropSiteOperations, XmDROP_COPY); i++;
  XtSetArg (args[i], XmNnumImportTargets, 1); i++;
  XtSetArg (args[i], XmNdropProc, HandleDrop); i++;
  XtSetArg (args[i], XmNimportTargets, &importList); i++;

  XtVaSetValues (help->list, XmNuserData, -callback_nr, NULL);
  XmDropSiteRegister (help->list, args, i);

  busy_cursor (mainw, False);

  return help;
};

/********************************************************************************
  Callback-Routine des "hammer" Pushbuttons
  loescht erstes Listwidget und gibt den Speicher frei 
********************************************************************************/
void kill_first (Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{
  struct dir *help;
  int i;

  help = v_head;
  v_head  = v_head->next;
  XtDestroyWidget (help->list);
  XtDestroyWidget (help->scroll);
  list_nr--;
  delete help;

  i = 2;
  help = v_head;
  do
  {
    XtRemoveCallback (help->list, XmNdefaultActionCallback, doubleclick, (XtPointer) i);
    i--;
    XtAddCallback (help->list, XmNdefaultActionCallback, doubleclick, (XtPointer) i);
    XtVaSetValues (help->list, XmNuserData, -i, NULL);
    i += 2;
    help = help->next;
  }
  while (help != NULL);

  XtVaSetValues (v_head->scroll, XmNleftAttachment, XmATTACH_FORM, 0); 

  sensitiv_check();
};


/********************************************************************************
  Callback-Routine des "up" Pushbuttons
  erzeugt neue "erste" Liste
********************************************************************************/
void up_press (Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{
  struct dir *help;
  int i;
  XmString item;

  strcpy (f_name, v_head->p.get_path());
  i = strlen (f_name) - 1;
  f_name[i] = '\0';
  i--;
  while (f_name[i] != '/')
    i--;

  memmove (&f_name[i + 2], &f_name[i + 1], 256); 
  f_name[i + 1] = '\0';
  
  help = v_head;
  item = XmStringCreate (&f_name[i + 2], "charset1");
  v_head = create_list (f_name, form, 1, False);
  list_nr++;

  XmListSelectItem (v_head->list, item, False);
  XmStringFree (item);

  v_head->next = help;
  XtVaSetValues (v_head->next->scroll, XmNleftAttachment, XmATTACH_WIDGET,
				       XmNleftWidget, v_head->scroll, 0);
  i = 1;
  help = v_head->next;
  do
  {
    XtRemoveCallback (help->list, XmNdefaultActionCallback, doubleclick, (XtPointer) i);
    i++;
    XtAddCallback (help->list, XmNdefaultActionCallback, doubleclick, (XtPointer) i);
    XtVaSetValues (help->list, XmNuserData, -i, NULL);
    help = help->next;
  }
  while (help != NULL);

  sensitiv_check();
};

/*******************************************************************************
 erstellt argv fuer name
 und veraendert name (einfuegen von '\0'-Zeichen)
********************************************************************************/
void mk_argv (char *name, char **argv)
{
  int len, num, k;

  num = k = 0;
  len = strlen (name);

  while (name[k] != ' ' && name[k] != '\0')
    k++;
  name[k] = '\0';

  while (name[k] != '/')
    k--;
  argv[num++] = &name[++k];
    
  while (name[k] != '\0')
    k++;

  if (len == k)
  {
    argv[num] = NULL;
    return;
  }

  k++;
  while (name[k])
  {
    while (isspace (name[k]))
      k++;
    if (name[k] == '\0')
      break;
    argv[num++] = &name[k++];
    while (!isspace (name[k]) && name[k] != '\0')
      k++;
    if (name[k] == '\0')
      break;
    name[k++] = '\0';
  }
  argv[num] = NULL;
}


/*******************************************************************************
 macht mit File das, was im execute-Dialog angegeben wurde
********************************************************************************/
void prog_start (Widget dialog, char *client_data, XmSelectionBoxCallbackStruct *cbs)
{
  int i = 0, k = 5;
  char *cla;
  char *argv[50];
  char name[2048];
  Boolean set;
 
  i = strlen (f_name); 
  cla = new char [i + 1];
  strcpy (cla, f_name);
  while (cla[i] != '/')
    i--;
  cla[i] = '\0';

  XtVaGetValues (toggle, XmNset, &set, NULL);

  if (!fork())
  {
    chdir (cla);
    if (set)
    {
      mk_argv (f_name, argv);
      i = 1;
    }
    else
    { 
      strcpy (name, table[0]);
      mk_argv (name, argv);

      i = 0;
      while (argv[i] != NULL)
        i++;

      argv[i++] = "-e";
      argv[i++] = f_name;
      argv[i] = NULL;
    }

    if (XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET, &cla))
    {
      k = 0;
      while (cla[k])
      {
        while (isspace (cla[k]))
          k++;
        if (cla[k] == '\0')
          break;
        argv[i++] = &cla[k++];
        while (!isspace (cla[k]) && cla[k] != '\0')
          k++;
        if (cla[k] == '\0')
          break;
        cla[k++] = '\0';
      }
      argv[i] = NULL;
    }

    if (set)
      execv (f_name, &argv[0]);
    else
      execv (name, &argv[0]);

    exit (1);
  }
  delete []cla;
  XtDestroyWidget (dialog);
}

/*******************************************************************************
 immer bei Doppelklick auf regulaeres Files bzw. einen Link darauf;
 prueft, ob Datei eine definierte Erweiterung besitzt, wenn ja,
 wird das zugehoerige Programm mit der Datei als Argument gestartet; 
 erzeugt Dialog fuer Ausfuehrung, falls es eine Programmdatei ist
********************************************************************************/
void execute (struct dir *help, int which)
{
  extern void destroy_dialog (Widget dialog, XtPointer o, XtPointer p);
  extern void position_dialog (Widget dialog, XtPointer o, XtPointer p);
  Widget dialog;
  XmString str = XmStringCreateSimple ("Command line arguments:");
  int len, i;
  char name[512]; 
  char *argv[50];

  strcpy (f_name, help->p.get_path());
  strcat (f_name, help->p.get_name (which));

  len = strlen (f_name);
  while (f_name[len] != '.' && f_name[len] != '/')
    len--;

  if (f_name[len] == '.')
  {
    for (i = 0; i < table_anz - 2; i++)
      if (!strcmp(&f_name[len+1], table[i * 2 + 4]))
      {
        strcpy (name, table[i * 2 + 5]);
        mk_argv (name,  argv);

        i = 0;
        while (argv[i] != NULL)
          i++;
        argv[i] = f_name;
        argv[i + 1] = NULL;

        if (!fork())
        {
          execv (name, &argv[0]); 
          exit (1);
        }
        return;
      }
  }
 
  if (!(help->p.get_st_mode (which) & 73) || (access (f_name, X_OK) == -1))
    return;

  dialog = XmCreatePromptDialog (pb2, "d_form", NULL, 0);
  XtVaSetValues (XtParent(dialog), XmNtitle, "Execute program",
				   XmNuserData, 0, 0);
  XtVaSetValues (dialog, XmNselectionLabelString, str,
                         XmNdefaultPosition, False,
                         XmNwidth, 250, NULL);
  XmStringFree (str);

  XtAddCallback (dialog, XmNokCallback, prog_start, NULL);
  XtAddCallback (dialog, XmNcancelCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);
  XtUnmanageChild (XmSelectionBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));

  toggle = XtVaCreateManagedWidget ("X program                        ",
                                     xmToggleButtonWidgetClass, dialog, 
                                     XmNalignment, XmALIGNMENT_BEGINNING, NULL, 0);
  XtVaSetValues (toggle, XmNset, True, 0);

  XtManageChild (dialog);
  XtPopup (XtParent(dialog), XtGrabNone);
};
