/*********************************************************
 Copyright (C) 1994 Patrick Voigt
*********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include "mdir.h" 

// ***************************** Compare values *******************************
int mdir::compare (int i, int j)
{
  switch (sort_case)
  {
   case 0: return 0;

   case 1: return strcmp (array_info[array[i]].name, array_info[array[j]].name);

   case 2: {
             if (array_info[array[i]].size >= array_info[array[j]].size) return 0;
             return 1;
           } 

   case 3: {
             if (array_info[array[i]].time >= array_info[array[j]].time) return 0;
             return 1;
           } 
  }
  return 0;
};

// ***************************** Sort Directory ********************************
void mdir::sort (int first, int last)
{
  register int i;
  register int j;
  int swap;

  if (first >= last) return;
 
  for (i = first, j = last; ; j--)
  {
    while (i != j && compare (i,j) <= 0)
      j--;
    if (i == j) 
      break;

    swap = array[i];
    array[i] = array[j];  
    array[j] = swap;  

    do
      i++;
    while (i != j && compare (i,j) <= 0);

    if (i == j) 
      break;

    swap = array[i];  
    array[i] = array[j];  
    array[j] = swap;  
  }
  sort (first, i-1);
  sort (i+1, last);
};

// ***************************** Constructor ********************************
mdir::mdir ()
{
  anz = 0;
  array = NULL;
  array_info = NULL;
  sort_case = 1;
};

// ***************************** Destructor *********************************
mdir::~mdir ()
{
  int i;

  for (i = 0; i < anz; i++)
    delete []array_info[i].name;
  delete [] path;
  delete [] array;
  delete [] array_info;
};

// ******************************* find file ********************************
int mdir::find_file (char *name)
{
  int i = 0;

  while (i < anz)
  {
    if (!strcmp (name, array_info[array[i]].name))
      return i;
    i++;
  }
  return -1;
}

// **************************** change sort_case ****************************
void mdir::change_sort (int w)
{
  if (w >= 0 && w <= 3)
  {
    sort_case = w;
    if (anz >= 4) sort (2, anz -1);
  }
};

// ************************ read directory contents *************************
void mdir::readmdir (char *p)
{
  struct DIR *pdir;
  struct dirent *pdirect;
  int i;

  if (array)
  {
    for (i = 0; i < anz; i++)
      delete []array_info[i].name;
    delete [] path;
    delete [] array;
    delete [] array_info;
  }

  path = new char[strlen(p) + 1];
  strcpy (path, p);
  pdir = opendir (p);

  i = 0;
  while (pdirect = readdir (pdir))
    i++;
  array = new int [i];
  array_info = new struct info [i];

  anz = i;

  i = 0;
  rewinddir (pdir); 

  while (pdirect = readdir (pdir))
  {
    array_info[i].name = new char[strlen(pdirect->d_name) + 1];
    strcpy (array_info[i].name, pdirect->d_name);
    array[i] = i;
    get_stat (i);
    array_info[i].size = x.st_size;
    array_info[i].time = x.st_mtime;
    array_info[i].mode = x.st_mode;

    if (S_ISREG(x.st_mode))
      array_info[i].type = IS_REG;
    else
      if (S_ISDIR(x.st_mode))
        array_info[i].type = IS_DIR;
      else
        if (S_ISCHR(x.st_mode))
          array_info[i].type = IS_CHR;
        else
          if (S_ISBLK(x.st_mode))
            array_info[i].type = IS_BLK;
          else
            if (S_ISFIFO(x.st_mode))
              array_info[i].type = IS_FIFO;
	    else
              if (S_ISSOCK(x.st_mode))
                array_info[i].type = IS_SOCK;
	      else
                if (S_ISLNK(x.st_mode))
                {
                  char name[2048];
                  strcpy (name, path);
                  strcat (name, array_info[i].name);
                  if (stat (name, &x) == -1)
		    array_info[i].type = IS_LNKN;
		  else
                    if (S_ISDIR(x.st_mode))
                      array_info[i].type = IS_LNKD;
		    else
                      if (S_ISREG(x.st_mode))
                        array_info[i].type = IS_LNKR;
		      else
			array_info[i].type = IS_LNKO;
                };
    i++;
  } 
  closedir (pdir);
  if (anz >= 4) sort (2, anz - 1);
};

// *************************** return filename ******************************
char *mdir::get_name (int w)
{
  if (w >= anz)
    return NULL;
  return array_info[array[w]].name;
};

// *************************** get fileinfos ********************************
struct stat *mdir::get_stat (int w)
{
  char name[2048];
  strcpy (name, path);
  strcat (name, get_name (w));
  lstat (name, &x);
  return &x;
};

int mdir::get_st_type (int w)
{
  return array_info[array[w]].type;
};

off_t mdir::get_st_size (int w)
{
  return array_info[array[w]].size;
};

time_t mdir::get_st_mtime (int w)
{
  return array_info[array[w]].time; 
};

int mdir::get_st_mode (int w)
{
  return array_info[array[w]].mode;
};
