/*********************************************************
 Copyright (C) 1994 Patrick Voigt
*********************************************************/

#include <dirent.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <Xm/ScrolledW.h>
#include <Xm/MessageB.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/List.h>
#include <Xm/ToggleB.h>
#include <Xm/SeparatoG.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>

#include "fm.h"
#include "dd.h"

extern Widget mainw, form, pb2;
extern struct dir *v_head;
extern struct dir *v_actual;
extern int list_nr;
extern char f_name[2048];
extern int timer_id;
extern Pixmap pixmaps[10];

static Widget toggle[12];
static char **files;
static Boolean is_icon;
static  char not_del[4096];


/********************************************************************************
 Positionierung eines Dialogs
********************************************************************************/
void position_dialog (Widget dialog, XtPointer o, XtPointer p)
{
  Dimension a_width, a_height, d_width, d_height;
  Position x, y;

  XtVaGetValues (mainw, XmNwidth, &a_width, 
                        XmNheight, &a_height,
                        XmNx, &x, XmNy, &y, NULL);
  XtVaGetValues (dialog, XmNwidth, &d_width, 
                         XmNheight, &d_height, NULL);
  x += (a_width - d_width) / 2;
  y += (a_height - d_height) / 2;

  XtVaSetValues (dialog, XmNx, x, XmNy, y, NULL);
}

/********************************************************************************
 Zerstoerung eines Dialogs
********************************************************************************/
void destroy_dialog (Widget dialog, XtPointer o, XtPointer p)
{
  XtDestroyWidget (dialog);
}

/********************************************************************************
 erzeugt Fehlerdialog
********************************************************************************/
void mk_error_dialog (int which)
{
  Widget dialog, text;
  XmString str;
  char *err_list[] = { "Could not delete the following files:",
                        "Could not copy the following files:",
                        "Could not move the following files:"
                      };
  Arg args[10];
  int i;

  str = XmStringCreateLtoR (err_list[which], XmSTRING_DEFAULT_CHARSET);

  i = 0;
  XtSetArg (args[i], XmNmessageString, str); i++;
  XtSetArg (args[i], XmNdefaultPosition, False); i++;
  XtSetArg (args[i], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL); i++;
  XtSetArg (args[i], XmNnoResize, True); i++;
  XtSetArg (args[i], XmNsymbolPixmap, pixmaps[9]); i++;

  dialog = XmCreateInformationDialog (pb2, "err_dialog", args, i);

  XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
  XtVaSetValues (XtParent(dialog), XmNtitle, "Errors occured", 0);

  XmStringFree (str);

  XtAddCallback (dialog, XmNokCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNcancelCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);

  i = 0;
  XtSetArg (args[i], XmNscrollVertical, True); i++;
  XtSetArg (args[i], XmNscrollHorizontal, False); i++;
  XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT), i++;
  XtSetArg (args[i], XmNeditable, False); i++;
  XtSetArg (args[i], XmNcursorPositionVisible, False); i++;
  XtSetArg (args[i], XmNwordWrap, True); i++;
  XtSetArg (args[i], XmNvalue, not_del); i++;
  XtSetArg (args[i], XmNrows, 7); i++;

  text = XmCreateScrolledText (dialog, "text", args, i);
  XtManageChild (text); 

  XtManageChild (dialog);
  XtPopup (XtParent(dialog), XtGrabNone);
}

/********************************************************************************
 Loeschen von Files
 nach Druecken von Ok im Deletedialog
********************************************************************************/
void delete_files (Widget dialog, char *path, XtPointer p)
{
  extern void busy_cursor (Widget w, Boolean busy);
  char name[2048];
  int i;

  busy_cursor (dialog, True);

  not_del[0] = '\0';
  i = 0;
  do
  {
    strcpy (name, "rm -rf '");
    strcat (name, path);
    if (files)
      strcat (name, files[i]);
    strcat (name, "' 2> /dev/null");

    if (system (name))
    {
      name[strlen(name)-13] = '\0';
      strcat (not_del, &name[7]);
      strcat (not_del, "\n");
    }
    
    if (files == NULL)
      break;
    i++;
  } while (files[i]);

  if (not_del[0] != '\0')
    mk_error_dialog (0);

  if (files == NULL)
    delete []path;
  else
  {
    i = 0;
    while (files[i])
      delete []files[i++];
    delete []files;
    delete []path;
  }

  XtDestroyWidget (dialog);
  busy_cursor (mainw, False);
  XtRemoveTimeOut (timer_id);
  time_check(0, 0);
  list_info();
}
 
/********************************************************************************
 Loeschen von Files
 bei Drop auf Recycling Icon
********************************************************************************/
void dd_delete (char *path, char **names, int count)  
{
  XmString quest;
  Widget form, dialog, textf;
  char question[512];
  int i;
  Arg args[6];
  XEvent event;

  files = names;

  if ((count == 0) && (strlen (path) == 1))
  {
    fprintf (stderr, "Sorry, but I don't try to delete the root directory!\n");
    delete []path;
    return;
  }

  strcpy (question, "Really delete ");

  strcpy (f_name, path);
  switch (count)
  {
    case 0:  strcat (question, "the directory           ");
             break;

    case 1:  strcat (question, "the file                ");
             strcat (f_name, files[0]);
             break;

    default: if (count < 10)
               i = 2;
             else 
               if (count < 100)
                 i = 1;
               else
                 i = 0;
             sprintf (&question[14], "%3d", count);
             memmove (&question[14], &question[14 + i], 3);
             strcat (question, " files in the directory  ");
  }

  quest = XmStringCreateLtoR (question, XmSTRING_DEFAULT_CHARSET);

  i = 0;
  XtSetArg (args[i], XmNmessageString, quest); i++;
  XtSetArg (args[i], XmNdefaultPosition, False); i++;
  XtSetArg (args[i], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL); i++;
  XtSetArg (args[i], XmNautoUnmanage, False); i++;
  XtSetArg (args[i], XmNnoResize, True); i++;
  XtSetArg (args[i], XmNsymbolPixmap, pixmaps[8]); i++;

  dialog = XmCreateQuestionDialog (pb2, "dialog", args, i);
  XtVaSetValues (XtParent(dialog), XmNtitle, "Delete files", 0);

  XmStringFree (quest);
  XtUnmanageChild (XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
  XtAddCallback (dialog, XmNokCallback, delete_files, path);
  XtAddCallback (dialog, XmNcancelCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);

  form = XtVaCreateManagedWidget ("form", xmFormWidgetClass, dialog, NULL);
  textf = XtVaCreateManagedWidget ("textf1", xmTextFieldWidgetClass, form,
	                             XmNshadowThickness, 1,
	                             XmNleftAttachment, XmATTACH_FORM,
	                             XmNleftOffset, 50,
	                             XmNvalue, f_name,
	                             XmNeditable, False,
	                             XmNwidth, 270, NULL);

  XtCallActionProc (textf, "forward-word", &event, NULL, 0); 

  XtManageChild (dialog);
  XtPopup (XtParent(dialog), XtGrabNone);
}

/********************************************************************************
 Kopieren / Verschieben von Files
 nach Druecken von Copy / Move im Transferdialog
********************************************************************************/
void transfer_files (Widget dialog, XtPointer client_data, XtPointer p)
{
  extern void busy_cursor (Widget w, Boolean busy);
  extern struct drag_icon *i_head;
  struct drag_icon *help, *pre_help;
  char name[2048];
  int i;
  char *path;
  int how = (int) client_data;

  busy_cursor (dialog, True);
  XtVaGetValues (dialog, XmNuserData, &path, NULL);

  not_del[0] = '\0';
  i = 0;
  do
  {
    if (how)
      strcpy (name, "mv    '");
    else
      strcpy (name, "cp -r '");
    strcat (name, path);
    if (files)
      strcat (name, files[i]);
    strcat (name, "' ");
    strcat (name, f_name);

   if (system (name))
    {
      name[strlen(name)-13] = '\0';
      strcat (not_del, &name[7]);
      strcat (not_del, "\n");
    }

    if (files == NULL)
      break;
    i++;
  } while (files[i]);

  if (not_del[0] != '\0')
    mk_error_dialog (how + 1);

  if (is_icon)
  {
    help = i_head;
    help = help->next->next;
    pre_help = i_head->next;

    while (strcmp (help->path, path))
    {
      pre_help = help;
      help = help->next;
    }
    pre_help->next = help->next;
    delete_icon (help);
  }
  else
  {
    if (files == NULL)
      delete []path;
    else
    {
      i = 0;
      while (files[i])
        delete []files[i++];
      delete []files;
      delete []path;
    }
  }

  XtDestroyWidget (dialog);
  busy_cursor (mainw, False);
  XtRemoveTimeOut (timer_id);
  time_check(0, 0);
  list_info();
}

/********************************************************************************
 Kopieren / Verschieben von Files
 nach Drop auf Listwidget
 *******************************************************************************/
void dd_transfer (char *path, char **names, int count, int target, Boolean icon)
{
  Widget dialog, form, textf1, label, textf2;
  XmString str, str1, str2, str3;
  struct dir *help = v_head;
  int i;
  Arg args[10];
  XEvent event;

  files = names;
  is_icon = icon;

  switch (count)
  {
    case 0:  strcpy (f_name, "Transfer the directory              ");
             break;

    case 1:  strcpy (f_name, "Transfer the file                   ");
             break;

    default: if (count < 10)
               i = 2;
             else 
               if (count < 100)
                 i = 1;
               else
                 i = 0;
             strcpy (f_name, "Transfer   ");
             sprintf (&f_name[9], "%3d", count);
             memmove (&f_name[9], &f_name[9 + i], 3);
             strcat (f_name, " files from the directory");
  }

  str = XmStringCreateLtoR (f_name, XmSTRING_DEFAULT_CHARSET);
  str1 = XmStringCreateSimple ("Copy");
  str2 = XmStringCreateSimple ("Move");
  str3 = XmStringCreateSimple ("Cancel");

  i = 0;
  XtSetArg (args[i], XmNmessageString, str); i++;
  XtSetArg (args[i], XmNdefaultPosition, False); i++;
  XtSetArg (args[i], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL); i++;
  XtSetArg (args[i], XmNautoUnmanage, False); i++;
  XtSetArg (args[i], XmNnoResize, True); i++;
  XtSetArg (args[i], XmNsymbolPixmap, pixmaps[7]); i++;
  XtSetArg (args[i], XmNokLabelString, str1); i++;
  XtSetArg (args[i], XmNcancelLabelString, str2); i++;
  XtSetArg (args[i], XmNhelpLabelString, str3); i++;
  XtSetArg (args[i], XmNuserData, path); i++;
 
  dialog = XmCreateInformationDialog (pb2, "transfer_dialog", args, i);
  XtVaSetValues (XtParent(dialog), XmNtitle, "Transfer", NULL);

  XmStringFree (str);
  XmStringFree (str1);
  XmStringFree (str2);
  XmStringFree (str3);

  strcpy (f_name, path);
  if (count == 1)
    strcat (f_name, files[0]);

  for (i = -1; i > target; i--)
    help = help->next;

  form = XtVaCreateManagedWidget ("form", xmFormWidgetClass, dialog, NULL);

  textf1 = XtVaCreateManagedWidget ("textf1", xmTextFieldWidgetClass, form,
	                             XmNshadowThickness, 1,
				     XmNleftAttachment, XmATTACH_FORM,
	                             XmNleftOffset, 50,
	                             XmNvalue, f_name,
	                             XmNeditable, False,
	                             XmNwidth, 255, NULL);

  XtCallActionProc (textf1, "forward-word", &event, NULL, 0); 

  label = XtVaCreateManagedWidget ("to:", xmLabelWidgetClass, form,
				     XmNleftAttachment, XmATTACH_FORM,
	                             XmNtopAttachment, XmATTACH_WIDGET,
	                             XmNtopWidget, textf1,
	                             XmNtopOffset, 20,
	                             XmNleftOffset, 13, NULL);

  textf2 = XtVaCreateManagedWidget ("textf2", xmTextFieldWidgetClass, form,
	                             XmNshadowThickness, 1,
				     XmNleftAttachment, XmATTACH_WIDGET,
				     XmNleftWidget, label,
	                             XmNleftOffset, 12,
	                             XmNtopOffset, 15,
	                             XmNvalue, help->p.get_path(),
	                             XmNeditable, False,
	                             XmNwidth, 255,
	                             XmNtopAttachment, XmATTACH_WIDGET,
	                             XmNtopWidget, textf1, NULL);

  XtCallActionProc (textf2, "forward-word", &event, NULL, 0); 

  strcpy (f_name, help->p.get_path());

  XtAddCallback (dialog, XmNokCallback, transfer_files, (XtPointer) 0);
  XtAddCallback (dialog, XmNcancelCallback, transfer_files, (XtPointer) 1);
  XtAddCallback (dialog, XmNhelpCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);

  XtManageChild (dialog);
  XtPopup (XtParent(dialog), XtGrabNone);
}

/********************************************************************************
  wird von den Toggle-Buttons des Dialogs aus dd_info gerufen
  setzt nur Sensitiviaet des Ok-Button des Dialogs auf True
********************************************************************************/
void toggled (Widget w, Widget dialog, XmToggleButtonCallbackStruct *toggle_data)
{
  XtSetSensitive (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON), True);
};

/********************************************************************************
  Callback-Routine des Ok-Button des Info Dialogs
  liest die Werte der Toggle-Buttons und setzt dementsprechend permissions
********************************************************************************/
void apply_cb (Widget dialog, XtPointer cl_data, XtPointer *call_data)
{
  int client_data = (int) cl_data;
  int perms = client_data & ~4095;
  int i;
  int tab[] = {256,128,64,32,16,8,4,2,1,2048,1024,512};
  Boolean set;
  struct dir *pre_help, *help;
 
  for (i = 11; i >= 0; i--)
  {
    XtVaGetValues (toggle[i], XmNset, &set, NULL);
    if (set)
      perms |= tab[i]; 
  }
  chmod (f_name, perms); 
  i = strlen (f_name);
  while (f_name[i] != '/')
    i--;
  f_name[i+1] = '\0';

  pre_help = help = v_head;
  while (help->next)
  {
    pre_help = help;
    help = help->next;
  }

  if (!strcmp (f_name, help->p.get_path()))
  {
    if (pre_help == help)
    {
      delete_list (v_head); 
      v_head = v_actual = create_list (f_name, form, ++list_nr, True);
    }
    else
    {
      delete_list (help);
      pre_help->next = v_actual = create_list (f_name, pre_help->scroll, ++list_nr, True);
    }
  }
  XtDestroyWidget (dialog);
}

/********************************************************************************
  erzeugt Dialog mit allen Infos ueber das File
  nach Drop auf Info Pixmap (Label)
********************************************************************************/
void dd_info (Widget drag_source, char *file)
{
  struct dir *help;
  Widget dialog, d_form, rowcol, rowcol1, rowcol2, separator[2],
         label[14], label1[5], label2[5];
  int i, j, k;
  XEvent event;
  struct stat *f_stat;
  char *list[] = { "File: ", "File type: ", "Owner: ", "Group: ", "Links: ", "Size: ",
		   "Last access: ", "Last modification: ", "Last status change: " };
  char *p_list[] = { "owner ", "group ", "world " };
  char *link_list[] = { "directory               ",
                        "regular file            ",
                        "character special file  ",
                        "block special file      ",
                        "FIFO                    ",
                        "socket                  ",
                        "Link to directory       ",
                        "Link to regular file    ",
                        "Link                    ",
                        "Link to nonexistent file",
                        "???                     " };
  char *info_list[9];
  char links[4];
  char size[10];
  char a_time[30];
  char m_time[30];
  char c_time[30];
  XmString ok_str;
  char name[2048];
  int pos, mode;

  struct passwd *pw; 
  struct group *gr; 

//  struct passwd *pw, *getpwuid (); 
//  struct group *gr, *getgrgid (); 

  help = v_head;
  while (help->list != drag_source)
    help = help->next;

  if (!strcmp (help->p.get_path(), file))
    file = ".";
  else
  {
    i = strlen (file) - 2;
    while (i >= 0 && file[i] != '/')
      i--;

    if (file[i] == '/')
    {
      file[strlen(file) - 1] = '\0';
      file = &file[i + 1];
    }
  } 

  strcpy (f_name, help->p.get_path());
  strcat (f_name, file);

  pos = help->p.find_file (file);

  f_stat = help->p.get_stat (pos);

  info_list[0] = file;

  info_list[1] = link_list[help->p.get_st_type (pos) - 1];

  if ((pw = getpwuid (f_stat->st_uid)) == NULL)
    info_list[2] = "???";
  else
    info_list[2] = pw->pw_name;

  if ((gr = getgrgid (f_stat->st_gid)) == NULL)
    info_list[3] = "???";
  else
    info_list[3] = gr->gr_name;

  sprintf (links, "%3d", f_stat->st_nlink);
  i = 0; 
  while (links[i] == ' ')
    i++;
  info_list[4] = &links[i];

  sprintf (size, "%9d", f_stat->st_size);
  i = 0; 
  while (size[i] == ' ')
    i++;
  info_list[5] = &size[i];

  strcpy (a_time, asctime (localtime (&f_stat->st_atime)));
  i = strlen (a_time);
  a_time[i - 1] = '\0';
  info_list[6] = a_time;
  strcpy (m_time, asctime (localtime (&f_stat->st_mtime)));
  m_time[i - 1] = '\0';
  info_list[7] = m_time;
  strcpy (c_time, asctime (localtime (&f_stat->st_ctime)));
  c_time[i - 1] = '\0';
  info_list[8] = c_time;

  mode = f_stat->st_mode;

  dialog = XmCreateMessageDialog (pb2, "dialog", NULL, 0);
  XtVaSetValues (XtParent(dialog), XmNtitle, "File information", 0);
  XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
  XtAddCallback (dialog, XmNokCallback, apply_cb, (XtPointer) mode);
  XtAddCallback (dialog, XmNcancelCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);
  XtVaSetValues (dialog, XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
                         XmNnoResize, True,
                         XmNdefaultPosition, False, NULL);

  d_form = XtVaCreateManagedWidget ("d_form", xmFormWidgetClass, dialog, NULL, 0);

  rowcol = XtVaCreateManagedWidget ("rowcol", xmRowColumnWidgetClass, d_form,
                                              XmNtopAttachment, XmATTACH_FORM,
                                              XmNpacking, XmPACK_COLUMN,
                                              XmNisAligned, False,
                                              XmNnumColumns, 2,
                                              XmNorientation, XmHORIZONTAL, 0);

  label2[0] = XtVaCreateManagedWidget (list[0], xmLabelWidgetClass, rowcol,
                                       XmNalignment, XmALIGNMENT_END, 0);

  if (help->p.get_st_type (pos) >= IS_LNKD)
  {
    strcpy (name, " -> ");

    k = readlink (f_name, &name[4], 2040);
    name[k + 4] = '\0';
    strcat (f_name, name);
  }
  label2[1] = XtVaCreateManagedWidget ("file", xmTextFieldWidgetClass, rowcol,
	                               XmNshadowThickness, 1,
	                               XmNeditable, False,
                                       XmNvalue, f_name, NULL);
  XtCallActionProc (label2[1], "forward-word", &event, NULL, 0); 
  XtCallActionProc (label2[1], "forward-word", &event, NULL, 0); 

  label2[2] = XtVaCreateManagedWidget (list[1], xmLabelWidgetClass, rowcol,
                                       XmNalignment, XmALIGNMENT_END, 0);

  label2[3] = XtVaCreateManagedWidget (info_list[1], xmLabelWidgetClass, rowcol,
                                       XmNalignment, XmALIGNMENT_BEGINNING, 0);

  separator[0] = XtVaCreateManagedWidget ("", xmSeparatorGadgetClass, d_form,
					      XmNleftAttachment, XmATTACH_FORM,
					      XmNrightAttachment, XmATTACH_FORM,
                                              XmNtopAttachment, XmATTACH_WIDGET,
				     	      XmNtopWidget, rowcol, NULL);

  rowcol1 = XtVaCreateManagedWidget ("rowco1", xmRowColumnWidgetClass, d_form,
                                                XmNtopOffset, 10,
					        XmNpacking, XmPACK_COLUMN,
					        XmNisAligned, False,
                                                XmNtopAttachment, XmATTACH_WIDGET,
				     	        XmNtopWidget, separator[0],
					        XmNnumColumns, 7,
			 		        XmNorientation, XmHORIZONTAL, 0);
  for (i = 2; i <= 8; i++)
  {
    label[i-2] = XtVaCreateManagedWidget (list[i], xmLabelWidgetClass, rowcol1,
					           XmNalignment, XmALIGNMENT_END, 0);
    label[i+5] = XtVaCreateManagedWidget (info_list[i], xmLabelWidgetClass, rowcol1,
					  XmNalignment, XmALIGNMENT_BEGINNING, 0);
  }

  label2[4] = XtVaCreateManagedWidget ("            ", xmLabelWidgetClass, d_form,
                                           XmNtopAttachment, XmATTACH_WIDGET,
				     	   XmNtopWidget, rowcol1, NULL);

  separator[1] = XtVaCreateManagedWidget ("sep", xmSeparatorGadgetClass, d_form,
					         XmNleftAttachment, XmATTACH_FORM,
					         XmNrightAttachment, XmATTACH_FORM,
                                                 XmNtopAttachment, XmATTACH_WIDGET,
				     	         XmNtopWidget, label2[4], NULL);

  label1[3] = XtVaCreateManagedWidget ("            read        write      execute", 
						xmLabelWidgetClass, d_form,
				                XmNtopOffset, 10,
						XmNleftAttachment, XmATTACH_FORM,
				     		XmNtopAttachment, XmATTACH_WIDGET,
				     		XmNtopWidget, separator[1], NULL);

  rowcol2 = XtVaCreateManagedWidget ("rowcol2", xmRowColumnWidgetClass, d_form,
				     		XmNtopAttachment, XmATTACH_WIDGET,
				     		XmNtopWidget, label1[3],
				     		XmNisAligned, False,
				     		XmNpacking, XmPACK_COLUMN,
				     		XmNnumColumns, 3,
			 	     		XmNorientation, XmHORIZONTAL, 0);
  k = 0;
  for (i = 0; i <= 2; i++)
  {
    label1[i] = XtVaCreateManagedWidget (p_list[i], xmLabelWidgetClass, rowcol2, 0);
    for (j = 0; j <= 2; j++)
    {
      toggle[k + j] = XtVaCreateManagedWidget ("         ", xmToggleButtonWidgetClass,
                                               rowcol2, XmNalignment,
				     	       XmALIGNMENT_CENTER, 0);
      XtAddCallback (toggle[k + j], XmNvalueChangedCallback, toggled, dialog);
      if (mode & 256)
        XtVaSetValues (toggle[k + j], XmNset, True, 0);
      mode <<= 1;
    }
    k = k + 3;
  }

  label1[4] = XtVaCreateManagedWidget ("            uid          gid      save text",
						xmLabelWidgetClass, d_form,
				                XmNtopOffset, 10,
						XmNleftAttachment, XmATTACH_FORM,
				     		XmNtopAttachment, XmATTACH_WIDGET,
				     		XmNtopWidget, rowcol2, 0);

  toggle[9] = XtVaCreateManagedWidget ("         ", xmToggleButtonWidgetClass, d_form,
				       XmNleftOffset, 88,
				       XmNalignment, XmALIGNMENT_CENTER,
				       XmNtopAttachment, XmATTACH_WIDGET,
				       XmNleftAttachment, XmATTACH_FORM,
				       XmNtopWidget, label1[4], 0);

  toggle[10] = XtVaCreateManagedWidget ("         ", xmToggleButtonWidgetClass, d_form,
				       XmNleftOffset, 5,
				       XmNalignment, XmALIGNMENT_CENTER,
				       XmNtopAttachment, XmATTACH_WIDGET,
				       XmNleftAttachment, XmATTACH_WIDGET,
				       XmNleftWidget, toggle[9],
				       XmNtopWidget, label1[4], 0);

  toggle[11] = XtVaCreateManagedWidget ("         ", xmToggleButtonWidgetClass, d_form,
				       XmNleftOffset, 3,
				       XmNalignment, XmALIGNMENT_CENTER,
				       XmNtopAttachment, XmATTACH_WIDGET,
				       XmNleftAttachment, XmATTACH_WIDGET,
				       XmNleftWidget, toggle[10],
				       XmNtopWidget, label1[4], 0);

  mode = f_stat->st_mode;
  for (i = 9; i <= 11; i++)
  {
    XtAddCallback (toggle[i], XmNvalueChangedCallback, toggled, dialog);
    if (mode & 2048)
      XtVaSetValues (toggle[i], XmNset, True, 0);
    mode <<= 1;
  }

  k = getuid();
  if (k == 0 || k == f_stat->st_uid)
  {
    ok_str = XmStringCreateSimple ("Apply");
    XtVaSetValues (dialog, XmNokLabelString, ok_str, 0);
    XmStringFree (ok_str);
    XtSetSensitive (XmMessageBoxGetChild (dialog, XmDIALOG_OK_BUTTON), False);
    if (k != 0)
      XtSetSensitive (toggle[11], False); 
  }
  else
    for (i = 0; i <= 11; i++)
      XtSetSensitive (toggle[i], False);
 
  XtManageChild (dialog);
  XtPopup (XtParent(dialog), XtGrabNone);
};
