#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/DrawnB.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/DragDrop.h>

#include "arrow_in.xbm"

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif

Atom ATOM_STRING, ATOM_PIXMAP, ATOM_INTEGER, ATOM_LABEL;
Widget toplevel, form, db, st, label;

void registerDropSite( 
#if NeedFunctionPrototypes
	Widget 
#endif
);
void HandleDrop( 
#if NeedFunctionPrototypes
	Widget, XtPointer, XtPointer 
#endif
);
Boolean DragConvertProc( 
#if NeedFunctionPrototypes
	Widget, Atom *, Atom *, Atom *, XtPointer *,
        unsigned long *, int *, unsigned long *, XtPointer, XtRequestId* 
#endif
);


main( argc, argv )
  int argc;
  char **argv;
{
  XtAppContext appContext;
  Pixmap p;
  Pixel fg, bg;

  toplevel = XtVaAppInitialize( &appContext, "sampleDropSite",
	NULL, 0, &argc, argv, NULL, 
	XmNwidth, 350,
        XmNheight, 300,
	NULL );
  XtRealizeWidget( toplevel );

  form = XtVaCreateManagedWidget( "form", 
	xmFormWidgetClass, toplevel, 
	NULL );

  st = XmCreateScrolledText( form, "st", NULL, 0 );
  XtVaSetValues( XtParent(st),
	XmNtopAttachment, XmATTACH_FORM,
        XmNtopOffset, 140,
        XmNbottomAttachment, XmATTACH_FORM,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_FORM,
	NULL );
  XtManageChild( st );

  db = XtVaCreateManagedWidget( "db", 
	xmDrawnButtonWidgetClass, form,
	XmNtopAttachment, XmATTACH_FORM,
	XmNtopOffset, 40,
	XmNbottomAttachment, XmATTACH_WIDGET, 
	XmNbottomWidget, st,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 100,
	XmNrightAttachment, XmATTACH_FORM, 
	XmNrightOffset, 100,
	XmNlabelType, XmPIXMAP, 
	NULL );
  registerDropSite( db );

  label = XtVaCreateManagedWidget( "file label",
	xmLabelWidgetClass, form,
	XmNtopAttachment, XmATTACH_FORM,
	XmNtopOffset, 5,
	XmNbottomAttachment, XmATTACH_WIDGET,
        XmNbottomWidget, db,
	XmNleftAttachment, XmATTACH_FORM,
        XmNleftOffset, 50,
        XmNrightAttachment, XmATTACH_FORM,
        XmNrightOffset, 50,
	XmNborderWidth, 1,
	NULL );

  XtVaGetValues( db, XmNforeground, &fg, XmNbackground, &bg, NULL );
  p = XCreatePixmapFromBitmapData( XtDisplay(db),
        DefaultRootWindow(XtDisplay(db)), arrow_in_bits,
        arrow_in_width, arrow_in_height, fg, bg,
        DefaultDepthOfScreen( XtScreen(db) ) );
  XtVaSetValues( db, XmNlabelPixmap, p, NULL );

  XtAppMainLoop( appContext );
}

void registerDropSite( w )
  Widget w;
{
  Atom importList[4];
  Arg args[6];

  ATOM_STRING = XmInternAtom( XtDisplay(w), "STRING", False );
  ATOM_PIXMAP = XmInternAtom( XtDisplay(w), "PIXMAP", False );
  ATOM_INTEGER = XmInternAtom( XtDisplay(w), "INTEGER", False );
  ATOM_LABEL = XmInternAtom( XtDisplay(w), "COMPOUND_TEXT", False );

  importList[0] = ATOM_LABEL;
  importList[1] = ATOM_INTEGER;
  importList[2] = ATOM_PIXMAP;
  importList[3] = ATOM_STRING;

  XtSetArg( args[0], XmNdropSiteOperations, XmDROP_COPY );
  XtSetArg( args[1], XmNnumImportTargets, 4 );
  XtSetArg( args[2], XmNimportTargets, importList );
  XtSetArg( args[3], XmNanimationStyle, XmDRAG_UNDER_SHADOW_IN );
  XtSetArg( args[4], XmNdropProc, HandleDrop );
  XmDropSiteRegister( w, args, 5 );
}

void TransferProc( w, closure, seltype, type, value, length, format )
  Widget w;
  XtPointer closure, value;
  Atom *seltype, *type;
  unsigned long *length;
  int format;
{
  char buff[1056];

  if( *type == ATOM_STRING )
  {
    sprintf( buff, "FILES = %s\n", (char *)value );
    XmTextInsert( st, XmTextGetLastPosition(st), buff );
  }
  else if( *type == ATOM_INTEGER )
  {
    sprintf( buff, "NUMBER OF FILES = %d\n", *((int *)value) );
    XmTextInsert( st, XmTextGetLastPosition(st), buff );
  }
  else if( *type == ATOM_PIXMAP )
  {
    XtVaSetValues( db, XmNlabelPixmap, *((Pixmap *)value), NULL );
  }
  else if( *type == ATOM_LABEL )
  {
    XmString xms;
    xms = XmStringCreateSimple( (char *)value );
    XtVaSetValues( label, XmNlabelString, xms, NULL );
    XmStringFree( xms );

    XmTextSetString( st, "" );
  }
}

void HandleDrop( w, client_data, call_data )
  Widget w;
  XtPointer client_data, call_data;
{
  XmDropProcCallback DropData;
  XmDropTransferEntryRec transferEntries[4];
  XmDropTransferEntry transferList;
  Cardinal n = 0;
  Arg args[5];

  DropData = ( XmDropProcCallback )call_data;

  if( DropData->dropAction != XmDROP )
  {
    XtSetArg( args[n], XmNtransferStatus, XmTRANSFER_FAILURE );  n++;
  }
  else if( DropData->operation == XmDROP_NOOP )
  {
    XtSetArg( args[n], XmNtransferStatus, XmTRANSFER_FAILURE );  n++;
  }
  else
  {
    transferEntries[0].target = ATOM_LABEL;
    transferEntries[0].client_data = (XtPointer) w;
    transferEntries[1].target = ATOM_INTEGER;
    transferEntries[1].client_data = (XtPointer) w;
    transferEntries[2].target = ATOM_PIXMAP;
    transferEntries[2].client_data = (XtPointer) w;
    transferEntries[3].target = ATOM_STRING;
    transferEntries[3].client_data = (XtPointer) w;
    transferList = transferEntries;
    XtSetArg( args[n], XmNnumDropTransfers, 4 );  n++;
    XtSetArg( args[n], XmNdropTransfers, transferList );  n++;
    XtSetArg( args[n], XmNtransferProc, TransferProc );  n++;
  }

  XmDropTransferStart( DropData->dragContext, args, n );
}
