#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include "clock.au.str"

#define AUDIO_DEVICE "/dev/audio"

pid_t play_sound()
{
  int fd;
  pid_t pid;

  if ((pid= vfork())<0)
  {
    printf("play_sound() vfork error\n");
    return (0);
  }
  else if (pid>0)
  {
    printf("\n%d playing", pid);
    if ((fd= open(AUDIO_DEVICE, O_WRONLY))==-1)
      exit(0);
    write(fd, sound_bits, sound_len);
    close(fd);
    exit (0);
  }
  return (pid);
}
