#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

main(argc, argv)
int argc;
char *argv[];
{
  char i_file[255], o_file[255];
  FILE *i_fp, *o_fp;
  struct stat statbuf;
  int i, len;

  if (argc<2)
  {
    puts("No input file?");
    exit(1);
  }

  strcpy(i_file, argv[1]);
  strcpy(o_file, i_file);  strcat(o_file, ".str");

  if (!(i_fp= fopen(i_file, "rb")))
  {
    printf("Can't open input file '%s'\n", i_file);
    exit(1);
  }
  if (!(o_fp= fopen(o_file, "w")))
  {
    printf("Can't create output file '%s'\n", o_file);
    exit(1);
  }
  
  stat(i_file, &statbuf);
  len= statbuf.st_size;
  
  fprintf(o_fp, "#define sound_len %d\n", len);
  
  fputs("\nstatic char sound_bits[]= {\n   ", o_fp);
  
  for (i=1; i<len; i++)
  {
    fprintf(o_fp, "0x%02x, ", (unsigned char)getc(i_fp));
    if (!(i%12))
      fputs("\n   ", o_fp);
  }
  fprintf(o_fp, "0x%02x };\n", (unsigned char)getc(i_fp));
  
  fclose(i_fp);
  fclose(o_fp);
}
