/* complex.c */
/* Daniel F. Smith, 1993 */
/* Complex math library
 * These routines are not as robust as the routines in
 * Numerical Recipes in C, but should work as well in practice.
 */
#include <math.h>
#include "complex.h"

complex cmul(complex a,complex b) {
	complex r;
	r.x=a.x*b.x - a.y*b.y;
	r.y=a.y*b.x + a.x*b.y;
	return r;
	}

complex cdiv(complex a,complex b) {
	cfloat d;
	complex r;
	d=b.x*b.x + b.y*b.y;
	r.x=(a.x*b.x + a.y*b.y)/d;
	r.y=(a.y*b.x - a.x*b.y)/d;
	return r;
	}

complex cadd(complex a,complex b) {
	complex r;
	r.x=a.x+b.x;
	r.y=a.y+b.y;
	return r;
	}

complex csub(complex a,complex b) {
	complex r;
	r.x=a.x-b.x;
	r.y=a.y-b.y;
	return r;
	}

/* If required, the program can #undef cmod */
cfloat cmod(complex a) {
	return sqrt(a.x*a.x + a.y*a.y);
	}

/* If required, the program can #undef cmod2 */
cfloat cmod2(complex a) {
	return a.x*a.x + a.y*a.y;
	}

complex cexp(complex a) {
	double e;
	complex r;
	e=exp(a.x);
	r.x=e*cos(a.y);
	r.y=e*sin(a.y);
	return r;
	}

complex cgen(cfloat x,cfloat y) {
	complex r;
	r.x=x;
	r.y=y;
	return r;
	}

complex cscale(cfloat c,complex z) {
	complex r;
	r.x=c*z.x;
	r.y=c*z.y;
	return r;
	}

complex conj(complex z) {
	complex r;
	r.x= z.x;
	r.y=-z.y;
	return r;
	}

