/* > ChartP.h */
/* Daniel F. Smith, 1994 */
/* Chart widget, based on TemplateP.h */

#ifndef _ChartP_h
#define _ChartP_h

#include "Chart.h"
/* include superclass private header file */
#include <X11/CoreP.h>

/* define unique representation types not found in <X11/StringDefs.h> */

#define XtRChartResource "ChartResource"

typedef struct {
	int dummy;
	} ChartClassPart;

typedef struct _ChartClassRec {
	CoreClassPart	core_class;
	ChartClassPart	chart_class;
	} ChartClassRec;

extern ChartClassRec chartClassRec;

typedef struct {
	/* public resources */
	Pixel fg,gridcolour;     /* English color */
	int grid;                /* gridlines interval, 0=no grid */
	int xscale,yscale;
	/* private stuff */
	GC gc,gridgc;
	unsigned char *data;     /* pointer to user-program's dataset */
	int ndata;
	Boolean redraw;
	int skip;
	} ChartPart;

typedef struct _ChartRec {
	CorePart	core;
	ChartPart	chart;
	} ChartRec;

#endif /* _ChartP_h */
