/* > Chart.h */
/* Daniel F. Smith, 1994 */
/* Chart widget, based on Template.h */

#ifndef _Chart_h
#define _Chart_h

/****************************************************************
 *
 * Chart widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

 gridColour          GridColour         Pixel           XtDefaultForeground
 gridSize            GridSize           int             0
 scaleX              ScaleX             int             1
 scaleY              ScaleY             int             4
 datap               Datap              Pointer         NULL
 ndata               Ndata              int             0
 redraw              Redraw             Boolean         False
 skip		     Skip		int		1
*/

/* define any special resource names here that are not in <X11/StringDefs.h> */
#define XtNgridColour "gridColour"
#define XtCGridColour "GridColour"
#define XtNgridSize "gridSize"
#define XtCGridSize "GridSize"
#define XtNscaleX "scaleX"
#define XtCScaleX "ScaleX"
#define XtNscaleY "scaleY"
#define XtCScaleY "ScaleY"
#define XtNdatap "datap"
#define XtCDatap "Datap"
#define XtNndata "ndata"
#define XtCNdata "Ndata"
#define XtNredraw "redraw"
#define XtCRedraw "Redraw"
#define XtNskip "skip"
#define XtCSkip "Skip"

/* declare specific ChartWidget class and instance datatypes */
typedef struct _ChartClassRec*	ChartWidgetClass;
typedef struct _ChartRec*	ChartWidget;

/* declare the class constant */
extern WidgetClass chartWidgetClass;

#endif /* _Chart_h */
