.\" @(#)rolo.1	2.2 8/14/88
.TH ROLO 1 "August 1988"
.SH NAME
xrolo \- OpenWindows tool to manage notes like a Rolodex
.SH SYNOPSIS
.B rolo [file]
.SH DESCRIPTION
.I Rolo
is a tool for the Sun workstation which presents a
user interface to a simple database of notes in a manner
which approximates a Rolodex file.  The information in
this man page is available, almost verbatim, within
.I Rolo
by clicking the "?" button in the control panel.

Each note in your
.I Rolo
file is meant to
simulate a 3x5 card upon which you may scribble
anything you like.  You can have any number of
cards in your rolodex,
.I Rolo
will keep track of
them for you.  You may browse around through
them, create new ones, throw old ones away,
search for strings in them, etc.

The buttons in the top part of the
.I Rolo
window provide the main controls with which
you manipulate your cards.  Every button on
the control panel has a menu attached which
can be pulled up by pressing the right mouse
button over that item.  The menus provide
textual explanations of what the buttons do,
as well showing the shift accelerators which
may be used with the buttons.  Selecting from
the button menus is equivalent to clicking the
button directly.  Herewith is a quick overview
of what the buttons do.
.TP
ARROW BUTTONS
These buttons move you through the cards.
The down arrow moves you to the next card in
the file, the up arrow moves you backwards to
the previous card.  Holding down the Shift key
when the down or up button is clicked, or
choosing the second menu item, will jump you
to the last or first card respectively.
.TP
NEW CARD BUTTON
This button creates a new blank card.  By
default, the new card will be inserted after
the currently displayed card.  Using the Shift
key will cause it to be inserted before the
current card.
.TP
TRASHCAN BUTTON
This button deletes and undeletes cards
from your rolodex.  A normal unshifted click
on this button deletes the card which is
currently displayed.  Deleted cards are not
lost, they are saved on a stack of deleted
cards and may be retrieved any time before
.I Rolo
exits.  The alternate selections on the
menu for the Trash button may be used to
undelete any card which was previously deleted.
These undelete menu items have pullright
menus which will list the first line of all
the cards on the deleted stack.  You may select
any one of these deleted cards directly from
the pullright menu and it will re-inserted
back into the active list of cards before or
after the current card.  If you select one
of the undelete menu items directly, without
pulling right to pick from the list of deleted
cards, the card on the top of the deleted
stack (the last one deleted) will be undeleted.
Using Shift and Control key accelerators when
clicking the button will give the same effect.
If there are no deleted cards on the stack,
the undelete items are marked as inactive.
You can rearrange the order of the cards in
your rolodex by deleting a card, moving to
a new position, then undeleting it.  Note that
blanks cards containing only white space are
not saved on the undeleted stack, they are
thrown away.
.TP
LIST BUTTON
This button produces an index list of all
the cards in your rolodex.  The first line
of each card is displayed in the window so
that you can get a quick overview of all
your cards.  The card numbers to the left of
each line can be used to jump directly to that
card with the slider in the control panel.
Alternately, the user can click on the 
desired entry followed by a <SHIFT>-click
on the list button (or use the list button 
menu) to bring up the selected card.
The "List Cards Matching Regex" menu
entry produces an index list of cards
matching the regular expression in the
Expression text panel using the selected
match type.
.TP
FILE BUTTON
This button loads and saves your rolodex
cards from and to disk.  The default action
is to write the current list of cards out to
the file they were loaded from (the file name
listed in the title bar).  You can also reload
the cards from that file as-of the last time
they were saved.  There are also items on
this menu which will sort your cards into
alphabetical order according to their first
lines.  By default, sorting is done in a case
insensitive manner. The sort mode may be set
by selecting the case [In]Sensitive pullright
menu or by setting the "xrolo.CaseInsensitiveSort"
resource to 0 or 1. Xrolo implements a very 
rudimentary field sort. Each line in the card
is considered to be a field. Pointing and
clicking on a selected field before invoking
the sort will cause xrolo to sort the cards
by the selected field. The last item on the menu, which
can only be selected from the menu, will load
from or save to a named file.  You can select
a string in some window to provide the file
name, similar to the way the
.I TextEdit
tool
works.  The path you give must be relative to
your home directory (a cd to
.B $HOME
is done
when 
.I Rolo
starts up).  Saving to or loading from
a file this way causes that new file to become
the default for the regular load and save
operations.  You will be warned about unsaved
modifications to your cards, overwriting
existing files, etc.
.TP
HELP BUTTON
Displays the information you're reading now
and allows you to send mail to me.
.TP
PHONE BUTTON
On SparcStations this button can be used to
dial a number entered in the expression field
or highlighted with the mouse.  When selected
the "Set Phone Attributes\" menu item creates
a panel that allows speaker volume adjustment,
the entering of a dial prefix and the enabling
or disabling of the dial prefix.  Phone
numbers and dial prefixes may consist of any
alpha numeric character, *, # and \",\". 
A comma in the dial string causes the dial
routine to pause for 2 seconds before
dialing the next character in the sequence.
Xrolo supports several X resources used to
to control default phone attributes.
"xrolo.DefaultVolume" sets the default
speaker volume. The volume must be entered
as an integer value ranging in value from
0 to 100 where 100 is the maximum gain.
"xrolo.UseDialPrefix" accepts a boolean value
which enables or disables the use of the dial
prefix while dialing.
"xrolo.DialPrefix" set the default dial prefix
string.
.TP
FINISHED BUTTON
   This button is used when you are finished
using
.I Rolo.  
A normal click saves any changes
you've made and causes
.I Rolo
to close to an
icon.  Alternate selections will cause
.I Rolo
to
exit with or without saving any pending
changes you've made.  
.I Rolo
automatically
saves any pending changes if SunTools
forces it to exit.
.TP
PRINT BUTTON
This button is used to print. A normal click
causes 
.I Rolo 
to print the current record. 
Alternate selections will cause Rolo to print
all the entries in the current sorted order
or set the print command. The default print
command is "lpr".  A user can customize
the default printer command by creating an
X resource entry called "xrolo.PrintCommand".
The "Print Records Matching Regex" menu
entry spools to the print command all cards
matching the regular expression in the
Expression text panel using the selected
match type.
.TP
FIND BUTTON
This button searches for a regular expression
in your cards.  This can be used to find any
text pattern which appears anywhere in any of
your cards.  The pattern to search for may be
entered in the text item to the right of the
Find button.  If, at the time the Find
button is clicked, there is an active selection
in any window, it will be used as the search
pattern instead.  Pressing the return key in
the search pattern item is equivalent to
clicking the Find button.  Due to the way the
library search routines work, all the text of a
given card is treated as one logical line.  The
main effect of this is that the '^' and '$'
operations won't match individual lines within
a card, only the text of the card as a whole.
.br
Note: "Regular expressions" are the kind used
by egrep(1), which are not the same as the
shell meta-characters. 
.br
By default xrolo will
do a case insensitive (or "sloppy") regular
regular expression search.  If soundex search
mode is selected, xrolo will try to match an
entry which sounds like the expression
(e.g. "cuper" will match "cooper").
The default search mode may be changed by
selecting "Egrep Regex Match" or "Soundex"
from the find menu or by setting the X
resource "xrolo.SearchType"
to 0, 1 or 3 for EGREP, SLOPPY or SOUNDEX
searches respectively.
.TP
SLIDER
The slider item on the control panel may
be used to select any card directly.  Simply
drag the bar back and forth until the number
of the card you wish to see is displayed to
the left of the slider, then release the
mouse button.
.TP
RESOURCES
Xrolo supports a number of resources which include:

xrolo.TextWidth - set width of text window in pixels.

xrolo.CaseInsensitive - 1 causes xrolo to ignore case when sorting. 
0 turns on case sensitive sorts.

xrolo.PrintCommand - text string used to set the default print command.

xrolo.SearchType - default search mode for find. 0, 1 or 2 for EGREP,
SLOPPY or SOUNDEX search modes respectively.

xrolo.UseDialPrefix - 1 causes xrolo to use the dial prefix when dialing.

xrolo.DefaultVolume - volume gain for SS1 internal speaker.  The gain must
be entered as an integer value between 0 and 100 where 100 is the maximum gain.

xrolo.DialPrefix - text string used to set the default dial prefix.
.SH FILES
.TP
$HOME/.rolo
This is the default filename
.I Rolo
looks for at startup, unless a filename argument
is provided on the command line.  The file pathname
given must be relative to your home directory, even if
.I Rolo
is executed from somewhere else, because
.I Rolo
changes to your home directory when it begins.
.SH AUTHOR
 Ron Hitchens   (ronbo@vixen.uucp, hitchens@cs.utexas.edu)
   And
 Luis Soltero (luis@rice.edu)

.br
   Version 1.0, March  1987
   Version 2.0, August 1988

   Ported to OpenWindows by  Luis Soltero
   (luis@rice.edu) November 1990

Thanks to S. Page (spage@sun.com) and
Mike Ekberg (mae@sun.com) at Sun for
changes and improvements to the original
.I Rolo.
.SH POLICY
.I Rolo
is public domain, anyone and everyone
is welcome to it.  Feel free to give it to your
friends (or even your enemies).  I only ask
that you keep it all together, source included,
as posted.  Please send bug reports, fixes,
gripes, suggestions, etc, to me at the email
address above.

[RH 8/8/88]
