/*
 * Copyright (C) 1995 by Tom Pfau (pfau@cnj.digex.net)
 *
 * This file may be distributed under the terms of the GPL.
 */
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <libsx.h>
#include "mandelbrot.h"
#include "submit.h"

static Widget w[20];
static struct PARAMS subparms;
static char fnm[255];
static int ok=0;
static Widget wLeft,wTop,wHeight,wLimit,wIter,wFnm;

/*
static void short_cb(Widget w, char *str, void *data)
{
    short *val = data;
    sscanf(str,"%hd",val);
}

static void double_cb(Widget w, char *str, void *data)
{
    double *val = data;
    sscanf(str,"%lg",val);
}

static void string_cb(Widget w, char *str, void *data)
{
    char *val = data;
    strcpy(val,str);
}
*/

static void params_ok_cb(Widget w, void *data)
{
    ok = 1;
    strcpy(fnm,GetStringEntry(wFnm));
    if (fnm[0] == '\0')
    {
	Beep();
	return;
    }
    sscanf(GetStringEntry(wLeft),"%lg",&subparms.left);
    sscanf(GetStringEntry(wTop),"%lg",&subparms.top);
    sscanf(GetStringEntry(wHeight),"%lg",&subparms.height);
    sscanf(GetStringEntry(wIter),"%hd",&subparms.iterations);
    sscanf(GetStringEntry(wLimit),"%lg",&subparms.limit);
    CloseWindow();
}

static void params_can_cb(Widget w, void *data)
{
    ok = 0;
    CloseWindow();
}

void submit_plot(double l,double t,double h,int iter,float limit)
{
    char buf[30];
    FILE *x;

    subparms.left = l;
    subparms.top = t;
    subparms.height = h;
    subparms.limit = limit;
    subparms.iterations = iter;

    w[0] = MakeWindow("Parameters",SAME_DISPLAY,EXCLUSIVE_WINDOW);

    w[1] = MakeLabel("Left:");
    sprintf(buf,"%18.16g",subparms.left);
    wLeft = MakeStringEntry(buf,200,NULL,&subparms.left);
    SetWidgetPos(wLeft,PLACE_RIGHT,w[1],NO_CARE,NULL);

    w[3] = MakeLabel("Top:");
    SetWidgetPos(w[3],PLACE_UNDER,w[1],NO_CARE,NULL);
    sprintf(buf,"%18.16g",subparms.top);
    wTop = MakeStringEntry(buf,200,NULL,&subparms.top);
    SetWidgetPos(wTop,PLACE_UNDER,w[1],PLACE_RIGHT,w[3]);

    w[5] = MakeLabel("Height:");
    SetWidgetPos(w[5],PLACE_UNDER,w[3],NO_CARE,NULL);
    sprintf(buf,"%18.16g",subparms.height);
    wHeight = MakeStringEntry(buf,200,NULL,&subparms.height);
    SetWidgetPos(wHeight,PLACE_UNDER,w[3],PLACE_RIGHT,w[5]);

    w[7] = MakeLabel("Limit:");
    SetWidgetPos(w[7],PLACE_UNDER,w[5],NO_CARE,NULL);
    sprintf(buf,"%7.5f",subparms.limit);
    wLimit = MakeStringEntry(buf,200,NULL,&subparms.limit);
    SetWidgetPos(wLimit,PLACE_UNDER,w[5],PLACE_RIGHT,w[7]);

    w[9] = MakeLabel("Iterations:");
    SetWidgetPos(w[9],PLACE_UNDER,w[7],NO_CARE,NULL);
    sprintf(buf,"%5d",subparms.iterations);
    wIter = MakeStringEntry(buf,200,NULL,&subparms.iterations);
    SetWidgetPos(wIter,PLACE_UNDER,w[7],PLACE_RIGHT,w[9]);

    fnm[0] = '\0';
    w[11] = MakeLabel("File Name:");
    SetWidgetPos(w[11],PLACE_UNDER,w[9],NO_CARE,NULL);
    wFnm = MakeStringEntry(fnm,300,NULL,fnm);
    SetWidgetPos(wFnm,PLACE_UNDER,w[9],PLACE_RIGHT,w[11]);

    w[13] = MakeButton("OK",params_ok_cb,NULL);
    SetWidgetPos(w[13],PLACE_UNDER,w[11],NO_CARE,NULL);
    w[14] = MakeButton("Cancel",params_can_cb,NULL);
    SetWidgetPos(w[14],PLACE_UNDER,w[11],PLACE_RIGHT,w[13]);

    ShowDisplay();
    MainLoop();
    SetCurrentWindow(ORIGINAL_WINDOW);

    if (!ok)
	return;

    x = popen(SUBMIT_COMMAND,"w");
    fprintf(x,"mcalc %-.16g %-.16g %-.16g %d %g %s\n",
		subparms.left,subparms.top,subparms.height,
		subparms.iterations,subparms.limit,fnm);
    pclose(x);
}

