/*
 * Copyright (C) 1995 by Tom Pfau (pfau@cnj.digex.net)
 *
 * This file may be distributed under the terms of the GPL.
 */
#include <stdio.h>
#include "mandelbrot.h"
#include "compress.h"

void main(int argc,char *argv[])
{   double gap,a,b,x,y,x1,y1,limit;
    int apos,bpos;
    int zf=0;
    short int n;
    FILE *log;
    short int iter_count[SCREEN_WIDTH];
    short int obuf[SCREEN_WIDTH+1];
    struct PARAMS params;
    if (argc < 7)
    {	printf("MCALC x_min y_min height iter limit filename\n");
	exit();
    }
    log = fopen(argv[6],"wb");
    sscanf(argv[1],"%lf",&params.left);
    sscanf(argv[2],"%lf",&params.top);
    sscanf(argv[3],"%lf",&params.height);
    sscanf(argv[4],"%hd",&params.iterations);
    sscanf(argv[5],"%lf",&params.limit);
    params.processes = 1;
    fwrite(&params,sizeof(struct PARAMS),1,log);
    limit = params.limit * params.limit;
    gap = params.height / SCREEN_HEIGHT_F;
    b = params.top;
    for (bpos=0;bpos<SCREEN_HEIGHT;bpos++)
    {	register short int *icptr;
	b = params.top + (gap * (double) bpos);
	icptr = iter_count;
	for (apos=0;apos<SCREEN_WIDTH;apos++)
	{   a = params.left + (gap * (double) apos);
	    x = 0.0;
	    y = 0.0;
	    for (n=0;n<=params.iterations;n++)
	    {	x1 = x*x;
		y1 = y*y;
		if ((x1 + y1) > limit) break;
		y *= 2.0 * x;
		y += b;
		x = x1 - y1 + a;
		if ((x == 0.0) && (y == 0.0))
		    n = params.iterations,zf++;
	    }
	    --n;
            *icptr++ = n;
	}
        compress(iter_count,obuf);
        fwrite(obuf,sizeof(short int),obuf[0] + 1,log);
	fflush(log);
    }
    fclose(log);
    if (zf)
	printf("zero escape used %d time%s\n",zf,(zf=1) ? "" : "s");
}
