/*
 * Copyright (C) 1995 by Tom Pfau (pfau@cnj.digex.net)
 *
 * This file may be distributed under the terms of the GPL.
 */
#include "mandelbrot.h"
#include "compress.h"
/*
This function looks for repeated values in a word array and compresses them.
Output array value:
	>= 0	Single Value
	< 0 	Negated repeat count, next cell holds value
*/
void compress(short int *inbuf,short int *outbuf)
{   int i,j,k;
    int ip,cp,op;
    short int c;
    ip = 0;
    cp = 1;
    op = 1;
    k = 0;
    for (i=0;i<SCREEN_WIDTH;)
    {   if (inbuf[ip] != inbuf[cp++])
        {   i++;
	    k++;
	    outbuf[op++] = inbuf[ip++];
            continue;
        }
        if (inbuf[ip] != inbuf[cp++])
        {   i+=2;
	    k+=2;
	    outbuf[op++] = inbuf[ip++];
            outbuf[op++] = inbuf[ip++];
            continue;
        }
        c = inbuf[ip];
        for (j=3;(inbuf[ip]==inbuf[cp++]) && (cp < SCREEN_WIDTH);j++);
	outbuf[op++] = -j;
	outbuf[op++] = c;
        ip += j;
        i += j;
	k += 2;
    }
    outbuf[0] = k;
}
