#include "dots.h"
/*****************************************************************/
/*
a[1]=1;a[2]=1;a[3]=1
for(i=4;i<25;i++)(a[i]=a[i-1]+a[i-3])
2 3 4 6 9 13 19 28 41 60 88 129 189 277 406 595 872 1278 1873 2745 4023 */

void
many_dots(win, gc, window_width, window_height)
Window win;
GC gc;
unsigned int window_width, window_height;
{
	static int x = 0, y = 0;
	int	i;


	for( i = 0; i < DOT_CT; i++ ) {
		x = ( x + C ) % A;
		y = ( y + C ) % B;
		if( ( x >= window_width ) || ( y >= window_height ) ) continue;
		XFillRectangle( display, win, gc, x, y, W, H );
	}
}
/*****************************************************************/

#define delta 595
#define modX 1278
#define modY 1873
#define limit3	265519
#define max_distance 16.0

void
mandel( win, gc, window_width, window_height)
	Window win;
	GC gc;
	unsigned int window_width, window_height;

{
	int  yy, y_min = 9999, x, y, xy = 0, iteration,
		i_max = window_width,
		j_max = window_height,
		i_center = i_max / 2,
		j_center = j_max / 2,
		r_wide = WIDE/2,
		wide = WIDE;

	complex origin, z, k;


	XFillRectangle(display, win, gc, 0, 0, window_width, window_height);
	origin.real = i_center; 
	origin.imag = j_center;

	x = y = delta;
	while( x + y > 0 ) {
		if( ( x < window_width ) && ( y < window_height ) ) {

#ifdef OLD_RULE
			if( xy < 27201 ) wide = 3;
			else if( xy < 152692 ) wide = 2;
			else if( xy < 265519 ) wide = 1;
			else wide = 0;
#endif

			z.real =  z.imag = 0.0;
			k.real =  (origin.real + (double) x) / (double) window_width * radius;
			k.imag =  (origin.imag - (double) y) / (double) window_height * radius;

			if(debug)printf("zr: %g zi: %g  kr: %g  ki: %g\n",
				z.real, z.imag, k.real, k.imag  );

			for( iteration = 0; iteration < newt_iter; iteration++){
				double   distance = 0.0, real_part, imag_part;


				real_part = z.real + k.real;
				imag_part = z.imag + k.imag;

				z.real = real_part * real_part - imag_part * imag_part;
				z.imag = 2 * real_part * imag_part;

				distance  = z.real * z.real + z.imag * z.imag;

				if(debug)printf("zr: %g zi: %g d: %g\n", z.real, z.imag, distance );

				if (distance  >= max_distance) {
					XFillRectangle( display, win, gc, x - r_wide, y - r_wide, wide, wide );
					if( debug ) printf ( "Paint\n" );
					break;
				}
			}
			if( debug ) printf ( "Out\n" );

		}
		x = ( x + delta ) % modX;
		y = ( y + delta ) % modY;
		xy++;

		{
			int	absy, absx = min( x, modX - x );
			if( absx < r_wide ) {
				absy = min( y, modY - y );
				if( absy < r_wide ) {
					r_wide = max( absx, absy ) - 1;
					wide = 2 * r_wide + 1;
				}
			}
		}
	}
	printf( "" );
}
/*****************************************************************/
void
bumper( win, gc, window_width, window_height)
	Window win;
	GC gc;
	unsigned int window_width, window_height;
{
	double	xt, zt, zzzz, xtxt, t, fradius, x, y, z, xx, yy, zz;
	double P = 1.0;
	int grayness; /* in [0..100) */
	int	i_val, 
		ij_val; /* in [0..gold_Z) */

	int	i, j, k,
		i_disp, j_disp,
		i_disp_sqr, j_disp_sqr,
		disp_sqr,
		radius, radius_sqr,
		i_max = window_width/granularity,
		j_max = window_height/granularity,
		i_center = i_max / 2,
		j_center = j_max / 2;

	radius = ( ( i_max < j_max ) ? i_max : j_max ) * 4 / 10;
	fradius = (double) radius;
	radius_sqr = radius * radius;
	for( i = 0; i < i_max; i++ ) {
		i_disp = ( i - i_center ); i_disp_sqr = i_disp * i_disp;
		i_val = i * gold_X;
		x = i_disp / fradius;
		xx = x * x;
		for( j = 0; j < j_max; j++ ) {

			/* determine the gray level of the rendered image */
			j_disp = ( j - j_center ); j_disp_sqr = j_disp * j_disp;
			disp_sqr = i_disp_sqr + j_disp_sqr;
			y = j_disp / fradius;
			yy = y * y;

			t = 1.0;
			for( k = 1; k <= newt_iter; k++ ) {
				double tt = t*t, ttt = t*tt;
				xt = x + t; xtxt = xt*xt;
				t = t - ( ttt + P*(xtxt + yy) ) / ( 3.0 * tt + 2.0 * xt*P );
			}

			zt = t; zzzz = zt*zt; zzzz *= zzzz;
			grayness = ( -2.0*xt*i_light + -2.0 * y * j_light + 3.0 * zt * k_light )
				* 100 / sqrt( 4.0 * ( xtxt + yy ) + 9.0 * zzzz );

			for( k = 1; k < phong; k++ ) { grayness *= grayness; grayness /= 100; }
			if( grayness < ambient ) grayness = ambient;

			if( debug ) printf( "%g %g %g %g\n", x, y, z, grayness );

			ij_val = ( j * gold_Y + i_val ) % gold_Z;
			if( ij_val * 100 < grayness * gold_Z ) { /* dither is here! */
				XFillRectangle( display, win, gc,
				    i*granularity, j*granularity,
				    W, H );
			}
		}
	}
}
/*****************************************************************/
/* a sphere centered in the center of the screen */
/* its radius is 40% of the smallest dimension */
void
baller( win, gc, window_width, window_height)
	Window win;
	GC gc;
	unsigned int window_width, window_height;
{
	double sqrt();
	int grayness; /* in [0..100) */
	int	i_val, 
		ij_val; /* in [0..gold_Z) */

	int	i, j, k,
		i_disp, j_disp,
		i_disp_sqr, j_disp_sqr,
		disp_sqr,
		radius, radius_sqr,
		i_max = window_width/granularity,
		j_max = window_height/granularity,
		i_center = i_max / 2,
		j_center = j_max / 2;

	radius = ( ( i_max < j_max ) ? i_max : j_max ) * 4 / 10;
	radius_sqr = radius * radius;
	for( i = 0; i < i_max; i++ ) {
		i_disp = ( i - i_center ); i_disp_sqr = i_disp * i_disp;
		i_val = i * gold_X;
		for( j = 0; j < j_max; j++ ) {

			/* determine the gray level of the rendered image */
			j_disp = ( j - j_center ); j_disp_sqr = j_disp * j_disp;
			disp_sqr = i_disp_sqr + j_disp_sqr;
			if( disp_sqr > radius_sqr ) {
				/* the pixel is not on the ball */
				grayness = background;
			} else {
				double h_sqr = (double)( radius_sqr - disp_sqr ), h = sqrt( h_sqr );
				grayness = ( i_disp * i_light + j_disp * j_light + h * k_light ) * 100 / radius;
				for( k = 1; k < phong; k++ ) { grayness *= grayness; grayness /= 100; }
				if( grayness < ambient ) grayness = ambient;
			}

			ij_val = ( j * gold_Y + i_val ) % gold_Z;
			if( ij_val * 100 < grayness * gold_Z ) {
				XFillRectangle( display, win, gc,
				    i*granularity, j*granularity,
				    W, H );
			}
		}
	}
}
/*****************************************************************/
void
ramper( win, gc, window_width, window_height)
	Window win;
	GC gc;
	unsigned int window_width, window_height;
{
	int grayness; /* in [0..100) */
	int	i_val, 
		ij_val; /* in [0..gold_Z) */

	int	i, j,
		i_max = window_width/granularity,
		j_max = window_height/granularity;

	for( i = 0; i < i_max; i++ ) {
		grayness = i * 100 / i_max;
		i_val = i * gold_X;
		for( j = 0; j < j_max; j++ ) {

			ij_val = ( j * gold_Y + i_val ) % gold_Z;
			if( ij_val * 100 > grayness * gold_Z ) {
				XFillRectangle( display, win, gc,
				    i*granularity, j*granularity,
				    W, H );
			}
		}
	}
}
/*****************************************************************/
void
solid_gray( win, gc, window_width, window_height)
	Window win;
	GC gc;
	unsigned int window_width, window_height;
{
	static int grayness = 99; /* in [0..100) */
	int	i_val, 
		ij_val; /* in [0..gold_Z) */

	int	i, j,
		i_max = window_width/granularity,
		j_max = window_height/granularity;

	grayness -= gray_incr;

	for( i = 0; i < i_max; i++ ) {
		i_val = i * gold_X;
		for( j = 0; j < j_max; j++ ) {

			ij_val = ( j * gold_Y + i_val ) % gold_Z;
			if( ij_val * 100 > grayness * gold_Z ) {
				XFillRectangle( display, win, gc,
				    i*granularity, j*granularity,
				    W, H );
			}
		}
	}
}
/*****************************************************************/
init_gold( n ) int n;
{
	int i;
	gold[0] = 0;
	gold[1] = 1;
	gold[2] = 1;
	gold[3] = 1;
	for( i = 4; i <= n; i++ ) gold[i] = gold[i-1] + gold[i-3];

	gold_Z = gold[n];
	gold_Y = gold[n-1];
	gold_X = gold[n-2];

	if( print_the_params )
		printf( "gold X, Y, Z: %d %d %d\n", gold_X, gold_Y, gold_Z );
}
/*****************************************************************/
remove_overlay(win, gc, window_width, window_height)
Window win;
GC gc;
unsigned int window_width, window_height;
{
	/* this clears the overlay plane set in the gc */
	XFillRectangle(display, win, gc, 0, 0, 10000, 10000);
}
/*****************************************************************/
