/* This is the file params.c */
double	radius	= 1.0;
double	scale_mod	= 1.0;
double	max_distance	= 16.0;
double	x_origin	= 0.0;
double	y_origin	= 0.0;
double	i_light	= 0.577350268;
double	j_light	= 0.577350268;
double	k_light	= 0.577350268;
double	c_r	= 1.0;
double	c_i	= 0.0;
double	epsilon	= 0.1;
int	debug	= 0;
int	WIDE	= 100;
int	await	= 1;
int	print_wide	= 1;
int	print_the_params	= 0;
int	init_wide	= 200;
int	init_tall	= 200;
int	slow	= 0;
int	gray	= 0;
int	ramp	= 0;
int	ball	= 0;
int	constant	= 0;
int	poly	= 0;
int	julia	= 0;
int	julia3	= 0;
int	julia_exp	= 0;
int	roots	= 0;
int	mandelbrot	= 0;
int	b_and_w	= 0;
int	ripples	= 0;
int	A	= 1873;
int	B	= 1278;
int	C	= 595;
int	W	= 1;
int	H	= 1;
int	granularity	= 1;
int	DOT_CT	= 500;
int	gold_level	= 10;;
int	gray_incr	= 10;
int	random	= 0;
int	phong	= 1;
int	ambient	= 0;
int	background	= 100;
int	newt_iter	= 3;
int	negate	= 0;
int	start_wide	= 900;
int	start_tall	= 801;
char	window_name[70]	= "dots";
char	defined_display[70]	= ":0.0";

#include	<string.h>
#include	<ctype.h>
#include	<stdio.h>

#define	_int_	"%d"
#define	_float_	"%f"
#define	_double_	"%lf"
#define	_string_	"%s"

#define fig(N,M,T) if(strcmp(key,N)==0)  \
	{ sscanf(strtok(NULL," \t\n"),T,M);} else

params( argc, argv ) int argc; char * argv[];
{ FILE * fp; char line[128], * key;

if( argc < 2 ) { fp = fopen("params", "r"); }
else { fp = fopen( argv[1], "r" ); }
if( fp == NULL ) { printf("No params file??\n"); return; }

while( fgets( line, 128, fp ) ) { /* read a line from the file "params" */
	key = strtok( line, " \t" );
	if( '%' == key[0] ) printf( "%s\n", line ); /* comments */
	else if( isalpha( key[0] ) ) { 
		if( strcmp( key, "EXIT" )==0 ) break; /* quit processing params */

		fig("radius",&radius,_double_)
		fig("scale_mod",&scale_mod,_double_)
		fig("max_distance",&max_distance,_double_)
		fig("x_origin",&x_origin,_double_)
		fig("y_origin",&y_origin,_double_)
		fig("i_light",&i_light,_double_)
		fig("j_light",&j_light,_double_)
		fig("k_light",&k_light,_double_)
		fig("c_r",&c_r,_double_)
		fig("c_i",&c_i,_double_)
		fig("epsilon",&epsilon,_double_)
		fig("debug",&debug,_int_)
		fig("WIDE",&WIDE,_int_)
		fig("await",&await,_int_)
		fig("print_wide",&print_wide,_int_)
		fig("print_the_params",&print_the_params,_int_)
		fig("init_wide",&init_wide,_int_)
		fig("init_tall",&init_tall,_int_)
		fig("slow",&slow,_int_)
		fig("gray",&gray,_int_)
		fig("ramp",&ramp,_int_)
		fig("ball",&ball,_int_)
		fig("constant",&constant,_int_)
		fig("poly",&poly,_int_)
		fig("julia",&julia,_int_)
		fig("julia3",&julia3,_int_)
		fig("julia_exp",&julia_exp,_int_)
		fig("roots",&roots,_int_)
		fig("mandelbrot",&mandelbrot,_int_)
		fig("b_and_w",&b_and_w,_int_)
		fig("ripples",&ripples,_int_)
		fig("A",&A,_int_)
		fig("B",&B,_int_)
		fig("C",&C,_int_)
		fig("W",&W,_int_)
		fig("H",&H,_int_)
		fig("granularity",&granularity,_int_)
		fig("DOT_CT",&DOT_CT,_int_)
		fig("gold_level",&gold_level,_int_)
		fig("gray_incr",&gray_incr,_int_)
		fig("random",&random,_int_)
		fig("phong",&phong,_int_)
		fig("ambient",&ambient,_int_)
		fig("background",&background,_int_)
		fig("newt_iter",&newt_iter,_int_)
		fig("negate",&negate,_int_)
		fig("start_wide",&start_wide,_int_)
		fig("start_tall",&start_tall,_int_)
		fig("window_name",window_name,_string_)
		fig("defined_display",defined_display,_string_)

	printf("Unknown key-word: %s\n", line);
} /* end if */ } /* end while */

	/* Conditionally print the parameter values. after they are set. */
	if( ! print_the_params ) return;
printf( "%%double \n" );
printf( "   radius   %f\n", radius);
printf( "   scale_mod   %f\n", scale_mod);
printf( "   max_distance   %f\n", max_distance);
printf( "   x_origin   %f\n", x_origin);
printf( "   y_origin   %f\n", y_origin);
printf( "   i_light   %f\n", i_light);
printf( "   j_light   %f\n", j_light);
printf( "   k_light   %f\n", k_light);
printf( "   c_r   %f\n", c_r);
printf( "   c_i   %f\n", c_i);
printf( "   epsilon   %f\n", epsilon);
printf( "%%int \n" );
printf( "   debug   %d\n", debug);
printf( "   WIDE   %d\n", WIDE);
printf( "   await   %d\n", await);
printf( "   print_wide   %d\n", print_wide);
printf( "   print_the_params   %d\n", print_the_params);
printf( "   init_wide   %d\n", init_wide);
printf( "   init_tall   %d\n", init_tall);
printf( "   slow   %d\n", slow);
printf( "   gray   %d\n", gray);
printf( "   ramp   %d\n", ramp);
printf( "   ball   %d\n", ball);
printf( "   constant   %d\n", constant);
printf( "   poly   %d\n", poly);
printf( "   julia   %d\n", julia);
printf( "   julia3   %d\n", julia3);
printf( "   julia_exp   %d\n", julia_exp);
printf( "   roots   %d\n", roots);
printf( "   mandelbrot   %d\n", mandelbrot);
printf( "   b_and_w   %d\n", b_and_w);
printf( "   ripples   %d\n", ripples);
printf( "   A   %d\n", A);
printf( "   B   %d\n", B);
printf( "   C   %d\n", C);
printf( "   W   %d\n", W);
printf( "   H   %d\n", H);
printf( "   granularity   %d\n", granularity);
printf( "   DOT_CT   %d\n", DOT_CT);
printf( "   gold_level   %d\n", gold_level);
printf( "   gray_incr   %d\n", gray_incr);
printf( "   random   %d\n", random);
printf( "   phong   %d\n", phong);
printf( "   ambient   %d\n", ambient);
printf( "   background   %d\n", background);
printf( "   newt_iter   %d\n", newt_iter);
printf( "   negate   %d\n", negate);
printf( "   start_wide   %d\n", start_wide);
printf( "   start_tall   %d\n", start_tall);
printf( "%%string 70\n" );
printf( "   window_name   %s\n", window_name);
printf( "   defined_display   %s\n", defined_display);
} /* end params */
