/*
 * grid.h: definitions for grid type
 */

typedef struct POINT
	{
	int x;
	int y;
	} Point;

typedef struct AREA
	{
	Point v[4];
	} Area;	

typedef Area* AreaRow;

typedef struct GRID
	{
	int GWidth;
	int GHeight;
	int XGran;
	int YGran;
	int CPCnt;

	/* a grid is a matrix of areas */

	AreaRow* theGrid;

	/* storing the crosspoint vector */

	Point* CrossPoint;
	} Grid;

typedef Grid* grid;

extern grid new_grid(int,int,int,int);
extern void show_grid(grid);
extern int hit_point(grid,Point);
extern void free_grid(grid);
extern void move_hit_point(grid,Point,int);
extern int save_grid(grid,char*);
extern grid load_grid(char*);
extern grid copy_grid(grid);


