/*
 *     Object Generator   -   objects.c
 *     Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */

#include "typy.h"

VOID alloc_object(OBJECT *t,INT verts,INT faces)
  {
      t->vertex=calloc(verts,sizeof(POINT));
      t->face=calloc(faces,sizeof(FACE));
      t->bd=calloc(verts,sizeof(POINT2));
  }

VOID free_object(OBJECT *t)
  {
     free(t->bd);
     free(t->face);
     free(t->vertex);
  }

VOID Resegment(FLOAT f)
  {
     INT i;
     OBJECT *t;
     INT s1,s2;

     for(i=0;i<pt;i++)
      {
        t = &object[i];

        s1 = (INT) ( sqrt(f) * (FLOAT)t->segm1 );
        s2 = (INT) ( sqrt(f) * (FLOAT)t->segm2 );

        switch(t->typ)
          {
            case SPHERE : free_object(t);
                          *t=sphere(t->position,&(t->R),s1,s2); 
                          break;
            case TORUS  : free_object(t);
                          *t=torus(t->position,&(t->R),&(t->r),s1,s2); 
                          break;
          case CYLINDER : free_object(t);
                          *t=cylinder(t->position,&(t->R),&(t->r),s1);
                          break;
         }
      }
  }
/*--------------------------------------------------------------------------
                        Generovanie 3D Objektov
---------------------------------------------------------------------------*/
OBJECT squere(POINT *O)
   {
      OBJECT t;
      INT i;
      INT verts,faces;

      O->z= -4;

      verts = 4;
      faces  = 1;

      alloc_object(&t,verts,faces);

      t.face[0].verts = 4;
      t.face[0].color   = random()&0xf;

      t.face[0].vertex[0] = 0;
      t.face[0].vertex[1] = 1;
      t.face[0].vertex[2] = 2;
      t.face[0].vertex[3] = 3;
	 
      t.vertex[0].x = O->x;
      t.vertex[0].y = O->y;
      t.vertex[0].z = O->z;

      t.vertex[1].x = O->x;
      t.vertex[1].y = -O->y;
      t.vertex[1].z = O->z;

      t.vertex[2].x = -O->x;
      t.vertex[2].y = -O->y;
      t.vertex[2].z = O->z;

      t.vertex[3].x = -O->x;
      t.vertex[3].y = O->y;
      t.vertex[3].z = O->z;

      t.verts=verts;
      t.faces=faces;

      return(t);              
   }

OBJECT triangles(FLOAT *v,INT TTT)
   {
      OBJECT t;
      INT i;
      INT verts,faces;
      FLOAT z,sx,sy,fi,r;

      verts = 3*TTT;
      faces  = TTT;
      r = sqrt(*v)/80;

      alloc_object(&t,verts,faces);

      for(i=0;i<TTT;i++)
        {
            t.face[i].verts = 3;
            t.face[i].color   = random()&0xf;

            t.face[i].vertex[0] = 3*i;
            t.face[i].vertex[1] = 3*i+1;
            t.face[i].vertex[2] = 3*i+2;
	 
            z = 10* ((FLOAT) (random()&0xffff)) / 0xffff - 5;   /* -5 5 */
            sx = 8* ((FLOAT) (random()&0xffff)) / 0xffff - 4;   /* -8 8 */
            sy = 8* ((FLOAT) (random()&0xffff)) / 0xffff - 4;   /* -8 8 */

            if (sx<0) sx=sx+r; else sx=sx-r;
            if (sy<0) sy=sy+r; else sy=sy-r;

         fi = M_PI* ((FLOAT) (random()&0xffff)) / 0xffff;

            t.vertex[3*i].x = sx + r*cos(fi);
            t.vertex[3*i].y = sy + r*sin(fi);
            t.vertex[3*i].z = z;

            t.vertex[3*i+1].x = sx + r*cos(fi-2*M_PI/3);
            t.vertex[3*i+1].y = sy + r*sin(fi-2*M_PI/3);
            t.vertex[3*i+1].z = z;

            t.vertex[3*i+2].x = sx + r*cos(fi+2*M_PI/3);
            t.vertex[3*i+2].y = sy + r*sin(fi+2*M_PI/3);
            t.vertex[3*i+2].z = z;

        }

      t.verts=3*TTT;
      t.faces=TTT;

      return(t);              
   }

OBJECT cube(MATRIX MTX,FLOAT *a)
   {
      OBJECT t;
      INT i;
      CHAR verts=8;
      static POINT point[8] =  {  -1,-1,1,   1,-1,1,   1,1,1,  -1,1,1,
		              -1,-1,-1,  1,-1,-1,  1,1,-1, -1,1,-1  };
      CHAR faces=6;
      static FACE face[6]=  {   4,0,1,2,3, 6,
		         	  4,1,5,6,2, 7,
		                  4,5,4,7,6, 2,
         		          4,4,0,3,7, 3,
		         	  4,4,5,1,0, 4,
			          4,3,2,6,7, 5        };

      alloc_object(&t,verts,faces);

       t.typ    =  CUBE;
       t.R      = *a;
       t.r      =  0;
       M_load_matrix(t.position,MTX);
       t.segm1  =  0;
       t.segm2  =  0;

       t.verts=verts;
       t.faces=faces;

       *a=0.5*(*a);

       for(i=0;i<verts;i++)  t.vertex[i]=multiple(&point[i],a);
       for(i=0;i<faces;i++)    t.face[i]=face[i];
 
       M_object_matrix(&t,MTX);
       return(t);
   }

OBJECT tetrahedron(MATRIX MTX,FLOAT *a)
   {
      OBJECT t;
      INT i;
      CHAR verts=4;
      static POINT point[4] = {  0,1,-M_SQRT2/4,   0.866,-0.5,-M_SQRT2/4,
                            -0.866,-0.5,-M_SQRT2/4,  0,0,3*M_SQRT2/4  };
      CHAR faces=4;
      static FACE face[4]=    {   3,1,0,3,0,  4,
		        	  3,2,1,3,0,  5,
		                  3,0,2,3,0,  2,
         		          3,0,1,2,0,  3   };

      alloc_object(&t,verts,faces);

       t.typ    = TETRAHEDRON;
       t.R      = *a;
       t.r      =  0;
       M_load_matrix(t.position,MTX);
       t.segm1  =  0;
       t.segm2  =  0;

       for(i=0;i<verts;i++) t.vertex[i]=multiple(&point[i],a);
       for(i=0;i<faces;i++)   t.face[i]=face[i];

       t.verts=verts;
       t.faces=faces;

       M_object_matrix(&t,MTX);
       return(t);
   }

OBJECT sphere(MATRIX MTX,FLOAT *R,INT M,INT N)
   {
       static OBJECT t;
       FLOAT theta,fi;
       FLOAT pi=M_PI;
       INT m,n,i=0;
       INT farba,xor;

       farba=random()&0xf;
       xor=random()&0xf;
       
       alloc_object(&t,(long)M*N+N,(long)M*N);

       t.typ    = SPHERE;
       t.R      = *R;
       t.r      =  0;
       M_load_matrix(t.position,MTX);
       t.segm1  =  M;
       t.segm2  =  N;

       t.verts=M*N+N;
       t.faces=M*N;

       for(m=0;m<=M;m++)
         {
          if (m==0) theta= -pi/2+0.001;
               else theta= -pi/2+pi*(FLOAT)m/(FLOAT)M;

	  for(n=0;n<N;n++)
	   {
	      fi=2*pi*(FLOAT)n/(FLOAT)N;

	      t.vertex[i].x= *R *cos(theta)*cos(fi);
	      t.vertex[i].y= *R *cos(theta)*sin(fi);
	      t.vertex[i].z= *R *sin(theta);

              if (m<M)
               {
	          t.face[i].verts=4;

                  if (i==0) t.face[i].color=farba;
                       else t.face[i].color=t.face[i-1].color^xor;
	          if ((n==0)&&(i!=0)) t.face[i].color=t.face[i-1].color;

	          t.face[i].vertex[0]=i;
	          t.face[i].vertex[1]=i+1;
	          t.face[i].vertex[2]=i+N+1;
	          t.face[i].vertex[3]=i+N;

	          if(n==(N-1)) {
		      	         t.face[i].vertex[0]=i;
			         t.face[i].vertex[1]=i-N+1;
			         t.face[i].vertex[2]=i+1;
			         t.face[i].vertex[3]=i+N;
			       }
               }
	      i++;
	    }
         }

     M_object_matrix(&t,MTX);
     return(t);
  }

OBJECT torus(MATRIX MTX,FLOAT *R,FLOAT *r,INT M,INT N)
   {
       OBJECT t;
       FLOAT theta,fi;
       FLOAT pi=M_PI;
       INT n,m,i=0;
       INT farba,xor;

       farba=random()&0xf;
       xor=random()&0xf;       

       alloc_object(&t,(long)M*(long)N,(long)M*(long)N);

       t.typ    = TORUS;
       t.R      = *R;
       t.r      = *r;
       M_load_matrix(t.position,MTX);
       t.segm1  =  M;
       t.segm2  =  N;

       t.verts=M*N;
       t.faces=M*N;

       for(m=0;m<M;m++)
        {
          theta= 2*pi*(FLOAT)m/(FLOAT)M;

	  for(n=0;n<N;n++)
	   {
	      fi= 2*pi*(FLOAT)n/(FLOAT)N;

	      t.vertex[i].x= (*R+ *r *cos(theta))*cos(fi);
	      t.vertex[i].y= (*R+ *r *cos(theta))*sin(fi);
	      t.vertex[i].z=      *r *sin(theta);

	      t.face[i].verts=4;
              if ((n==0)&&(m==0)) t.face[i].color=farba;
	                     else t.face[i].color=t.face[i-1].color^xor;
	      if ((n==0)&&(m!=0)) t.face[i].color=t.face[i-1].color;
	      t.face[i].vertex[0]=i;
	      t.face[i].vertex[1]=i+1;
	      t.face[i].vertex[2]=i+N+1;
	      t.face[i].vertex[3]=i+N;
	      if(n==(N-1)) {
			     t.face[i].vertex[0]=i;
			     t.face[i].vertex[1]=i-N+1;
			     t.face[i].vertex[2]=i+1;
			     t.face[i].vertex[3]=i+N;
			   }
	      i++;
	    }
         }

       for(n=0;n<N;n++)
	 {
	   t.face[n+i-N].verts=4;
	   if (n==0) t.face[n+i-N].color=t.face[n+i-N-1].color;
	   else t.face[n+i-N].color=t.face[n+i-N-1].color^xor;
	   t.face[n+i-N].vertex[0]=n+i-N;
	   t.face[n+i-N].vertex[1]=n+i-N+1;
	   t.face[n+i-N].vertex[2]=n+1;
	   t.face[n+i-N].vertex[3]=n;
	}
	t.face[i-1].verts=4;
	t.face[i-1].color=t.face[i-2].color^xor;

	t.face[i-1].vertex[0]=i-1;
	t.face[i-1].vertex[1]=i-N;
	t.face[i-1].vertex[2]=0;
	t.face[i-1].vertex[3]=N-1;

        M_object_matrix(&t,MTX);
        return(t);
    }

OBJECT cylinder(MATRIX MTX,FLOAT *R,FLOAT *v,INT N)
   {
       OBJECT t;

       FLOAT fi;
       FLOAT pi=M_PI;
       INT m,n,i=0,j=0;
       INT farba,xor;

       farba=random()&0xf;
       xor=random()&0xf;       

       alloc_object(&t,(long)2*N+2,(long)3*N);

       t.typ   = CYLINDER;
       t.R     = *R;
       t.r     = *v;
       M_load_matrix(t.position,MTX);
       t.segm1 =  N;
       t.segm2 =  0;

       t.verts=2*N+2;
       t.faces=3*N;

       for(m= -1;m<2;m=m+2)          /* coat */
         for(n=0;n<N;n++)
	   {
	      fi=2*pi*(FLOAT)n/(FLOAT)N;

	      t.vertex[i].x= *R *cos(fi);
	      t.vertex[i].y= *R *sin(fi);
	      t.vertex[i].z= *v * m;

              i++;
            }

         for(n=0;n<N;n++)        /* coat */
            {
	      t.face[j].verts=4;
              if (n==0) t.face[j].color=farba;
                   else t.face[j].color=t.face[j-1].color^xor;

	      t.face[j].vertex[0]=n;
	      t.face[j].vertex[1]=n+1;
	      t.face[j].vertex[2]=n+N+1;
	      t.face[j].vertex[3]=n+N;

	      if(n==(N-1)) {
			     t.face[j].vertex[0]=n;
			     t.face[j].vertex[1]=n-N+1;
			     t.face[j].vertex[2]=n+1;
			     t.face[j].vertex[3]=n+N;
			   }
	      j++;
	    }

     for(m=0;m<2;m++)            /* hut */
      {
        t.vertex[i].x= 0;
        t.vertex[i].y= 0;
        t.vertex[i].z= *v *(2*m-1); i++;

        for(n=0;n<N;n++)
          {
	      t.face[j].verts=3;
              if (n==0) t.face[j].color=farba;
                   else t.face[j].color=t.face[j-1].color^xor;

	      t.face[j].vertex[0]= n+1 + m*N -m;
	      t.face[j].vertex[1]= n   + m*N +m;
	      t.face[j].vertex[2]= i-1;

	      if(n==(N-1))
                {
		  t.face[j].vertex[0]=       m*N +m*(N-1);
		  t.face[j].vertex[1]= N-1 + m*N -m*(N-1);
		  t.face[j].vertex[2]= i-1;
	        }
	      j++;
	 }
      }

      M_object_matrix(&t,MTX);
      return(t);
  }

/*-------------------------------------------------------------------------*/
