/*
 *      Matrix Routines   matrix.c
 *      Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */                                                                       

#include "typy.h"

VOID M_unit(MATRIX M)
  {
    INT i,j;

    for(i=0;i<4;i++)
      for(j=0;j<4;j++)

        if (i==j) M[i][j] = 1;  
        else      M[i][j] = 0;
   }

VOID M_translate(MATRIX M,POINT *T)
  {
    M_unit(M);
    M[0][3] = T->x;
    M[1][3] = T->y;
    M[2][3] = T->z;
  }

VOID M_rotate(MATRIX A)
  {
      FLOAT COS,SIN;
      FLOAT x,y,z;

      x = (c->r).x;
      y = (c->r).y;
      z = (c->r).z;

      COS = c->COS;
      SIN = c->SIN;

      A[0][0] = (1-COS)*x*x + COS;
      A[0][1] = (1-COS)*x*y - SIN*z;
      A[0][2] = (1-COS)*x*z + SIN*y;
      A[0][3] = 0;

      A[1][0] = (1-COS)*x*y + SIN*z;
      A[1][1] = (1-COS)*y*y + COS;
      A[1][2] = (1-COS)*y*z - SIN*x;
      A[1][3] = 0;

      A[2][0] = (1-COS)*x*z - SIN*y;
      A[2][1] = (1-COS)*y*z + SIN*x;
      A[2][2] = (1-COS)*z*z + COS;
      A[2][3] = 0;

      A[3][0] = 0;
      A[3][1] = 0;
      A[3][2] = 0;
      A[3][3] = 1;
  }

VOID M_matrix_matrix(MATRIX A,MATRIX B)
  {
    INT i,j;
    MATRIX D;

    for(i=0;i<4;i++)
      for(j=0;j<4;j++)

          D[i][j] = B[i][0]*A[0][j] + B[i][1]*A[1][j] +
                    B[i][2]*A[2][j] + B[i][3]*A[3][j];

    for(i=0;i<4;i++) for(j=0;j<4;j++) A[i][j]=D[i][j];
  } 

VOID M_point_matrix(POINT *P,MATRIX M)
 {
    POINT B;

    B.x = P->x*M[0][0] + P->y*M[0][1] + P->z*M[0][2] + M[0][3];
    B.y = P->x*M[1][0] + P->y*M[1][1] + P->z*M[1][2] + M[1][3];
    B.z = P->x*M[2][0] + P->y*M[2][1] + P->z*M[2][2] + M[2][3];

    *P=B;
 }

VOID M_load_matrix(MATRIX A,MATRIX B)
  {
    INT i,j;

    for(i=0;i<4;i++) for(j=0;j<4;j++) A[i][j]=B[i][j];
  } 

/*------------------------------------------------------------------------*/
