/*
 *            Main Modul  -  main.c            
 *       Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */

#define MAIN
#include "typy.h"

const N=7;

MENU menu[10] =
 {
   " ",        0,0,0,0,0,0, "","","","","","","","","","","","",
   "File",     0,0,0,0,0,3, "Load",
                            "Save",
                            "Exit",
                            "","","","","","","","","",
   "Object",   0,0,0,0,0,8, "Sphere",
                            "Torus",
                            "Cylinder",
                            "Cube",
                            "Tetrahedron",
                            "Random Triangles",
                            "Rectangle",
                            "Remove Object",
                            "","","","",
   "Rotate",   0,0,0,0,0,5, "About X-axis",
                            "About Y-axis",
                            "About Z-axis",
                            "About vector",
                            "Movie Maker",
                            "","","","","","","",
   "Model",    0,0,0,0,0,10,"All Lines Visible",
                            "Front Face Frame",                            
                            "Front Face Color",
                            "Depth Sort Frame",
                            "Depth Sort Color",
                            "Contour Union 1",
                            "Contour Union 2",
                            "Contour Union 3",
                            "Contour Union 4",
                            "Z Buffer",
                            "","",
   "Action",   0,0,0,0,0,4, "Resize Scene",
                            "Move Scene",
                            "Move Observer",
                            "Resegment Scene",
                            "","","","","","","","",
   "Output",   0,0,0,0,0,4, "Screen",
                            "Pixmap",
                            "Image",
                            "File",
                            "","","","","","","","",
   "Setup",    0,0,0,0,0,7, "Screen Ratio",
                            "Rotation Angle",
                            "Scale Size",
                            "Inverse Colors",
                            "Projection",
                            "Show setup",
                            "Copyright",
                            "","","","","",
  };

VOID init_screen()
 {
   MinX=0;
   MinY=0;
   MaxX=Win_W;
   MaxY=Win_H;

   init_layout();
   init_menu();
   inform();

/*
 *   data structures allocation
 */
 
   close_CU3(); 
   open_CU3(Win_W,Win_H);  

   close_ZBF();
   open_ZBF(Win_W,Win_H);

   close_CU2();
   open_CU2(Win_W,Win_H);  
 }

VOID main(int argc,char *argv[])
 {
   if (argc==3) { Win_W=atoi(argv[1]); Win_H=atoi(argv[2]); 
                  if ((Win_W<200)|(Win_W>XMaxRES)) Win_W=600;
                  if ((Win_H<200)|(Win_H>YMaxRES)) Win_H=400; }
   else {Win_W=600; Win_H=400;}

   init_graph(Win_W,Win_H); 
   init_control();
   init_screen();

   while(1) { mouse_service(); zoom(); }
  }

VOID notice()
 {
   INT x1=MaxX-285,y1=MinY+20,x2=MaxX-10,y2=MinY+160;
   static CHAR *proj[2]={"Perspective","Parallel"};
   CHAR str[20];
   INT i=1,k=12;
   INT j,F=0,V=0;

   for(j=0;j<pt;j++) { F+=object[j].faces; V+=object[j].verts; }

   window(x1,y1,x2,y2," ",1);
   GColor(f->text);
   TextXY(x1+20,y1+i*k,"MODEL             :");
      TextXY(x1+140,y1+i*k,menu[4].item[c->model]);
      i++;
   TextXY(x1+20,y1+i*k,"ROTATION ANGLE    :"); 
      sprintf(str,"%f",180*c->angle/M_PI);
      TextXY(x1+140,y1+i*k,str);
      i++;
   TextXY(x1+20,y1+i*k,"SCALE SIZE        :");
      sprintf(str,"%f",c->dist); 
      TextXY(x1+140,y1+i*k,str);
      i++;
   TextXY(x1+20,y1+i*k,"OBSERVER POSITION :");
      sprintf(str,"%f",c->P.z);
      TextXY(x1+140,y1+i*k,str);
      i++;
   TextXY(x1+20,y1+i*k,"PROJECTION        :");
      TextXY(x1+140,y1+i*k,proj[c->proj]);
      i++;
   TextXY(x1+20,y1+i*k,"NUMBER OF OBJECTS :");
      sprintf(str,"%d",pt); 
      TextXY(x1+140,y1+i*k,str);
      i++;
   TextXY(x1+20,y1+i*k,"NUMBER OF FACES   :");
      sprintf(str,"%d",F);
      TextXY(x1+140,y1+i*k,str);
      i++;
   TextXY(x1+20,y1+i*k,"NUMBER OF VERTEX  :");
      sprintf(str,"%d",V);
      TextXY(x1+140,y1+i*k,str);
      i++;
   TextXY(x1+20,y1+i*k,"WINDOW SIZE       :");
      sprintf(str,"%d",GetMaxX());
      TextXY(x1+140,y1+i*k,str);
      TextXY(x1+165,y1+i*k,"x");
      sprintf(str,"%d",GetMaxY());
      TextXY(x1+180,y1+i*k,str);
      i++;
   GetKey();
   close_window();
 }

VOID movie()
 {
   CHAR ch=0;

   command("  X,Y,Z,R - Rotate  ESC - Quit");
   while(ch!=27)
    {
     rotate_all(); 
     go();
     IfKey(&ch);
     switch(ch)
       {
	 case 'x': c->r.x=1; c->r.y=0; c->r.z=0; ch=0; break;
    	 case 'y': c->r.x=0; c->r.y=1; c->r.z=0; ch=0; break;
	 case 'z': c->r.x=0; c->r.y=0; c->r.z=1; ch=0; break;
         case 'r': c->r.x=(FLOAT)1/sqrt((FLOAT)3);
                   c->r.y=c->r.x; c->r.z=c->r.x; ch=0; break;
       }
    }
   restore_command();
 }

VOID zoom()
  {
     INT ff;
     MinX=0; MinY=0;
     MaxX=GetMaxX(); MaxY=GetMaxY();
     ff=f->window; f->window=f->work; label(0,0,MaxX,MaxY,"",1); f->window=ff;
     MinX=4; MinY=4; MaxX=MaxX-MinX; MaxY=MaxY-MinY;

     movie(); 
     init_screen();
     go();
  }

VOID menu1(INT act_item)
 {
    switch(act_item)   /* FILE */
      {
	case 0 : if(get(input(100,200,"Read","file name:"))==0)
                     mess(210,160,"Not Found !");
                 else go(); 
		 break;
        case 1 : if(save(input(100,200,"Save","file name:"))==0)
		     mess(210,160,"Wrong Name !");
                 break;
        case 2 : close_graph(); exit(0);
      }
 }

VOID menu2(INT act_item)
 {
   INT M,N,i;
   POINT S,O,P;
   FLOAT R,r;
   MATRIX MTX;
   S.x=S.y=S.z=0;

   switch(act_item)   /* OBJECT */
     {
        case 0 : command("Enter Center of Sphere !");
                 S=sipka(&S,0);
                 command("Enter Radius of Sphere !");
                 P=sipka(&S,1);
                 R=distance(&S,&P);
                 restore_command();
           M=atoi(input(300,180,"Sphere","Number of longitudinal segments:"));
           N=atoi(input(310,190,"Sphere","Number of latitudinal segments:"));
                 if ((M<3)||(N<3)) { M=16; N=16;}
                 M_translate(MTX,&S);
                 object[pt] = sphere(MTX,&R,M-1,N);
                 pt++; 
                 break;
        case 1 : command("Enter Center of Torus !");
                 S=sipka(&S,0);
                 command("Enter Radius of Torus !");
                 P=sipka(&S,1);
                 R=distance(&S,&P);
                 command("Enter Radius of Tube !");
                 O=sipka(&P,1);
                 r=distance(&P,&O);
                 if (r>R) r=R/2;
                 restore_command();
                 N=atoi(input(300,180,"Anuloid","Number of Torus Segments:"));
                 M=atoi(input(310,190,"Anuloid","Number of Tube Segments:"));
                 if ((M<4)||(N<6)) { M=8; N=32; }
                 M_translate(MTX,&S);
                 object[pt] = torus(MTX,&R,&r,M,N);
                 pt++; 
                 break;
        case 2 : command("Enter Center of Cylinder !");
                 S=sipka(&S,0);
                 command("Enter Radius of Base !");
                 O=sipka(&S,1);
                 command("Enter Height of Cylinder !");
                 P=sipka(&O,1);
                 R=distance(&S,&O);
                 r=distance(&O,&P);
                 restore_command();
                 M=atoi(input(280,150,"Cylinder","Number of Segments:"));
                 if (M<3) M=16;
                 M_translate(MTX,&S);
                 object[pt] = cylinder(MTX,&R,&r,M);
                 pt++; 
                 break;
        case 3 : command("Enter Location of Cube !");
                 S=sipka(&S,0);
                 command("Enter Size of Cube !");
                 O=sipka(&S,1);
                 r=distance(&S,&O);
                 restore_command();
                 M_translate(MTX,&S);
                 object[pt] = cube(MTX,&r);
                 pt++; 
                 break;
        case 4 : command("Enter Location of Tetrahedron !");
                 S=sipka(&S,0);
                 command("Enter Size of Tetrahedron !");
                 O=sipka(&S,1);
                 r=distance(&S,&O);
                 restore_command();
                 M_translate(MTX,&S);
                 object[pt] = tetrahedron(MTX,&r);
                 pt++; 
                 break;
        case 5 : r=(FLOAT)atof(input(280,150,"Triangle","Area:"));
                 M=atoi(input(280,150,"Triangles","Number of Triangles:"));
                 object[pt] = triangles(&r,M);
                 pt++; 
                 break;
        case 6 : command("Corner of Rectangle");
                 O=sipka(&S,1);
                 restore_command();  
                 object[pt] = squere(&O);
                 pt++; 
                 break;
        case 7 : M=atoi(input(280,150,"Delete object","which one ? "));
                 if ((M<-1)||(M>=pt))
                    {
                      for(i=0;i<pt;i++) free_object(&object[i]);
                      pt=0;
                    }
                 if (pt>0)
                    {
                      free_object(&object[M]); pt--;
                      for(i=M;i<pt;i++) object[i]=object[i+1];
                    }
                 if (pt==0) Clear(MinX,MinY,MaxX,MaxY,f->work);
                 break;
      }

   if (pt>=MAX_OBJECTS) { mess(280,220,"Too much bodies !"); pt--; }
   else go();
 }

VOID menu3(INT act_item)
 {
   POINT V;
   FLOAT r;
   V.x=V.y=V.z=0;

   switch(act_item)   /* OTOC */
    {
       case 0 : c->r.x=1; c->r.y=0; c->r.z=0; break;
       case 1 : c->r.x=0; c->r.y=1; c->r.z=0; break;
       case 2 : c->r.x=0; c->r.y=0; c->r.z=1; break;
       case 3 : command("Draw Rotation Axis !");
                V=sipka(&V,1);
                restore_command();
                r = sqrt(V.x*V.x + V.y*V.y + V.z*V.z);
                if (r==0) { V.z=1; r=1; }
                V.x = V.x / r;
                V.y = V.y / r;
                V.z = V.z / r;
                c->r=V;               
                break;
       case 4 : movie(); return;
    }

   if (act_item!=4) rotate_all();
   go();
 }

VOID menu4(INT act_item)
 {
    switch(act_item)    /*  MODEL  */
     {
        case 0 : c->model = ALV;  break;
        case 1 : c->model = FFF;  break;
        case 2 : c->model = FFC;  break;
        case 3 : c->model = DSF;  break;
        case 4 : c->model = DSC;  break;
        case 5 : c->model = COU1; break;
        case 6 : c->model = COU2; break;
        case 7 : c->model = COU3; break;
        case 8 : c->model = COU4; break;
        case 9 : c->model = ZBF;  break;
     }
    go();
 }

VOID menu5(INT act_item)
 {
   POINT V;
   FLOAT sz;
   V.x=V.y=V.z=0;

   switch(act_item)  /* PARAMETRE */
     {

        case 0 : sz=(FLOAT)atof(input(240,160,"Resize Scene","Coeficient:"));
                 if (sz==0) sz=1;
                 resize_all(sz);
                 go();
                 break;
        case 1 : command("Draw Translation Vector !");
                 V=sipka(&V,1);
                 restore_command();
                 move_all(&V);
                 go();
                 break;
        case 2 : command("Enter Observer Translation !");
                 V=sipka(&V,1);
                 c->P=plus(&c->P,&V);
                 restore_command();
                 go();
                 break;
        case 3 : sz=(FLOAT)atof(input(180,160,"Resegment","Coeficient:"));
                 if (sz<0.01) sz=1;
                 Resegment(sz);
                 go();
                 break;
     }
 }

extern FILE *output_file;

VOID menu6(INT act_item)
 {
   Output(act_item);    
   go();
   if (act_item==GFILE) { fclose(output_file); Output(SCREEN); }
 }

VOID menu7(INT act_item)
 {
   INT ch;
 
   switch(act_item)  /* SETUP */
     {
        case 0: c->ratio=(FLOAT)
                   atof(input(180,160,"Screen Ratio","Ratio:"));
                if (c->ratio==0) c->ratio=1;
                go(); break;
        case 1: c->angle=(FLOAT)atof(input(200,180,"Rotation Angle",
                                                   "Enter Angle 0-360"));
                c->angle=c->angle*M_PI/180;
                c->COS=cos(c->angle);
	        c->SIN=sin(c->angle);
	        break;
        case 2: c->dist=(FLOAT)atof(input(180,160,"Scale Size","Enter Size"));
                if (c->dist==0) c->dist=1;
                go(); break;
        case 3: ch=f->work; f->work=f->line; f->line=ch;
                GColor(f->line);
                Clear(MinX,MinY,MaxX,MaxY,f->work);
                go(); break;
        case 4: if (c->proj) c->proj=0; 
                else c->proj=1; 
                go(); break;
        case 5: notice(); break;
        case 6: bye(); break;
     }
 }   

VOID item_function(INT act,INT act_item)
 {
   switch(act)
    {
      case 1: menu1(act_item); break;
      case 2: menu2(act_item); break;
      case 3: menu3(act_item); break;
      case 4: menu4(act_item); break;
      case 5: menu5(act_item); break;
      case 6: menu6(act_item); break;
      case 7: menu7(act_item); break;
    }
 }

/*------------------------------------------------------------------------*/
