/*
 *      Line Interpolator Interface   
 *      Draw and Fill Polygon Interface - linepo.c 
 *      Copyright (c) 1994,1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */

#include "typy.h"

VOID GLine(INT x1,INT y1,INT x2,INT y2)
  {
     INT x,y,k,dir;
     GColor(f->line);

     if (abs(x2-x1)>abs(y2-y1))
       {
         if (x1==x2) return;
         if (x1>x2) { dir= -1; k= ((y2-y1)<<10)/(x1-x2); }
               else { dir=  1; k= ((y2-y1)<<10)/(x2-x1); }

         x=x1;
         y=y1<<10;

         while(x!=x2)
          {
            x+=dir;
            y+=k;
            Point(x,y>>10);
          } 
       } 
     else
       {    
         if (y1==y2) return;
         if (y1>y2) { dir= -1; k= ((x2-x1)<<10)/(y1-y2); }
               else { dir=  1; k= ((x2-x1)<<10)/(y2-y1); }

         y=y1;
         x=x1<<10;

         while(y!=y2)
          {
            y+=dir;
            x+=k;
            Point(x>>10,y);
          } 
      }  
} 

/*
 *     Polygon
 */

VOID Line_Y_buf(INT x1,INT y1,INT x2,INT y2,INT *xbuf)
  {
     INT x,y,k,dir;
    
     if (y1==y2) return;

     if (y1>y2) { dir= -1; k= ((x2-x1)<<10)/(y1-y2); }
           else { dir=  1; k= ((x2-x1)<<10)/(y2-y1); }

     y=y1;
     x=x1<<10;
     xbuf[y1]=x1;

     while(y!=y2)
       {
          y+=dir;
          x+=k;
          xbuf[y]=x>>10;
       } 
  } 

VOID GFillPoly(INT N,POINT2 b[],INT Color_O,INT Color_V)
  {
    int i,j,k,l;
    int left[XMaxRES];
    int right[XMaxRES];
    int y_top,y_bottom;
    static struct {int x;int y;} bod[100];

    for(i=0;i<N;i++) { bod[i].x=b[i].x; bod[i].y=b[i].y; }
    for(i=0;i<N;i++) bod[N+i]=bod[i];
    bod[2*N]=bod[0];
    
    for(i=0;i<N;i++) 
       if (((bod[i].y-bod[i+1].y)>0)&&((bod[i+1].y-bod[i+2].y)<=0))
          { k=i+1; break; }

    l=k;
    y_top=bod[k].y;
    right[y_top]=bod[k].x;     

    while((bod[k].y-bod[k+1].y)<=0)
       { Line_Y_buf(bod[k].x,bod[k].y,bod[k+1].x,bod[k+1].y,right); k++; }

    y_bottom=bod[k].y;

    for(i=k;i<(N+l);i++)
         Line_Y_buf(bod[i].x,bod[i].y,bod[i+1].x,bod[i+1].y,left);

    GColor(Color_V);

    for(i=y_top;i<y_bottom;i++)
       for(j=right[i];j<=left[i];j++) Point(j,i);

 }

VOID GPoly(INT N,POINT2 bod[])
 {
   INT i;

   for(i=0;i<N-1;i++)
      GLine(bod[i].x,bod[i].y,bod[i+1].x,bod[i+1].y);

   GLine(bod[N-1].x,bod[N-1].y,bod[0].x,bod[0].y);
 }

/*--------------------------------------------------------------------------*/

