/*
 *        Graphics Environment Modul  -  grenvr.c          
 *        Copyright (c) 1994, 1995  R.Gosiorovsky, T.Hruz, I.Povazan
 */

#include "typy.h"

extern const N;
extern MENU menu[10];

INT ox1,oy1,ox2,oy2;
INT gap;

/*
 *     layout      
 */

VOID init_layout()
 {
    INT ff;
    ff=f->window;
    f->window=f->work;
    label(MinX,MinY,MaxX,MaxY,"3D Laboratory 1.0",0);
    f->window=ff;
    MaxX=MaxX-4;MaxY=MaxY-21;
    MinX=MinX+4;MinY=MinY+20;
    restore_command();
 }

/*
 *      internal window management
 */

VOID label(INT x1,INT y1,INT x2,INT y2,CHAR *header,INT head)
 {
   INT head_high=15,texthi,textwi;
   switch(head)
    {
     case 0: FillRectangle(x1+4,y1+4,x2-4,y1+head_high+4,f->header);
	     Line(x1+4,y1+head_high+4,x2-4,y1+head_high+4,f->frame);
             GColor(f->header_text);
             texthi=TextHeight(header);
             textwi=TextWidth(header);
             TextXY((x2+x1-textwi)/2,(2*y1+12+head_high-texthi)/2,header);
     case 1: Rectangle(x1,y1,x2,y2,f->frame);
             FillRectangle(x1+1,y1+1,x2-1,y1+2,f->border);
             FillRectangle(x1+1,y1+1,x1+2,y2-1,f->border);
             FillRectangle(x1+1,y2-2,x2-1,y2-1,f->border);
             FillRectangle(x2-2,y1+1,x2-1,y2-1,f->border);
             Rectangle(x1+3,y1+3,x2-3,y2-3,f->frame);
       	  FillRectangle(x1+4,y1+(1-head)*head_high+5-head,x2-4,y2-4,f->window);
             break;
     case 2: FillRectangle(x1,y1,x2,y2,f->window);
	     Rectangle(x1,y1,x2,y2,f->frame);
      }
  }

VOID window(INT x1,INT y1,INT x2,INT y2,CHAR *header,INT head)
  {
     INT shadow=8;
     ox1=x1;oy1=y1;ox2=x2+shadow;oy2=y2+shadow;
     GetArea(x1,y1,x2+shadow,y2+shadow);
     label(x1,y1,x2,y2,header,head);
     if (head) shadow=5;
     FillRectangle(x2+1,y1+shadow,x2+shadow,y2+shadow,f->shadow);
     FillRectangle(x1+shadow,y2+1,x2,y2+shadow,f->shadow);
   }

VOID close_window()
   {
     PutArea(ox1,oy1,ox2,oy2);
   }

/*
 *     menu management
 */

VOID active_pop(INT act)
    {
      FillRectangle(menu[act].start-gap/2,MinY-16,
                   menu[act+1].start-gap/2,MinY+14-16,f->text);
      GColor(f->window);
      TextXY(menu[act].start,MinY+4-16,menu[act].name);
    }

VOID deactive_pop(INT act)
    {
      FillRectangle(menu[act].start-gap/2,MinY-16,
                   menu[act+1].start-gap/2,MinY+14-16,f->window);
      GColor(f->text);
      TextXY(menu[act].start,MinY+4-16,menu[act].name);
     }

VOID active_pull(INT act)
     {
       INT i;
       window(menu[act].x1,menu[act].y1,
            menu[act].x2,menu[act].y2,menu[act].name,2);
       GColor(f->text);
       for(i=0;i<menu[act].items;i++)
           TextXY(menu[act].x1+20,menu[act].y1+12*i+10,menu[act].item[i]);
     }

VOID deactive_pull(INT act)
     {
       act=act;
       close_window();
     }

VOID active_item(INT act,INT act_item)
     {
        FillRectangle(menu[act].x1+1,menu[act].y1+12*act_item+8,
                     menu[act].x2-1,menu[act].y1+12*act_item+20,f->text);
        GColor(f->window);
        TextXY(menu[act].x1+20,menu[act].y1+12*act_item+10,
               menu[act].item[act_item]);
     }

VOID deactive_item(INT act,INT act_item)
     {
        FillRectangle(menu[act].x1+1,menu[act].y1+12*act_item+8,
                     menu[act].x2-1,menu[act].y1+12*act_item+20,f->window);
        GColor(f->text);
        TextXY(menu[act].x1+20,menu[act].y1+12*act_item+10,
               menu[act].item[act_item]);
     }

VOID init_menu()
    {
      INT maxlen,len;
      INT totallen=0,i,j;

      FillRectangle(MinX,MinY,MaxX,MinY+14,f->window);
      Line(MinX,MinY+15,MaxX,MinY+15,f->frame);
      GColor(f->text);

      for(i=1;i<=N;i++)	 totallen=totallen+TextWidth(menu[i].name);
      gap=(MaxX-MinX-totallen)/(N+1);
      menu[0].start=MinX;
      for(i=1;i<=N+1;i++)
             menu[i].start=menu[i-1].start+TextWidth(menu[i-1].name)+gap;
      for(i=1;i<=N;i++)  TextXY(menu[i].start,MinY+4,menu[i].name);
      for(i=1;i<=N;i++)
	{
          menu[i].y1=30+MinY;
	  menu[i].y2=menu[i].y1+menu[i].items*12+15;
          menu[i].x1=menu[i].start-i*6;
        }
      for(i=1;i<=N;i++)
	{
	  maxlen=0;
	  for(j=0;j<menu[i].items;j++)
	    {
	       len=TextWidth(menu[i].item[j]);
	       if (len > maxlen) maxlen=len;
	    }
	  menu[i].x2=menu[i].x1+40+maxlen;
	}
      MinY=MinY+16;
    }

/*
 *     user interaction management
 */

VOID mouse_service()
 {
    INT act,act_item;
    INT x,y;

    while(catch_mouse(&x,&y)!=3)
      {
        act=item_horizontal(x,y);
        active_pop(act);
        active_pull(act);

        while(catch_mouse(&x,&y)!=3)
          {
              act_item=item_vertical(x,y,act);
              if (act_item!=99) 
                {
                  deactive_pop(act);
                  deactive_pull(act);
                  item_function(act,act_item);
                  active_pull(act);
                  active_pop(act);
                }
              else 
                { 
                  deactive_pop(act);
                  deactive_pull(act);
                  act=item_horizontal(x,y);
                  active_pull(act);
                  active_pop(act);
                 }
          }
       deactive_pull(act);
       deactive_pop(act);
    }                           
 }

INT item_horizontal(INT x,INT y)
 {
   INT i,act=0;

   if (x>menu[N].start-gap/2) act=N;
   else for(i=1;i<N;i++) if (x<menu[i+1].start-gap/2) { act=i; break; }
   if (act==0) printf("act=0\n");
   return(act);
  } 

INT item_vertical(INT x,INT y,INT act)
 {
   INT i,act_item=99;

   if ((x>menu[act].x1)&&(x<menu[act].x2)&&(y>menu[act].y1)&&(y<menu[act].y2))
     {
        for(i=0;i<menu[act].items;i++) 
           if (y<(menu[act].y1+12*(i+2)-4)) { act_item=i; break; } 
     }
   return(act_item);
 } 

VOID key_service()
 {
    CHAR c;
    INT act_item;
    static INT act=1;

    active_pop(act);
    while((c=GetKey())!=ESCAPE)
     switch(c)
      {
        case RIGHT:
	     deactive_pop(act);
	     act++;
	     if (act==N+1) act=1;
	     active_pop(act); 
             break;
	case LEFT:
	     deactive_pop(act);
	     act--;
	     if (act==0) act=N;
	     active_pop(act); 
	     break;
	case GO:
	     active_pull(act);
	     act_item=0;
	     active_item(act,act_item);
	     while((c=GetKey())!=ESCAPE)
	      switch(c)
               { 
		case UP:
			     deactive_item(act,act_item);
			     act_item--;
			     if (act_item==-1) act_item=menu[act].items-1;
			     active_item(act,act_item);
			     break;
		case DOWN:
			     deactive_item(act,act_item);
			     act_item++;
			     if (act_item==menu[act].items) act_item=0;
			     active_item(act,act_item);
			     break;
		case RIGHT:
			     deactive_pop(act);
			     deactive_pull(act);
			     act++;
			     if (act==N+1) act=1;
			     active_pop(act);
			     active_pull(act);
			     act_item=0;
			     active_item(act,act_item);
			     break;
		case LEFT:
			     deactive_pop(act);
			     deactive_pull(act);
			     act--;
			     if (act==0) act=N;
			     active_pop(act);
			     active_pull(act);
			     act_item=0;
			     active_item(act,act_item);
			     break;
      		 case GO:
		             deactive_pull(act);
		             item_function(act,act_item);
		             active_pull(act);
		             active_item(act,act_item);
		             break;
	      }
           deactive_pull(act);
        }
   deactive_pop(act);
} 

VOID mess(INT x,INT y,CHAR *m)
  {
     INT thi,twi;
     GColor(f->text);
     twi=TextWidth(m);thi=TextHeight(m);
     window(x,y,x+twi+20,y+thi+20,"",2);
     TextXY(x+10,y+10,m);
     GetKey();
     close_window();
  }

CHAR in_buff[30];

CHAR *input(INT x,INT y,CHAR *top,CHAR *text)
   {
      CHAR c=0, *p;

      p=in_buff;

      window(x-10-5,y-20-50,x+200,y+25,top,0);
      Rectangle(x-5,y-7,x+190,y+15,f->frame);
      GColor(f->text);
      TextXY(x,y-28,text);

      while ((c=GetKey())!=GO)
	 {
	    if ((c>=' ')&&(c<='z'))
	       {
		    *p=c;
		    p++;
		    if (p>in_buff+30) p--;
		    *p=0;
	            TextXY(x,y,in_buff);
	       }
	     if (c==BACK)
	      {
		    p--;
		    if (p<in_buff) p++;
                    GColor(f->window);
		    TextXY(x+TextWidth(in_buff)-TextWidth(p),y,p);
		    *p=0;
		    GColor(f->text);
	      }
	  }
      close_window();
      if (p==in_buff) { *p='0'; p++; *p=0; }
      return(in_buff);
   }

VOID inform()
 {
   INT i;
   INT d=64;

   for(i=0;i<d;i++)
    {
FillRectangle(MinX,MinY+i*(MaxY-MinY)/d,MinX+20,MinY+(i+1)*(MaxY-MinY)/d,i);
Rectangle(MinX,MinY+i*(MaxY-MinY)/d,MinX+20,MinY+(i+1)*(MaxY-MinY)/d,f->frame);
    }
   MinX+=21;
 }

VOID command(CHAR *mes)
  {
    INT thi; 

    Line(MinX,MaxY+1,MaxX,MaxY+1,f->frame);
    FillRectangle(MinX,MaxY+2,MaxX,MaxY+17,f->window);

    GColor(f->text);
    thi=TextHeight(mes);
    TextXY(MinX+10,MaxY+4+(15-thi)/2,">");
    TextXY(MinX+25,MaxY+4+(15-thi)/2,mes);
  }

VOID restore_command()
  {
    INT thi,twi;
    CHAR *C="Copyright (c) 1994,1995";

    Line(MinX,MaxY+1,MaxX,MaxY+1,f->frame);
    FillRectangle(MinX,MaxY+2,MaxX,MaxY+17,f->bottom);

    GColor(f->text);
    thi=TextHeight("E");
    twi=TextWidth(C);
    TextXY(MaxX-twi-10,MaxY+4+(15-thi)/2,C);
  }

VOID anon(INT x,INT y,CHAR *head,INT N,CHAR *text[])
   {
     INT wi,hi,i;

     GColor(f->text);
     wi=TextWidth(text[0]);
     hi=TextHeight("I");

     window(x,y,x+wi+30,y+N*(hi+2)+50,head,0);
     GColor(f->text);
     for(i=0;i<N;i++)  TextXY(x+15,y+35+i*(hi+2),text[i]);
     GetKey();
     close_window();
   }

VOID bye()
  {
     static CHAR *a[7]=
               { "     3D Laboratory 1.0     ",
                 " ",
                 "  Copyright (c) 1994,1995",
                 "            by ",
                 "    Richard Gosiorovsky",
                 "        Tomas Hruz", 
                 "       Ivo Povazan", };

     anon(MaxX-250,MaxY-200,"About",7,a);
  }
/*-----------------------------------------------------------------------*/
