/* #########################################################################

			       XCORAL SMAC

   File: mouse.sc

   Created: Tue Nov 30 19:02:24 1993
   Author: Thierry Emery
   Modified: Fri Jan 21 16:26:31 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.2 $ $State: Exp $

   #########################################################################

   Note: mouse customization

   Requires: utilities.sc
	     mode-ext.sc

   Defines: control-left, control-right,
	    shift-left, shift-middle, shift-right

   Procedure: - to delete a character, control-left click on it
	      - to delete the end of a line, control-right click where you
		want to start deleting
	      - to transpose two forms, shift-left click on the beginning of
		the second form
	      - to yank a form where the cursor is, shift-middle click on it
		(for an expression between parentheses, brackets or braces,
		 click on the opening parenthesis, bracket or brace)
	      - to delete a form, shift-right click on it (for an expression
		between parentheses, brackets or braces, click on the opening
		parenthesis, bracket or brace)

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   C-left : delete clicked-on char
   ------------------------------------------------------------------------- */

void left_button_control(int pos) {

  goto_char(pos);
  delete_char();
}

/* -------------------------------------------------------------------------
   C-right : delete from clicked-on char to end of line
   ------------------------------------------------------------------------- */

void right_button_control(int pos) {

  goto_char(pos);

  if (current_position() == end_of_line())
    delete_char();
  else 
    delete_region(pos,end_of_line());
}

/* -------------------------------------------------------------------------
   transpose clicked-on form and preceding form
   ------------------------------------------------------------------------- */

void left_button_shift(int pos) {

  goto_char(pos);
  transpose_forms();
}

/* -------------------------------------------------------------------------
   insert clicked-on form at current position
   ------------------------------------------------------------------------- */

 middle_button_shift(int pos) {

  int origin = current_position();
  char* str;
  
  goto_char(pos);
  str = current_form();
  
  goto_char(origin);
  insert_string(str);
  
  free(str);
}

/* -------------------------------------------------------------------------
   delete clicked-on form
   ------------------------------------------------------------------------- */

void right_button_shift(int pos) {

  goto_char(pos);
  delete_current_form();
}

