/* #########################################################################

			       XCORAL SMAC

   File: make-ext.sc

   Created: Tue Dec 7 11:59:56 1993
   Author: Thierry Emery
   Modified: Mon Feb 21 10:10:28 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.3 $ $State: Exp $

   #########################################################################

   Note: make utilities : - asynchronous execution (in plain english : you
			    don't have to sit waiting for `make' to end !)
			  - error message display when visiting error
			    location (optionally in Messages window)

   Requires: utilities.sc
	     default-hack-filename.sc (or a definition of hack_file_name)

   Defines: Make, NextError, show_Make_error_messages

   Suggested bindings: "^x`" "NextError"

   Procedure: - to run a make command, execute `Make("<command>")'
	        (eg `Make("-k -d all")')
  	      - to visit error locations, type ^x` or execute `NextError'

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* ---------------------------------------------------------------------------
   Show error message in message window ?
   --------------------------------------------------------------------------- */

int show_Make_error_messages=0;

/* -------------------------------------------------------------------------
   finds titled window
   ------------------------------------------------------------------------- */

int find_titled_window(char* head) {
  
  int max_win_num=32;
  int cur_win, cur_origin;

  for (cur_win=0; cur_win<max_win_num; ++cur_win)
    if (select_window(cur_win) != -1) {
      cur_origin=current_position();
      goto_char(0);
      if (forward_search(head) && previous_char() != '"') {
	goto_char(cur_origin);
	return cur_win;
      }
      else
	goto_char(cur_origin);
    }
  
  return -1;
}


/* -------------------------------------------------------------------------
   Make init : necessary in current version (plus Shell Mode by hand)
   ------------------------------------------------------------------------- */

void BootMake() {
  
  char* head="***Shell Make Window***";
  int shell_win=find_titled_window(head), max_win_num=32;

  if (shell_win != -1) {
    display_message("Shell Make Window already exists...",
		    "IMPORTANT NOTE",1);
    return;
  }

  shell_win = new_window();
  
  if (shell_win != -1) {
    select_window(shell_win);
    insert_string(" ");
    insert_string(head);
    insert_string(" ");
    set_mode("Shell");
  }
  else
    display_message("Cannot create Shell Make Window...",
		    "IMPORTANT NOTE",1);
}

/* -------------------------------------------------------------------------
   extension of make : run make <make_command> in a shell mode window
   ------------------------------------------------------------------------- */

void Make(char* make_command) {
  
  char* head="***Shell Make Window***";
  char* file=filename();
  int	shell_win=find_titled_window(head), cmd_win;

  if (shell_win == -1) {
      BootMake();
      shell_win=find_titled_window(head);
  }

  if (shell_win != -1) {
    
    cmd("echo -n \"***\"; echo -n \"Cmd Result Window\"; echo \"***\"");
    cmd_win = find_titled_window("***Cmd Result Window***");
    select_window(cmd_win);
    lower_window();
    
    select_window(shell_win);
    upper_window();
    goto_end_of_file();
    
    insert_string("(cd ");
    insert_string(file);
    hack_file_name();
    goto_end_of_line();
    backward_search("/");
    delete_to_end_of_line();
    insert_string("; echo \"Shell Make(");
    insert_string(make_command);
    insert_string(")\"; make ");
    insert_string(make_command);
    insert_string(")\n");
    
  }
  else
    display_message("Please execute `BootMake();' to create Shell Make Window...",
		    "IMPORTANT NOTE",1);

  free(file);
}

/* -------------------------------------------------------------------------
   extract messages from shell make
   ------------------------------------------------------------------------- */

void extract_shell_make_messages() {
  
  int shell_win=find_titled_window("***Shell Make Window***"),
      cmd_win=find_titled_window("***Cmd Result Window***"),
      shell_orig, messages_beg, cmd_orig;
  char* messages=0;
  
  if (shell_win != -1 && cmd_win != -1) {
    
    select_window(shell_win);
    shell_orig = current_position();
    goto_end_of_file();
    if (backward_search("Shell Make(")) {
      messages_beg =   current_position();
      goto_end_of_file();
      goto_beginning_of_line();
      messages = window_substring(messages_beg,current_position());
    }
    goto_char(shell_orig);

    select_window(cmd_win);
    goto_end_of_file();
    cmd_orig = current_position();
    insert_string(messages);
    goto_char(cmd_orig);
    
    free(messages);
  }
}

/* -------------------------------------------------------------------------
   extension of go_next : copy error messages from shell window and 
   optionally show error message in messages window
   ------------------------------------------------------------------------- */

void NextError() {
  
  char* message;
  int cmd_win, cmd_orig, fin=0;
  
  cmd_win = find_titled_window("***Cmd Result Window***");

  if (cmd_win != -1) {
    select_window(cmd_win);
    upper_window();
    cmd_orig = current_position();
    goto_char(0);
    if (! forward_search("Shell Make("))
      extract_shell_make_messages();
    goto_char(cmd_orig);
          
    while (fin == 0) {
      if (forward_search(":")) {
	if (strchr("0123456789",previous_char()))
	  fin = 1;
      }
      else
	fin = -1;
    }

    
    if (show_Make_error_messages && fin == 1)
      message = window_substring(current_position()+1,end_of_line());
    else {
      message = (char*) malloc(1);
      message[0] = 0;
    }

    goto_char(cmd_orig);
    go_next();

    if (show_Make_error_messages) {
      display_message(message,"Error message :",1);
      free(message);
    }
  }
}

