/* #########################################################################

			       XCORAL SMAC

   File: describe.sc

   Created: Tue Nov 30 19:10:24 1993
   Author: Thierry Emery
   Modified: Fri Jan 21 16:25:47 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.2 $ $State: Exp $

   #########################################################################

   Note: SMAC functions writer and/or user help

   Defines: describe, describe_all,
	    display_int, display_char, display_string

   Procedure: - to get a SMAC function description, execute
		`describe(<function>)' (eg `describe(describe)')
	      - to get a listing of all current SMAC functions descriptions
		in a new window, execute `describe_all()'
	      - to display a global variable value or a function return
		value, execute `display_int(<exp>)', `display_char(<exp>)',
		or `display_string(<exp>)', depending on the result type

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   describe a function > Messages Box (inspired from describe_functions)
   ------------------------------------------------------------------------- */

void describe(void* f) {

  char* name = function_name(f);
  char* type = function_type(f);
  int	n_args = function_arg_count(f),
	builtin_p = (function_is_builtin(f)) ? 10 : 0;
  char* description;
  
  description = (char*) malloc(strlen(name)+builtin_p+strlen(type)+30);
    
  sprintf(description, "\n%s %s: %d param%s, %s\n",
	  name, (function_is_builtin(f)) ? "(builtin) " : "",
	  n_args, (n_args != 1) ? "s" : "", type);

  display_message(description,"Function description :",1);
  
  free(name);
  free(type);
  free(description);
}

/* -------------------------------------------------------------------------
   describe all functions > current window (modified from describe_functions)
   ------------------------------------------------------------------------- */

void describe_all() {

  void* f;
  int descr_win=new_window();

  if (descr_win != -1) {
    
    select_window(descr_win);
    init_function_list();
    
    while (f = function_list()) {
      char* name = function_name(f);
      char* type = function_type(f);
      int	n_args = function_arg_count(f);
      
      wprintf("%s : %s%d param%s, %s\n",
	      name, (function_is_builtin(f)) ? "(builtin) " : "",
	      n_args, (n_args != 1) ? "s" : "", type);
      
      free(name);
      free(type);
    }
    
    upper_window();
  }
}

/* -------------------------------------------------------------------------
   display_int, display_char, display_string : can be used to check a
   global variable value or a function return value
   ------------------------------------------------------------------------- */

void display_int(int value) {

    char val_message [64];

    sprintf(val_message,"= %d",value);
    display_message(val_message,"Value of int",1);
}

void display_char(char value) {

    char val_message [16];

    sprintf(val_message,"= '%c'",value);
    display_message(val_message,"Value of char",1);
}

void display_string(char* value) {

    char* val_message = (char*) malloc(strlen(value)+5);

    sprintf(val_message,"= \"%s\"",value);
    display_message(val_message,"Value of string",1);
    free(val_message);
}

