/* #########################################################################

			       XCORAL SMAC

   File: compare-win.sc
   Created: Mon Jan 3 17:19:21 1994
   Author: Thierry Emery
   Modified: Fri Jan 21 16:20:41 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.3 $ $State: Exp $

   #########################################################################

   Note: compare two windows

   Requires: basics.sc, window-utilities.sc

   Defines: Compare, CompareAgain

   Suggested bindings: ^xC for Compare_again()

   Procedure: position cursor successively in the two windows to be compared,
	      then execute `Compare' from one. Alter the windows or move
	      cursor in either or both in order to execute `CompareAgain'

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   Compared windows
   ------------------------------------------------------------------------- */

int Compare_compared_window=-1, Compare_reference_window=-1;

/* -------------------------------------------------------------------------
   Internal mechanics
   ------------------------------------------------------------------------- */

int Compare_compare_internal() {
  
  int compared_pos, reference_pos, compared_end, reference_end;
  
  compared_pos = current_position_in(Compare_compared_window);
  reference_pos = current_position_in(Compare_reference_window);
  compared_end = end_of_file_in(Compare_compared_window);
  reference_end = end_of_file_in(Compare_reference_window);
  
  while (compared_pos <= compared_end
	 && reference_pos <= reference_end
	 && (the_char_in(Compare_compared_window,compared_pos)
	     == the_char_in(Compare_reference_window,reference_pos))) {
    goto_char_in(Compare_compared_window,++compared_pos);
    goto_char_in(Compare_reference_window,++reference_pos);
  }
  
  if (compared_pos < compared_end && reference_pos < reference_end)
    return -1;
  else
    return 0;
}

/* -------------------------------------------------------------------------
   Start comparing current window to another one
   ------------------------------------------------------------------------- */

void Compare() {
  
  Compare_compared_window = current_window();
  Compare_reference_window = choose_window("Compare to");
  
  if (Compare_reference_window > 0
      && Compare_reference_window != Compare_compared_window)
    if (Compare_compare_internal() < 0)
      error("Difference detected");
}

/* -------------------------------------------------------------------------
   Resume comparing current window to other one
   ------------------------------------------------------------------------- */

void CompareAgain() {

  if (select_window(Compare_reference_window) >= 0
      && select_window(Compare_compared_window) >= 0)
    if (Compare_compare_internal() < 0)
      error("Difference detected");
}


