/* #########################################################################

			       XCORAL SMAC

   File: comments.sc

   Created: Tue Nov 30 19:02:35 1993
   Author: Thierry Emery
   Modified: Mon Feb 21 10:02:16 1994
   Last maintained by: Thierry Emery

   RCS $Revision: 1.6 $ $State: Exp $

   #########################################################################

   Note: comments utilities (file title comment and definitions comments)
   
   Requires: utilities.sc

   User interface: - title, update_title
		   - sharp_comment, plus_comment, equal_comment,
		     minus_comment, percent_comment

   SMAC programmer interface: - insert_title_xCS_info
			      - insert_general_title, insert_title,
			        insert_unix_title, smac_title
			      - comment

   Suggested bindings: "^x#" "sharp_comment"
		       "^x+" "plus_comment"
		       "^x=" "equal_comment"
		       "^x-" "minus_comment"
		       "^x%" "percent_comment"

   Procedure: - change if desired the value of insert_title_xCS_info
	      - to insert a file title, execute `insert_general_title',
		`insert_title', `insert_unix_title', `smac_title',
		`title', or a function of yours which calls one of these
	      - to update the `File', `Path', `Modified' and
		`Last maintained by' fields, execute `update_title'
	      - to insert function comments, execute `comment',
		`sharp_comment', `plus_comment', `equal_comment',
		`minus_comment', `percent_comment' or a function of yours
		which calls one of these

   #########################################################################

   Permission to use, copy, and distribute for non-commercial purposes, is
   hereby granted without fee, providing that this permission notice appear
   in all copies and in supporting documentation. The software may be
   modified for your own purposes, but modified versions may not be
   distributed. This software is provided "as is" without any expressed or
   implied warranty.

   ######################################################################### */

/* -------------------------------------------------------------------------
   redefinable variable for RCS (or even SCCS) info (possibly on several
   lines) - the default value is split up because this file is under RCS
   ------------------------------------------------------------------------- */

char* insert_title_xCS_info = (char*) malloc(25);

{
    sprintf(insert_title_xCS_info,"RCS %s%s%s\n",
	    "$Revision","$ $","State$");
}

/* -------------------------------------------------------------------------
   insert file base name (with extension)
   ------------------------------------------------------------------------- */

void insert_basename(char* file_name) {

  int origin = current_position(), beg, end;
  insert_string(file_name);
  end = current_position();
  backward_search("/");
  beg = current_position()+1;
  delete_region(origin, beg);
  goto_char(origin+end-beg);
}

/* -------------------------------------------------------------------------
   insert file name (with call to hack_file_name for logical path)
   ------------------------------------------------------------------------- */

void insert_filename(char* file_name) {

  insert_string(file_name);
  hack_file_name(); /* redefinable file name hack */
}

/* -------------------------------------------------------------------------
   insert user's full name
   ------------------------------------------------------------------------- */

void insert_user_full_name() {

  cmd_shell("ypcat passwd | awk -F: '($1==\"'\"$USER\"'\") {print $5;}'");
  delete_previous_char();
}

/* -------------------------------------------------------------------------
   insert date
   ------------------------------------------------------------------------- */

void insert_date() {

  cmd_shell("date | awk '{printf(\"%s %s %s %s %s\",$1,$2,$3,$4,$6);}'");
}

/* -------------------------------------------------------------------------
   insert a title separator line
   ------------------------------------------------------------------------- */

void insert_title_separator(char* comment_start, int multi_line_p,
			    char line_char, int width) {

  if (!multi_line_p)
    insert_string(comment_start);
  else
    insert_chars(strlen(comment_start),' ');
  insert_chars(width, line_char);
  insert_char('\n');
}

/* -------------------------------------------------------------------------
   insert a title `blank' line
   ------------------------------------------------------------------------- */

void insert_title_blank(char* comment_start, int multi_line_p, int width) {

  if (!multi_line_p)
    insert_string(comment_start);
  insert_char('\n');
}

/* -------------------------------------------------------------------------
   insert a title line beginning with <str>
   ------------------------------------------------------------------------- */

void insert_title_line_start(char* str, char* comment_start,
			     int multi_line_p) {

  if (multi_line_p)
    insert_chars(strlen(comment_start),' ');
  else
    insert_string(comment_start);
  insert_string(str);
}

/* -------------------------------------------------------------------------
   insert title lines, optionally centered
   ------------------------------------------------------------------------- */

void insert_title_lines(char* str, char* comment_start, int multi_line_p,
			int centered_p, int width) {

  int origin=current_position(), end;

  insert_string(str);
  insert_char('\n');
  end = current_line();

  goto_char(origin);
  while(current_line() < end) {
    if (centered_p)
      center_line_within(width);
    else
      insert_chars(strlen(comment_start),' ');
    if (!multi_line_p) {
      goto_beginning_of_line();
      insert_string(comment_start);
    }
    goto_next_line();
  }
  goto_line(end);
  goto_beginning_of_line();
}

/* -------------------------------------------------------------------------
   insert title at beginning of file (similar to the one above), centering
   <name>, including author and creation date, using <comment_start> and
   <comment_end>, and using char <line_char> to build separator lines of
   width <width>
   ------------------------------------------------------------------------- */

void insert_general_title(char* name, char* organization, char* copyright,
			  char* comment_start, char* comment_end,
			  int multi_line_p, char line_char, int width) {

  char* file_name=filename();

  goto_char(0);
  insert_title_separator(comment_start,0,line_char,width);
  insert_title_blank(comment_start,multi_line_p,width);

  insert_title_lines(name,comment_start,multi_line_p,1,width);
  insert_title_blank(comment_start,multi_line_p,width);

  if (organization && strlen(organization) > 0) {
    insert_title_lines(organization,comment_start,multi_line_p, 1,width);
    insert_title_blank(comment_start,multi_line_p,width);
  }

  insert_title_line_start("File: ",comment_start,multi_line_p);
  if (file_name)
    insert_basename(file_name);
  insert_char('\n');

  insert_title_line_start("Path: ",comment_start,multi_line_p);
  if (file_name) {
    insert_filename(file_name);
  }
  insert_char('\n');

  insert_title_line_start("Description: \n",comment_start,multi_line_p);

  insert_title_line_start("Created: ",comment_start,multi_line_p);
  insert_date();
  insert_char('\n');

  insert_title_line_start("Author: ",comment_start,multi_line_p);
  insert_user_full_name();
  insert_char('\n');

  insert_title_line_start("Modified: ",comment_start,multi_line_p);
  insert_date();
  insert_char('\n');

  insert_title_line_start("Last maintained by: ",comment_start,multi_line_p);
  insert_user_full_name();
  insert_char('\n');
  insert_title_blank(comment_start,multi_line_p,width);

  insert_title_lines(insert_title_xCS_info,comment_start,multi_line_p,0,width);
  insert_title_blank(comment_start,multi_line_p,width);

  if (copyright) {
    insert_title_lines(copyright,comment_start,multi_line_p,1,width);
    insert_title_blank(comment_start,multi_line_p,width);
  }

  insert_title_separator(comment_start,multi_line_p,line_char,width);
  insert_title_blank(comment_start,multi_line_p,width);
  insert_title_line_start("Note: \n",comment_start,multi_line_p);
  insert_title_blank(comment_start,multi_line_p,width);

  insert_title_separator(comment_start,multi_line_p,line_char,width);
  if (multi_line_p) {
    delete_previous_char();
    insert_string(comment_end);
  }

  insert_chars(2,'\n');

  if (file_name)
    free(file_name);
}

/* -------------------------------------------------------------------------
   insert a multi-line title at beginning of file (similar to the one above),
   centering <name>, including author and creation date, with C/C++ type
   comment separators, using char <line_char> to build separator lines of
   width <width>
   ------------------------------------------------------------------------- */

void insert_title(char* name, char* organization, char* copyright,
		  char line_char, int width) {

  insert_general_title(name,organization,copyright,
		       "/* "," */",1,line_char,width);
}

/* -------------------------------------------------------------------------
   insert a multi-line title at beginning of file (similar to the one above),
   centering <name>, including author and creation date, with C/C++ type
   comment separators, using char <line_char> to build separator lines of
   width <width>
   ------------------------------------------------------------------------- */

void insert_unix_title(char* name, char* organization, char* copyright,
		       char line_char, int width) {

  insert_general_title(name,organization,copyright,
		       "# ",0,0,line_char,width);
}

/* -------------------------------------------------------------------------
   insert SMAC title at beginning of file
   ------------------------------------------------------------------------- */

void smac_title() {

  int origin=current_position();

  insert_title("XCORAL SMAC",0,0,'#',73);
  goto_char(0);
  forward_search("Note:");
  goto_next_line();
  insert_string("\n   Requires: \n\n   Defines: \n");
  insert_string("\n   Suggested bindings: \n\n   Procedure: \n");
  goto_char(origin);
}

/* -------------------------------------------------------------------------
   insert named title at beginning of file
   ------------------------------------------------------------------------- */

void title(char* name) {

  insert_title(name,0,0,'-',73);
}

/* -------------------------------------------------------------------------
   update File, Path, Modified and Last maintained by
   
   hack_file_name() can be redefined to modify the inserted filename, for
   instance to restore the logical path from the automount path (see
   default-hack-filename.sc)
   ------------------------------------------------------------------------- */

void update_title() {

  int origin=current_position(), beg;
  char* file_name=filename();
  
  goto_char(0);
  
  if (forward_search("Note:")) {
    
    if (backward_search("Last maintained by:")) {
      forward_search(": ");
      goto_char(current_position()+2);
      delete_to_end_of_line();
      insert_user_full_name();
    }
    
    if (backward_search("Modified:")) {
      forward_search(": ");
      goto_char(current_position()+2);
      delete_to_end_of_line();
      insert_date();
    }
    
    if (file_name && backward_search("Path:")) {
      forward_search(": ");
      goto_char(current_position()+2);
      delete_to_end_of_line();
      insert_filename(file_name);
    }
    
    if (file_name && backward_search("File:")) {
      forward_search(": ");
      beg = current_position()+2;
      goto_char(beg);
      delete_to_end_of_line();
      insert_basename(file_name);
    }
  }

  goto_char(origin);
}

/* -------------------------------------------------------------------------
   insert <char> delimited comment of width <width>
   ------------------------------------------------------------------------- */

void comment(char line_char, int width) {

  int pos;
  
  insert_string("/* ");
  insert_chars(width, line_char);
  insert_string("\n   ");
  
  pos = current_position();
  
  insert_string("\n   ");
  insert_chars(width, line_char);
  insert_string(" */\n\n");
  
  goto_char(pos);
}

/* -------------------------------------------------------------------------
   insert '#' delimited comment
   ------------------------------------------------------------------------- */

void sharp_comment() {

  comment('#',73);
}

/* -------------------------------------------------------------------------
   insert '+' delimited comment
   ------------------------------------------------------------------------- */

void plus_comment() {

  comment('+',73);
}

/* -------------------------------------------------------------------------
   insert '=' delimited comment
   ------------------------------------------------------------------------- */

void equal_comment() {

  comment('=',73);
}

/* -------------------------------------------------------------------------
   insert '-' delimited comment
   ------------------------------------------------------------------------- */

void minus_comment() {

  comment('-',73);
}

/* -------------------------------------------------------------------------
   insert '%' delimited comment
   ------------------------------------------------------------------------- */

void percent_comment() {

  comment('%',73);
}

