
/*
** Copyright 1993 by Bruno Pages
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
** This software is provided "as is" without any expressed or implied warranty.
**
**
*/

/* Define a new class.
   Parent classes names must be separated by `,` or spaces */

void class_header()
{
  char * classname = gets("Class name ? ");
  char * parent;
  
  if (! classname)
    return;
  if  (*classname == 7) {
    free(classname);
    return;
  }
  
  parent = gets("Parent classes names ? ");

  wprintf("//\n//\tClass name : %s\n//\n//\tDescription :\n//\n",
	  classname);
  wprintf("class %s", classname);
  if (parent && (*parent != 7)) {
    char * sep = " : ";
    char * first = parent;
    char * p;
    
    while (p = strtok(first, " ,")) {
      wprintf("%spublic %s", sep, p);
      first = 0;
      sep = ", ";
    }
  }
  wprintf(" {\n");
  wprintf("  public:\n\t%s();\n\t%s(const %s &);\n\t~%s();\n\t\n",
	  classname, classname, classname, classname);
  wprintf("  protected:\n  private:\n};\n\n");
  goto_line(current_line() - 5);
  goto_end_of_line();
  
  free(classname);
  if (parent) free(parent);
}


/* A new method */
   
void method_header()
{
  char * methodname = gets("Method name ? ");
  char * classname;
  
  if (! methodname)
    return;
  if  (*methodname == 7) {
    free(methodname);
    return;
  }
  
  classname = gets("Class name ? ");
  
  if (! classname) {
    free(methodname);
    return;
  }
  if (*classname == 7) {
    free(methodname);
    free(classname);
    return;
  }
  
  wprintf("//\n//\tMethod name : %s\n//\n//\tDescription :\n//\tInput :\n//\tOutput :\n//\n",
	  methodname);
  wprintf("%s::%s()\n{\n  \n}\n\n", classname, methodname);
  goto_line(current_line() - 3);
  goto_end_of_line();
  free(classname);
  free(methodname);
}


/* A new function */

void function_header()
{
  char * functionname = gets("Function name ? ");
  
  if (! functionname)
    return;
  if  (*functionname == 7) {
    free(functionname);
    return;
  }
  
  wprintf("/*\n**\tFunction name : %s\n**\n**\tDescription :\n**\tInput :\n**\tOutput :\n*/\n",
	  functionname);
  wprintf("%s()\n{\n  \n}\n\n", functionname);
  goto_line(current_line() - 3);
  goto_end_of_line();
  free(functionname);
}


/* File header, a suffixe <> .h => a c file */

void include_header()
{
  char * filepath = filename();
  char * name;
  char * ext;
  
  if (! filepath) return;
  
  name = strrchr(filepath, '/');
  ext = strrchr(filepath, '.');
  
  if (! name)
    name = filepath;
  else
    name += 1;
  
  if (ext) {
    *ext++ = 0;
    if (*ext == 'h') {
      wprintf("#ifndef _%s_h\n#define _%s_h\n\n\n\n#endif\n",
	      name, name);
      goto_line(current_line() - 2);
    }
    else
      wprintf("#include \"%s.h\"\n", name);
  }
  
  free(filepath);
}
