#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <sys/param.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include "Xfwf/TextMenu.h"
#include "config.h"
#define XINIT_C 1
#include "xinit.h"
#include "xdialog.h"

#ifndef PATH_MAX
#define PATH_MAX MAXPATHLEN
#endif

unsigned int w_width=600;
unsigned int w_height=600;
float w_mag=.6;
float r_width=1000;
float r_height=1000;
float scaleX=2.0;

void Quit(int exitval)
{
#ifdef DEBUG
  DebugTini();
#endif
  exit(exitval);
}

static
void FontPathInit()
{
  DIR /* struct dirent */ *dir;
  int dum;
  char **fonts;
  char homefonts[PATH_MAX];

  myfontpaths=0;
  myfontpath=(char**)calloc(2,sizeof(char*));
  strcpy(homefonts,getenv("HOME"));
  strcat(homefonts,"/Fonts");
  myfontpath[myfontpaths]=strdup(homefonts);
  if((dir=opendir(myfontpath[myfontpaths]))!=NULL)
    {
      myfontpaths++; closedir(dir);
    }

  myfontpath[myfontpaths]=MYWORD_FONTPATH;
  if((dir=opendir(myfontpath[myfontpaths]))!=NULL)
    {
      myfontpaths++; closedir(dir);
    }
  
  fonts=XListFonts(display,"-myword-*-*-*-*-*-*-*-*-*-*-*-iso8859-1",1,&dum);
  if((fonts==0)||(strncmp(fonts[0],"-myword-",8)))
    {
      int i;
      char **newfonts;

      XFreeFontNames(fonts);
      fonts=XGetFontPath(display,&dum);
      newfonts=(char**)calloc((dum+myfontpaths),sizeof(char*));

      if(myfontpaths>0)
	{
	  for(i=0;i<myfontpaths;i++)
	    newfonts[i]=strdup(myfontpath[i]);
	  for(i=0;i<dum;i++)
	    newfonts[i+myfontpaths]=strdup(fonts[i]);
	  /*bcopy((char*)fonts,(char*)(newfonts+i),
		(unsigned)(dum*sizeof(char*)));*/
	  XSetFontPath(display,newfonts,(unsigned)dum+myfontpaths);
	  for(i=0;i<myfontpaths+dum;i++)
	    free(newfonts[i]);
	}
      free((char*)newfonts);
      XFreeFontPath(fonts);
      XFlush(display);
    }
  else
    XFreeFontNames(fonts);
  if(myfontpaths==0)
    {
      fprintf(stderr,"You have no Font-Path, right?\n");
      fprintf(stderr,"Get one and join in again!\n");
      exit(3299594);
    }
}

void xinit(argc,argv)
int argc;
char *argv[];
{
  XGCValues values;
  Widget /*topLevel,*/ form, buttonbox, file, edit, layout, font,
         menu, entry; /*, statusbox;*/
         
  
  topLevel=XtVaAppInitialize(
			     &app_context,
			     "MyWord",
			     NULL, 0,
			     &argc, argv,
			     NULL,
			     NULL);
  form=XtVaCreateManagedWidget("form",formWidgetClass,topLevel,NULL);
   buttonbox=XtVaCreateManagedWidget("buttonbox",boxWidgetClass,form,NULL);
#if 0
    file=XtVaCreateManagedWidget("file",menuButtonWidgetClass,buttonbox,NULL);
    menu=XtVaCreatePopupShell("filemenu",simpleMenuWidgetClass,file,NULL);
     entry=XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
  /* New */
     entry=XtVaCreateManagedWidget("item1",smeBSBObjectClass,menu,NULL);
     XtAddCallback(entry,XtNcallback,doDeleteText,act_text);
  /* Load */
     entry=XtVaCreateManagedWidget("item2",smeBSBObjectClass,menu,NULL);
     XtAddCallback(entry,XtNcallback,PopupLoad,act_text);
  /* Save */
     entry=XtVaCreateManagedWidget("item3",smeBSBObjectClass,menu,NULL);
     XtAddCallback(entry,XtNcallback,doSave,act_text);
  /* Write to */
     entry=XtVaCreateManagedWidget("item4",smeBSBObjectClass,menu,NULL);
     XtAddCallback(entry,XtNcallback,PopupWriteTo,act_text);
  /* Import */
     entry=XtVaCreateManagedWidget("item5",smeBSBObjectClass,menu,NULL);
  /* Print */
     entry=XtVaCreateManagedWidget("item6",smeBSBObjectClass,menu,NULL);
     XtAddCallback(entry,XtNcallback,PopupPrint,act_text);
  /* Quit */
     entry=XtVaCreateManagedWidget("item7",smeBSBObjectClass,menu,NULL);
     XtAddCallback(entry,XtNcallback,Quit,0);*/
#endif
   file=XtVaCreateManagedWidget("file",menuButtonWidgetClass,buttonbox,NULL);
    filemenu=XtCreatePopupShell("filemenu",xfwfTextMenuWidgetClass,
				file,NULL,0);
    XtAddCallback(filemenu,XtNactivate,doMenu,(XtPointer)1);

/*    edit=XtVaCreateManagedWidget("edit",menuButtonWidgetClass,buttonbox,NULL);
    menu=XtVaCreatePopupShell("editmenu",simpleMenuWidgetClass,edit,NULL);
     entry=XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item1",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item2",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item3",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item4",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item5",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item6",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item7",smeBSBObjectClass,menu,NULL);*/
   edit=XtVaCreateManagedWidget("edit",menuButtonWidgetClass,buttonbox,NULL);
    editmenu=XtCreatePopupShell("editmenu",xfwfTextMenuWidgetClass,
				edit,NULL,0);
    XtAddCallback(editmenu,XtNactivate,doMenu,(XtPointer)2);
				
/*    layout=XtVaCreateManagedWidget("layout",menuButtonWidgetClass,buttonbox,NULL);
    menu=XtVaCreatePopupShell("layoutmenu",simpleMenuWidgetClass,layout,NULL);
     entry=XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item1",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item2",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item3",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item4",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item5",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item6",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item7",smeBSBObjectClass,menu,NULL);*/
   layout=XtVaCreateManagedWidget("layout",menuButtonWidgetClass,
				  buttonbox,NULL);
    layoutmenu=XtCreatePopupShell("layoutmenu",xfwfTextMenuWidgetClass,
				  layout,NULL,0);
    XtAddCallback(layoutmenu,XtNactivate,doMenu,(XtPointer)3);

#if 0
    font=XtVaCreateManagedWidget("font",menuButtonWidgetClass,buttonbox,NULL);
    menu=XtVaCreatePopupShell("fontmenu",simpleMenuWidgetClass,font,NULL);
     entry=XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
/* Select Font */
     entry=XtVaCreateManagedWidget("item1",smeBSBObjectClass,menu,NULL);
     XtAddCallback(entry,XtNcallback,PopupFontsel,NULL);
     entry=XtVaCreateManagedWidget("item2",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item3",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item4",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item5",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item6",smeBSBObjectClass,menu,NULL);
     entry=XtVaCreateManagedWidget("item7",smeBSBObjectClass,menu,NULL);*/
#endif
   font=XtVaCreateManagedWidget("font",menuButtonWidgetClass,buttonbox,NULL);
    fontmenu=XtCreatePopupShell("fontmenu",xfwfTextMenuWidgetClass,
				font,NULL,0);
  XtAddCallback(fontmenu,XtNactivate,doMenu,(XtPointer)4);

   viewport=XtVaCreateManagedWidget("viewport",viewportWidgetClass,form,NULL);
   XtAddCallback(viewport,XtNreportCallback,myViewAreaChange,NULL);
    bitmap=XtVaCreateManagedWidget("bitmap",coreWidgetClass,viewport,NULL);
    status=XtVaCreateManagedWidget("status",coreWidgetClass,form,NULL);
     status_id=status_idc=0;

/* Popups */
#if 0
   filesel=XtVaCreatePopupShell("filesel",transientShellWidgetClass,
				topLevel,NULL);
    fseldialog=XtVaCreateManagedWidget("name",dialogWidgetClass,filesel,
				       XtNlabel,"WRITE TO FILE: ",NULL);
    entry=XtVaCreateManagedWidget("done",commandWidgetClass,fseldialog,NULL);
    XtAddCallback(entry,XtNcallback,doLoadSave,fseldialog);
    entry=XtVaCreateManagedWidget("cancel",commandWidgetClass,fseldialog,NULL);
    XtAddCallback(entry,XtNcallback,PopdownFilesel,NULL);
#endif
   overwrite=XtVaCreatePopupShell("overwrite",transientShellWidgetClass,
			       topLevel,NULL);
    menu=XtVaCreateManagedWidget("form",formWidgetClass,overwrite,NULL);
     overwrite_label=XtVaCreateManagedWidget("label",labelWidgetClass,menu,NULL);
     menu=XtVaCreateManagedWidget("yesno",boxWidgetClass,menu,NULL);
     overwrite_yes=XtVaCreateManagedWidget("yes",commandWidgetClass,menu,NULL);
     XtAddCallback(overwrite_yes,XtNcallback,doOverwrite,overwrite);
     overwrite_no=XtVaCreateManagedWidget("no",commandWidgetClass,menu,NULL);
     XtAddCallback(overwrite_no,XtNcallback,Popdown,overwrite);

   fontsel=XtVaCreatePopupShell("fontsel",transientShellWidgetClass,
				topLevel,NULL);
    fontseldialog=XtVaCreateManagedWidget("name",
					  dialogWidgetClass,fontsel,NULL);
     entry=XtVaCreateManagedWidget("done",commandWidgetClass,
				   fontseldialog,NULL);
     XtAddCallback(entry,XtNcallback,doFontsel,fontseldialog);
     entry=XtVaCreateManagedWidget("cancel",commandWidgetClass,
				   fontseldialog,NULL);
     XtAddCallback(entry,XtNcallback,PopdownFontsel,fontseldialog);


  myAppAddActions(app_context);
  
  XtInstallAllAccelerators(file,file);
  XtInstallAllAccelerators(edit,edit);
  XtInstallAllAccelerators(layout,layout);
  XtInstallAllAccelerators(font,font);
  XtInstallAccelerators(topLevel,file);
  XtInstallAccelerators(topLevel,edit);
  XtInstallAccelerators(topLevel,layout);
  XtInstallAccelerators(topLevel,font);

  XtRealizeWidget(topLevel); 

  /* Default Values */
  hscroll=XtNameToWidget(viewport,"horizontal");
  vscroll=XtNameToWidget(viewport,"vertical");
  display=XtDisplay(topLevel);

  XtVaSetValues(bitmap,XtNheight,w_height,XtNwidth,w_width,NULL);
  bitmapW=XtWindow(bitmap);

/*  myGetVWidth();*/
  XtVaSetValues(status,XtNwidth,v_width,NULL);
  XtVaSetValues(buttonbox,XtNwidth,v_width,NULL);
  statusW=XtWindow(status);

  gcFore=XCreateGC(display,DefaultRootWindow(display),0,&values);
  gcBack=XCreateGC(display,DefaultRootWindow(display),0,&values);
  gcCursor=XCreateGC(display,DefaultRootWindow(display),0,&values);
  gcStatus=XCreateGC(display,DefaultRootWindow(display),0,&values);
  white=WhitePixelOfScreen(DefaultScreenOfDisplay(display));
  black=BlackPixelOfScreen(DefaultScreenOfDisplay(display));
  XSetForeground(display,gcFore,black);
  XSetForeground(display,gcBack,white);
  XSetForeground(display,gcCursor,white^black);
  XSetFunction(display,gcCursor,GXxor);
/*  XSetPlaneMask(display,gcCursor,XAllPlanes());*/

  FontPathInit();

  {
    XFontStruct *f;
    XtVaGetValues(font,XtNfont,&f,NULL);
    XSetFont(display,gcStatus,f->fid);
    XSetForeground(display,gcStatus,black);
    XSetFunction(display,gcStatus,GXcopy);
  }

  XtAppMainLoop(app_context);
}
