/* file: xencapsulate.c
   encapulates actions from app-defaults
*/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/keysym.h>
#include "myword.h"
#include "xinternal.h"
#include "xdialog.h"
#include "debug.h"
#include "status.h"
#include "xactions.h"
#include "xinit.h"
#include "selection.h"

#define XTActionArgs Widget,XEvent*,String*,Cardinal*

static void myBackSpace(XTActionArgs);
static void myReturn(XTActionArgs);
static void myLeft(XTActionArgs);
static void myRight(XTActionArgs);
static void myUp(XTActionArgs);
static void myDown(XTActionArgs);
static void myPageUp(XTActionArgs);
static void myPageDown(XTActionArgs);
static void myHome(XTActionArgs);
static void myEnd(XTActionArgs);
static void myRewritePage(XTActionArgs);
static void myQuit(XTActionArgs);
static void myInitText(XTActionArgs);
static void myButton(XTActionArgs);
static void myKeyPress(XTActionArgs);
/*static void myDelayedRewritePage(XTActionArgs);
static void myRewriteWholePage(XTActionArgs);*/
static void myUnselect(XTActionArgs);
static void mySelBegin(XTActionArgs);
static void mySelEnd(XTActionArgs);
static void myMouseSelEnd(XTActionArgs);
/*static void myDebugScroll(XTActionArgs);
static void myDebugLoad(XTActionArgs);*/
static void myPrintActPage(XTActionArgs);
static void mySave(XTActionArgs);
static void myOverwrite(XTActionArgs);
static void myPopdown(XTActionArgs);
static void myPopdownFontsel(XTActionArgs);
static void myFontsel(XTActionArgs);
static void myPopupLoad(XTActionArgs);
static void myPopupWriteTo(XTActionArgs);
static void myPopupPrint(XTActionArgs);
static void myPopupFontsel(XTActionArgs);


static
XtActionsRec actions[]= {
/*  {"myDebugScroll",myDebugScroll},
  {"myDebugLoad",myDebugLoad},*/
  {"myRewritePage",myRewritePage},
  {"myQuit",myQuit},
  {"myInitText",myInitText},
  {"myButton",myButton},
  {"myKeyPress",myKeyPress},
  {"myBackSpace",myBackSpace},
  {"myReturn",myReturn},
  {"myLeft",myLeft},
  {"myRight",myRight},
  {"myUp",myUp},
  {"myDown",myDown},
  {"myHome",myHome},
  {"myEnd",myEnd},
  {"myPageUp",myPageUp},
  {"myPageDown",myPageDown},
  {"myUnselect",myUnselect},
  {"mySelBegin",mySelBegin},
  {"mySelEnd",mySelEnd},
  {"myMouseSelEnd",myMouseSelEnd},
  {"mySave",mySave},
  {"myOverwrite",myOverwrite},
  {"myPopdown",myPopdown},
  {"myPopdownFontsel",myPopdownFontsel},
  {"myFontsel",myFontsel},
  {"myPopupLoad",myPopupLoad},
  {"myPopupWriteTo",myPopupWriteTo},
  {"myPopupPrint",myPopupPrint},
  {"myPopupFontsel",myPopupFontsel},
  {"myPrintActPage",myPrintActPage},
};

void
myAppAddActions( XtAppContext app_context)
{
  XtAppAddActions(app_context,actions,XtNumber(actions));
}

static
void myQuit(Widget w, XEvent *e, String *s, Cardinal *n)
{
  Quit(0);
}

static
void myTab(Widget w, XEvent *e, String *s, Cardinal *n)
{
  doTab(*act_tpos);
}

static
void myRewritePage(Widget w, XEvent *e, String *s, Cardinal *n)
{
#ifdef DEBUG
  fprintf(debugfile,"\nmyRewritePage\n");
  fflush(debugfile);
#endif
  ClearStatus();

  FollowCursor();
  act_page->change=1;
  RewriteWholePage(act_page);
}

static
void myBackSpace(Widget w, XEvent *e, String *s, Cardinal *n)
{
  Tpos tpos;

#ifdef DEBUG
  fprintf(debugfile,"\nmyBackSpace\n");
  fflush(debugfile);
#endif
  ClearStatus();

  CleanLine(act_tpos->linep->line);
  tpos=PreviousTpos(*act_tpos);
  if((tpos.linep->line!=act_tpos->linep->line)
     &&(act_tpos->linep->line->newline==0))
    tpos=PreviousTpos(tpos);
  if((tpos.index!=act_tpos->index)||(tpos.linep!=act_tpos->linep))
    *act_tpos=DeleteChar(tpos);
  FollowCursor();
  DelayedRewritePage();
}

static
void myReturn(Widget w, XEvent *e, String *s, Cardinal *n)
{
#ifdef DEBUG
  fprintf(debugfile,"\nmyReturn\n");
  fflush(debugfile);
#endif
  ClearStatus();

  doReturn(act_tpos);
  CheckPage(act_page);
  FollowCursor();
  DelayedRewritePage();
}  

static
void myLeft(Widget w, XEvent *e, String *s, Cardinal *n)
{
#ifdef DEBUG
  fprintf(debugfile,"\nmyLeft\n");
  fflush(debugfile);
#endif
  ClearStatus();

/*  CursorUnblink();*/
  *act_tpos=PreviousTpos(*act_tpos);
  FollowCursor();
/*  DelayedRewritePage();*/
/*  CursorBlink();*/
}

static
void myRight(Widget w, XEvent *e, String *s, Cardinal *n)
{
#ifdef DEBUG
  fprintf(debugfile,"\nmyRight\n");
  fflush(debugfile);
#endif
  ClearStatus();

/*  CursorUnblink();*/
  *act_tpos=NextTpos(*act_tpos);
  FollowCursor();
/*  DelayedRewritePage();*/
/*  CursorBlink();*/
}

static
void myUp(Widget w, XEvent *e, String *s, Cardinal *n)
{
#ifdef DEBUG
  fprintf(debugfile,"\nmyUp\n");
  fflush(debugfile);
#endif
  ClearStatus();

/*  CursorUnblink();*/
  *act_tpos=LineUp(*act_tpos);
  FollowCursor();
/*  DelayedRewritePage();*/
/*  CursorBlink();*/
}

static
void myDown(Widget w, XEvent *e, String *s, Cardinal *n)
{
#ifdef DEBUG
  fprintf(debugfile,"\nmyDown\n");
  fflush(debugfile);
#endif
  ClearStatus();

/*  CursorUnblink();*/
  *act_tpos=LineDown(*act_tpos);
  FollowCursor();
/*  DelayedRewritePage(); */
/*  CursorBlink();*/
}

static
void myHome(Widget w, XEvent *e, String *s, Cardinal *n)
{
#ifdef DEBUG
  fprintf(debugfile,"\nmyHome\n");
  fflush(debugfile);
#endif
  ClearStatus();

  act_tpos->linep=act_tpos->linep->line->first;
  act_tpos->index=0;
  FollowCursor();
}

static
void myEnd(Widget w, XEvent *e, String *s, Cardinal *n)
{
  LineP *lp=act_tpos->linep;
#ifdef DEBUG
  fprintf(debugfile,"\nmyEnd\n");
  fflush(debugfile);
#endif
  ClearStatus();

  while(lp->next!=NULL)
    lp=lp->next;
  act_tpos->linep=lp;
  act_tpos->index=lp->clength;
}

static
void myPageUp(Widget w, XEvent *e, String *s, Cardinal *n)
{
  *act_tpos=PageUp(*act_tpos);
  FollowCursor();
}

static
void myPageDown(Widget w, XEvent *e, String *s, Cardinal *n)
{
  *act_tpos=PageDown(*act_tpos);
  FollowCursor();
}

static
void myButton(Widget w, XEvent *e, String *s, Cardinal *n)
/* was XButtonEvent */
{
  Pos pos;
  XButtonEvent *event=(XButtonEvent*)e;

#ifdef DEBUG
  fprintf(debugfile,"\nmyButton: %d,%d\n",event->x,event->y);
  fflush(debugfile);
#endif
  ClearStatus();

  pos.x=event->x/scaleX; pos.y=event->y/scaleX;
/*  fprintf(stderr," But: %f, %f\n", pos.x,pos.y);*/
/*  fprintf(stderr," Unselect: %d,%d\n",bookmark[1].linep,bookmark[2].linep);*/
  Unselect();
  bookmark[1].linep=NULL;
/*  fprintf(stderr,"Unselect: %d,%d\n",bookmark[1].linep,bookmark[2].linep);*/
  *act_tpos=Pos2Tpos(pos,act_page);
  FollowCursor();
  DelayedRewritePage();
  WriteStatus("Cursor set.");
}

static      
void myMouseSelEnd(Widget w, XEvent *e, String *s, Cardinal *n)
/* was XMotionEvent */
{
  Pos pos;
  XMotionEvent *ev=(XMotionEvent*)e;
#ifdef DEBUG
  fprintf(debugfile,"\nmyMouseSelEnd %d %d\n",ev->x,ev->y);
  fflush(debugfile);
#endif
  ClearStatus();

  pos.x=ev->x/scaleX; pos.y=ev->y/scaleX;
/*  fprintf(stderr," Mot: %f, %f\n", pos.x,pos.y);*/
  *act_tpos=Pos2Tpos(pos,act_page);
  if(bookmark[1].linep==NULL)
    SelBegin();
  SelEnd();
}

static
void myKeyPress(Widget w, XEvent *e, String *s, Cardinal *n)
/* was XKeyEvent */
{
  KeySym keysym;
  Modifiers modd;
  XKeyEvent *event;

  event=(XKeyEvent*)e;
/*  static Flag f;*/
  CursorUnblink();
  XtTranslateKeycode(display,event->keycode,event->state,&modd,&keysym);
  if(keysym<0xff)
    {
#ifdef DEBUG
      union { int k; char c; } deb;
      deb.k=keysym;
      fprintf(debugfile,"%c",/*keysym&0xff*/deb.c);
      fflush(debugfile);
#endif
      ClearStatus();

      /* if(event->state&ShiftMask)  keysym=keysym^('a'^'A'); */
      InsertChar(*act_tpos,keysym);
      if(((keysym==' ')||(keysym=='-'))&&(act_tpos->linep->line->newline==0)
	 &&(act_tpos->linep->line->previous!=NULL))
	SetEval(act_tpos->linep->line->previous);
      DelayedRewritePage();
    }
  else switch(keysym)
    {
    case XK_Escape:
      PrintAsciiPage(act_page);
      break;
    case XK_BackSpace:
      myBackSpace(w,e,s,n);
      break;
    case XK_Tab:
      myTab(w,e,s,n);
      break;
    case XK_Home:
/*      InsertString(*act_tpos,"Ich bin's");*/
/*      DebugLoad();*/
/*      PrintAsciiPage(act_page);*/
      myHome(w,e,s,n);
/*      myTab();*/
      break;
    case XK_End:
/*      PrintAsciiPage(act_page);*/
/*      PrintoutPage(act_page,stderr);*/
/*      PSWriteText(act_text,stderr);*/
      myEnd(w,e,s,n);
      break;
    case XK_Return:
      myReturn(w,e,s,n);
      break;
    case XK_Right:
      myRight(w,e,s,n);
      break;
    case XK_Left:
      myLeft(w,e,s,n);
      break;
    case XK_Up:
      myUp(w,e,s,n);
      break;
    case XK_Down:
      myDown(w,e,s,n);
      break;
    case XK_Prior:
      myPageUp(w,e,s,n);
      break;
    case XK_Next:
      myPageDown(w,e,s,n);
      break;
/*    default:
      noop();*/
    }
  FollowCursor();
}

#if 0
static
void myRewritePage(Widget w, XEvent *e, String *s, Cardinal *n)
{
  RewritePage(act_page);
}
#endif

#if 0
static
void mySave(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  doSave();
}
#endif

static
void myInitText(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  InitText();
}

static
void myUnselect(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  Unselect();
}

static
void mySelBegin(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  SelBegin();
  DelayedRewritePage();
}

static
void mySelEnd(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  SelEnd();
  DelayedRewritePage();
}

#if 0
static
void myDebugScroll(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  DebugScroll();
}
#endif

static
void myPrintActPage(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  PrintActPage();
}

static
void mySave(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  doSave();
}

static
void myOverwrite(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  doOverwrite(w,0,0); /* NULL-Pointer !!! */
}

static
void myPopdown(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  Popdown(w,0,0); /* NULL-Pointer !!! */
}

static
void myPopdownFontsel(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  PopdownFontsel(w,0,0); /* NULL-Pointer */
}

static
void myFontsel(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  doFontsel(w,0,0); /* NULL-Pointer !!! */
}

static
void myPopupLoad(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  PopupLoad();
}

static
void myPopupWriteTo(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  PopupWriteTo();
}

static
void myPopupPrint(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  PopupPrint();
}

static
void myPopupFontsel(Widget w, XEvent *e, String *s, Cardinal *n)
{
  ClearStatus();
  PopupFontsel();
}
