/* Debugging Routines */
#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "myword.h"
#include "xactions.h"
#include "xinternal.h"
#include "loadsave.h"
#define DEBUG_C
#include "debug.h"

FILE *debugfile;

void PrintAsciiLine(Line *l)
{
  LineP *lp;
  int i;
  if(l!=NULL)
    {
      if(l->eval>0) putchar('@');
      lp=l->first;
      while(lp!=NULL)
	{
	  for(i=0;i<=lp->clength;i++)
	    {
	      if((act_tpos->linep==lp)&&(act_tpos->index==i))
		putchar('\\');
	      putchar(lp->c[i]);
	    }
	  putchar('`');
	  lp=lp->next;
	}
    }
  putchar('\n');
}

void PrintAsciiPage(Page *p)
{
  Line *l=p->first;
  putchar('\n');
  while((l!=NULL)&&(l->page==p))
    {
      PrintAsciiLine(l);
      l=l->next;
    }
}

void CheckLine(Line *l)
{
  LineP *lp;
  if(l->first->previous!=NULL)
    {
      fprintf(stderr," First not first: ");
      PrintAsciiLine(l);
    }
  for(lp=l->first;lp->next!=NULL;lp=lp->next)
    if(lp->next->previous!=lp)
      {
	fprintf(stderr," Next not next: ");
	PrintAsciiLine(l);
      }
}

void CheckPage(Page *p)
{
  Line *l;
  for(l=p->first;(l->next!=NULL)&&(l->page==p);l=l->next)
    {
      if(l->next->previous!=l)
	{
	  fprintf(stderr," Line is not prec: ");
	  PrintAsciiLine(l);
	}
      CheckLine(l);
    }
}

void DebugLoad(void)
{
/*  FILE *file;*/
/*  Text *t;*/

/*  file=fopen("debug.doc","rb");
  act_text=ReadText(file);
  fclose(file);
  act_page=act_text->first;
  act_tpos->index=0;
  act_tpos->linep=act_page->first->first;*/
  LoadText("debug.doc");
  RewriteWholePage(act_page);
}

typedef union { int i; Page *p; } PagePoint;
typedef union { int i; Line *l; } LinePoint;
typedef union { int i; LineP *lp; } LinePPoint;

static int ptoi(void *pointer)
{
  union { int i; void *p; } t;
  t.p=pointer;
  return(t.i);
}

void TextTree(Text *t)
{
  Page *p=t->first;
  Line *l=p->first;

  for(p=t->first;p!=NULL;p=p->next)
    printf("Page: %10d, Next: %10d, Previous %10d, First %10d\n",
	   ptoi((void*)p),ptoi((void*)p->next),
	   ptoi((void*)p->previous),ptoi((void*)p->first));
  for(l=t->first->first;l!=NULL;l=l->next)
    printf("Line: %10d, Next: %10d, Previous %10d, Page %10d\n",
	   ptoi((void*)l),ptoi((void*)l->next),
	   ptoi((void*)l->previous),ptoi((void*)l->page));
}
  
void DebugInit()
{
#ifdef DEBUG
  debugfile=fopen("debuggin","wb");
  if(debugfile==NULL)
    debugfile=stderr;
#endif
}

void DebugTini()
{
#ifdef DEBUG
  fclose(debugfile);
#endif 
}

void PrintActPage(void)
{
  PrintAsciiPage(act_page);
}

void LineTree(Line *l)
{
  LineP *lp;
  for(lp=l->first;lp!=NULL;lp=lp->next)
    fprintf(stderr,"LineP: %10d, Next: %10d, Previous %10d, Line %10d\n",
	    ptoi((void*)lp),ptoi((void*)lp->next),
	    ptoi((void*)lp->previous),ptoi((void*)lp->line));
}
