/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include  <math.h>

/* Jump to a line selected by the user */
void
gui_jumpCB(w,client_data,event)
Widget	w;
caddr_t	client_data;
XEvent *event;
{
	char 	*text;
	char	*temp;
	int 	linenum;
	int 	linecount;
	int 	charcount,charcount2;
	int	textlength;
	
	Dimension height;
	int rows;
	
	/* Initialise Variables */
	linecount=1;
	charcount=-1;
	/* Get data from jump_to text and text canvas */
	text=XmTextGetString(text_canvas);
	temp=XmTextGetString(jumpMenuText);
	linenum=atoi(temp);
	if (temp!=NULL)
		XtFree(temp);
	textlength=strlen(text);
	XtVaGetValues(text_canvas,XmNheight,&height,NULL);
	rows=(int)((int)height/15);
	/* Nothing sophisticated, each '\n' represents a new line */
	while ((charcount<textlength)&&(linecount<linenum))
	{
		charcount++;
		if (text[charcount]=='\n')
			linecount++;
		if (linecount==linenum-(int)rows/2)
			charcount2=charcount+1;
	};
	charcount++;
	/* Check if line was found */
	if (linecount!=linenum)
	{
		/* Tell user number invalid */;
		set_title_message("sorry line number invalid");
	}
	else
	{
		/* Set cursor to beginning of line  */
		XmTextSetTopCharacter(text_canvas,(XmTextPosition)charcount2);
		XmTextSetInsertionPosition(text_canvas,(XmTextPosition)charcount);
		set_title_message("Ok jumping to line");
	};
	/* Free up text */
	if (text!=NULL)
		XtFree(text);		
}



void 
gui_searchReplaceCB(w,client_data,event)
Widget	w;
int	client_data;
XEvent *event;
{
	/* Decide what sort of search request occured */
	switch (client_data)
	{
		case SEARCH: /* Request to search for a word */
			time_cursor(toplevel);
			if (gui_searchCB()>0)
			{
				set_title_message("Found an instance");
				/* Now allow Replace to occur */
				XtSetSensitive(replaceMenuPB,True);
			}
			else  
				set_title_message("Sorry couldn't find the word");
			undo_time_cursor(toplevel);
		  	break;
		case REPLACE: /*88 Request to replace a word */
			/* FIRST TAKE A SNAPSHOT TO ALLOW FOR UNDO */
			snapshot();
			gui_replaceCB();
			XtSetSensitive(replaceMenuPB,False);
			break;
		case REPLACEALL: /* Request for replace all action */
			snapshot();
			LastOp=REPLACEALLOP;
			EditEvent=True;
			time_cursor(toplevel);
			gui_replaceAllCB();
			undo_time_cursor(toplevel);
			break;
	}			
}

/* Turn search within selction only either on or off */
void
searchSelectionOnlyToggleCB(w,client_data,call_data)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *call_data;
{
	Boolean set;
	Arg args[10];
	int n;

	n=0;
	XtSetArg(args[n],XmNset,&set);n++;
	XtGetValues(w,args,n);
	if (set)
		SelectedOnly=True;
	else
		SelectedOnly=False;
}


int
gui_searchCB()
{
	char *text=NULL;
	char *base=NULL;
	char *word=NULL;
	char *instanceofwordptr=NULL;
	int pos,wordpos,rows,offset,top,linecount,charcount;
	Dimension height;

	
	/* Get word to be searched for */
	 word=XmTextGetString(searchMenuText);
	/* Check the word isn't NULL */
	if (strcmp(word,"")!=0)
	{
		pos=XmTextGetInsertionPosition(text_canvas);
		base=text=XmTextGetString(text_canvas);
		text=text+pos;
		/*Search from cursor position down */
		instanceofwordptr=strstr(text,word);
		if (instanceofwordptr==NULL)
		{
			/* No luck , ok search from beggining */	
			instanceofwordptr=strstr(base,word);
			if (instanceofwordptr==NULL)
			{
				/* Ok give up */
				free(base);
				free(word);
				return 0;
			}
		}
		/* Ok there is an instance so now locate it in the canvas */
		wordpos=(instanceofwordptr-base);
		/* Now motif doesn't offer any thing to return the height 
		in columns of the text canvas so I'm going to have to guestimate*/
		XtVaGetValues(text_canvas,XmNheight,&height,NULL);
		rows=(int)((int)height/15);/* The 15 here is a guess */
		/*Now search backwards rows/2 lines */
		charcount=wordpos;
		linecount=(int)rows/2;
		while ((linecount>0)&&(charcount>1))
		{
			charcount--;
			if (base[charcount]=='\n')
				linecount--;
		};
		XmTextSetTopCharacter(text_canvas,charcount);
		/* Now set insertion position to beggining of word */
		XmTextSetInsertionPosition(text_canvas,(XmTextPosition)(wordpos+strlen(word)));
		/* Highlight the word */
		XmTextSetSelection(text_canvas,(XmTextPosition)wordpos,(XmTextPosition)wordpos+strlen(word),CurrentTime);
		if (word!=NULL)
			free(word);
		if (base!=NULL)
			free(base);
		return 1;
	}
	else
		return 0;
}

void
gui_replaceCB()
{
	char *word;
	char *replacement;
	char *temp;
	XmTextPosition pos,firstpos;

	/* Get data from widgets */
	word=XmTextGetString(searchMenuText);
	replacement=XmTextGetString(replaceMenuText);
	temp= XmTextGetSelection(text_canvas);
	if (strcmp(temp,word)==0)
	{
		XmTextGetSelectionPosition(text_canvas,&firstpos,&pos); 
		/* Now perform replacement */
		XmTextReplace(text_canvas,firstpos,pos,replacement);
		/* Now place the cursor at the end of the word */
		XmTextSetInsertionPosition(text_canvas,(XmTextPosition)(firstpos+strlen(replacement)));
		/* Now turn Replace button off again */
		XtSetSensitive(replaceMenuPB,False);
	}
	else
		set_title_message("Sorry can't replace, ...you lost the selection");
	if (word!=NULL)		
		free(word);
	if (replacement!=NULL)	
		free(replacement);
	if (temp!=NULL)		
		free(temp);
}


void
gui_replaceAllCB()
{
	char *word;
	char *replacement;
	char *temp;
	char *temp1;
	char *final;
	char *instanceptr;
	XmTextPosition left,right;	

	/* Get data from widgets */
	word=XmTextGetString(searchMenuText);
	replacement=XmTextGetString(replaceMenuText);
	if (!*word)
	{
		set_title_message("Sorry No search text specified");
	}
	else
	{
		if (!*replacement)
		{
			set_title_message("Sorry No replace text specified");
		}
		else
		{
			if (strcmp(word,replacement)!=0)
			{
				if (SelectedOnly)
				{
					if (XmTextGetSelection(text_canvas)!=NULL)	
					{
						set_title_message("Ok replacing instances within selection");
						XmTextGetSelectionPosition(text_canvas,&left,&right);
						final=(char*) malloc((right-left)*strlen(replacement));		
						strcpy(final,"");
						temp=XmTextGetSelection(text_canvas);
						temp1=temp;
						/* Now do search and replace on string */
						instanceptr=strstr(temp1,word);
						if (instanceptr!=NULL)
						{
							while (instanceptr!=NULL)
							{
								strncat(final,temp1,instanceptr-temp1);
								strcat(final,replacement);	
								temp1=instanceptr+strlen(word);
								instanceptr=strstr(temp1,word);
							}
							sprintf(final,"%s%s",final,temp1);
							XmTextReplace(text_canvas,left,right,final);
							XmTextSetSelection(text_canvas,left,left+strlen(final),CurrentTime);
							set_title_message("Done replacing instances within selection");
						}
						else
						{
							set_title_message("Sorry no instances found");
						}
						free(final);
						if (temp!=NULL)
							free(temp);	
					}	
					else
					{
						set_title_message("Sorry no selection to edit");
					}
				}	
				else
				{
					set_title_message("Ok replacing instances");
					final=(char*) malloc(XmTextGetLastPosition(text_canvas)*strlen(replacement));
					strcpy(final,"");
					temp=XmTextGetString(text_canvas);
					temp1=temp;
					instanceptr=strstr(temp1,word);
					if (instanceptr!=NULL)
					{
						while (instanceptr!=NULL)
						{
							strncat(final,temp1,instanceptr-temp1);
							strcat(final,replacement);	
							temp1=instanceptr+strlen(word);
							instanceptr=strstr(temp1,word);
						}
						sprintf(final,"%s%s",final,temp1);
						XmTextSetString(text_canvas,final);
						set_title_message("Done replacing instances");
					}
					else
					{
						set_title_message("Sorry no instances found");
					}
					free(final);
					if (temp!=NULL)
						free(temp);
				}	
			}
			else
			{
				set_title_message("They're the same why bother");
			}
		}
	}
	if (word!=NULL)
		XtFree(word);
}

void
gui_matchCB(w,client_data,call_data)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *call_data;
{
	char*	parentheses;
	char*	temp;
	int	matchChar;
	int	up,down,index;
	XmTextPosition left,right;	
	
	parentheses=XmTextGetSelection(text_canvas);
	temp=XmTextGetString(text_canvas);
	XmTextGetSelectionPosition(text_canvas,&left,&right);
	
	if (parentheses!=NULL)
	if (strlen(parentheses)==1)	
	{
		set_title_message("Ok matching");
		if (parentheses[0]=='(')	matchChar=')';
		if (parentheses[0]=='{')	matchChar='}';
		if (parentheses[0]=='<')	matchChar='>';
		if (parentheses[0]==')')	matchChar='(';
		if (parentheses[0]=='}')	matchChar='{';
		if (parentheses[0]=='>')	matchChar='<';
		
		if ((matchChar==')')||(matchChar=='}')||(matchChar=='>'))
		{
			/* Search forwards */
			index=(int)left+1;
			up=1;
			down=0;
			while(up!=down&&(index<=strlen(temp)-1))
			{
				if(temp[index]==parentheses[0])
					up++;
				if(temp[index]==matchChar)
					down++;
				index++;
			}
			if (up==down)
				XmTextSetSelection(text_canvas,(XmTextPosition)left,(XmTextPosition)index,CurrentTime);
			else
				set_title_message("Sorry! No match found");
		}
		else 
		{
			if ((matchChar=='(')||(matchChar=='{')||(matchChar=='<'))
			{
				index=(int)left-1;
				up=1;
				down=0;
				while(up!=down&&(index>=0))
				{
					if(temp[index]==parentheses[0])
						up++;
					if(temp[index]==matchChar)
						down++;
					index--;
				}
				if (up==down)
					XmTextSetSelection(text_canvas,(XmTextPosition)index+1,(XmTextPosition)left+1,CurrentTime);
				else
					set_title_message("Sorry! No match found");
			}
			else
				set_title_message("Sorry! No match found");
		}
	}
	else
		set_title_message("Sorry! The selection is ambigous");
	if (temp!=NULL)
		XtFree(temp);
	if (parentheses!=NULL)
		XtFree(parentheses);
}
