/*    Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include  <math.h>

/* Main help facility */
void
gui_helpCB(w,client_data,event)
Widget	w;
int	client_data;
XEvent *event;
{
	XmString	item;
	set_title_message("Ok, running Help");
	/* Decide what called help */
	switch (client_data)
	{
		case HELPCALL:
				XtManageChild(helpPopUp);
				break;
		case HELPCANCEL: 
				XtUnmanageChild(helpPopUp);
				set_title_message("");
				break;
		case HELPHELP:	/* Help called from help popUp */
				item=XmStringCreateLtoR("helpOnHelp",CHARSET);
				XmListSelectItem(helpLI,item,True);
				break;
		case HELPSETUP: /* Help called from setup popUp */
				XtManageChild(helpPopUp);
				item=XmStringCreateLtoR("SetUp",CHARSET);
				XmListSelectItem(helpLI,item,True);
				break;
		case HELPABOUT: /* Help called from setup popUp */
				gui_info(" Gloe - Version 0.5 Rev 22/12/94\n by Franz Gerschwiler (goblin@dcs.qmw.ac.uk)\n Copyright Queen Mary and Westfield College, University of London ");
				break;
		case HELPBUGS: /* Help called from setup popUp */
				gui_info(" Gloe is still young and may well have bugs here and there.\n Bearing this in mind, it is probably advisable to use the automatic\n save facility to minimise the risk of losing work.\n\n If you should come across a bug please email goblin@dcs.qmw.ac.uk\n with as complete a description of the problem as possible.");
				break;
		case HELPDEVEL: /* Help called from setup popUp */
				gui_info(" Future enhancments include:\n\\n Menu driven file recovery.\n Multiple windows \n Font selection.\n\n If you have any suggestions or comments please email goblin@dcs.qmw.ac.uk.");
				break;
		default:
			break;
	}			
}

/* Deals with user selecting a help topic */
void	
gui_helpSelectCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	XmString	item;
	XmListCallbackStruct	*cbd = (XmListCallbackStruct *)call_data;
	char *curr_item;

	XmStringGetLtoR(cbd->item,XmFONTLIST_DEFAULT_TAG,&curr_item);
	
	loadHelpFile(curr_item);
};


/* Read in help index to create list of topics */
void
gui_createHelpList()
{
	XmString	item;
	char 		num_str[1000];
	struct stat	stat_val;
	char 		*filecontents;
	FILE    	*fpointer;
	int		f_length;
	char 		*idstring;
	char		*filename;
	int 		count;

	
	filename=(char*)malloc(strlen(HELPPATH)+16);
	sprintf(filename,"%s/.gloeHelpIndex",HELPPATH);
	if (stat(filename,&stat_val) == 0)
	{
		f_length = stat_val.st_size;
		fpointer=fopen(filename,"r");
		if (fpointer!=NULL)
		{
		  	filecontents = (char*) malloc((unsigned)(f_length+1));
			*filecontents = '\0';
			fread(filecontents,sizeof(char),f_length,fpointer);
		   	filecontents[f_length]='\0';
	        	fclose(fpointer);
		}
		if (filecontents!=NULL)
		{
			count=1;
			XmListDeselectAllItems(helpLI);
			idstring=strtok(filecontents,SEPCHARS);
			while (idstring!=NULL)
			{
				item=XmStringCreateLtoR(idstring,CHARSET);
				XmListAddItemUnselected(helpLI,item,count);
				idstring=strtok(NULL,SEPCHARS);
				count++;
			};
			XmListSelectPos(helpLI,1,True);
			free(filecontents);
		}
	}
	else gui_error("Sorry unable to load help data. Please contact sys admin.");
	if (filename!=NULL)
		free(filename);
}


/* Read in a help file */
Boolean
loadHelpFile(filename)
char *filename;
{
	struct stat	stat_val;
	char 		*filecontents;
	FILE    	*fpointer;
	int		f_length;
	char 		*file=(char *) malloc(1000);	
	
	sprintf(file,"%s/%s",HELPPATH,filename);
	if (stat(file,&stat_val) == 0)
	{
		f_length = stat_val.st_size;
		fpointer=fopen(file,"r");
		if (fpointer!=NULL)
		{
		  	filecontents = (char*) malloc((unsigned)(f_length+1));
			*filecontents = '\0';
			fread(filecontents,sizeof(char),f_length,fpointer);
		   	filecontents[f_length]='\0';
	        	fclose(fpointer);
			XmTextSetString(helpText,filecontents);
			XtFree(file);
			return True;
		}
		else 
		{
			XtFree(file);
			return False;
		}
	}
	else 
	{
		XtFree(file);
		return False;	return False;
	}
}

void
gui_contextSensitiveHelpCB(w,client_data,event)
int	client_data;
XEvent 	*event;
{
	XmString	item;
	set_title_message("");
	/* Decide what called help */
	switch (client_data)
	{
		case SAVE:
				set_title_message("Save the active file under current name");
				break;
		case SAVEAS: 
				set_title_message("Save the active file under a new name");
				break;
		case SAVESELECTION:	
				set_title_message("Save selected text");
				break;
		case OPEN: 
				set_title_message("Open a file");
				break;
		case INSERT: 
				set_title_message("Insert a text file in the current text");
				break;
		case NEW: 
				set_title_message("Obtain a blank document");
				break;
		case PRINT: 
				set_title_message("Print the active document");
				break;
		case PRINTSELECTION:
				set_title_message("Print selected text");
				break;
		case QUIT: 
				set_title_message("Exit gloe");
				break;
		case COPY: 
				set_title_message("Copy selected text to clipboard");
				break;
		case CUT: 
				set_title_message("Remove selected text and copy to clipboard");
				break;
		case PASTE: 
				set_title_message("Insert text from clipboard");
				break;
		case UNDO: 
				set_title_message("Undo last edit");
				break;
		case SEARCH: 
				set_title_message("Search for text string in document");
				break;
		case REPLACE: 
				set_title_message("Replace text string found by search");
				break;
		case REPLACEALL: 
				set_title_message("Replace all instances of search string with replace string");
				break;
		case SETUP: 
				set_title_message("Invoke set up dialog");
				break;
		case HELPB: 
				set_title_message("Invoke help dialog");
				break;
		case JUMP: 
				set_title_message("Jump to line number");
				break;
		case JUMPTEXT: 
				set_title_message("Enter line to jump to here");
				break;
		case SEARCHTEXT: 
				set_title_message("Enter search string here");
				break;
		case REPLACETEXT: 
				set_title_message("Enter replace string here");
				break;
		case MATCH: 
				set_title_message("Match parentheses characters");
				break;
		case SELECTIONONLY: 
				set_title_message("Set search and replace with selection only");
				break;
		default:
			break;
	}			
}

void
gui_undoContextSensitiveHelpCB(w,client_data,event)
int	client_data;
XEvent 	*event;
{
	XmString	item;
	set_title_message("");
	/* Decide what called help */
	switch (client_data)
	{
		case SAVE:
				set_title_message("Gloe");
				break;
		case SAVEAS: 
				set_title_message("Gloe");
				break;
		case SAVESELECTION:	
				set_title_message("Gloe");
				break;
		case OPEN: 
				set_title_message("Gloe");
				break;
		case INSERT: 
				set_title_message("Gloe");
				break;
		case NEW: 
				set_title_message("Gloe");
				break;
		case PRINT: 
				set_title_message("Gloe");
				break;
		case PRINTSELECTION:
				set_title_message("Gloe");
				break;
		case QUIT: 
				set_title_message("Gloe");
				break;
		case COPY: 
				set_title_message("Gloe");
				break;
		case CUT: 
				set_title_message("Gloe");
				break;
		case PASTE: 
				set_title_message("Gloe");
				break;
		case UNDO: 
				set_title_message("Gloe");
				break;
		case SEARCH: 
				set_title_message("Gloe");
				break;
		case REPLACE: 
				set_title_message("Gloe");
				break;
		case REPLACEALL: 
				set_title_message("Gloe");
				break;
		case SETUP: 
				set_title_message("Gloe");
				break;
		case HELPB: 
				set_title_message("Gloe");
				break;
		case JUMP: 
				set_title_message("Gloe");
				break;
		case JUMPTEXT: 
				set_title_message("Gloe");
				break;
		case SEARCHTEXT: 
				set_title_message("Gloe");
				break;
		case REPLACETEXT: 
				set_title_message("Gloe");
				break;
		case MATCH: 
				set_title_message("Gloe");
				break;
		case SELECTIONONLY: 
				set_title_message("Gloe");
				break;

		default:
			break;
	}			
}
