/*   Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/

#include <string.h>
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"

/**************************************/
/*        VARIABLE DECLARATIONS       */
/**************************************/
Widget	info_DI;
Widget  error_DI;
int	button_pressed;
char    *prompt_str;

/**************************************/
/*       PROCEDURE DECLARATIONS       */
/**************************************/

char *
gui_XmStringToText(item)
XmString	item;
{
	char	*text;

	text = (char *)malloc(255);
	text[0] = '\0';
	(void)XmStringGetLtoR(item,XmSTRING_DEFAULT_CHARSET,&text);

	return text;
}

void
gui_info(message)
char	*message;
{
	XtVaSetValues(info_DI,
		XmNmessageString,XmStringCreateLtoR(message,CHARSET),
		NULL);
	XBell(XtDisplay(info_DI),BELL_VOL);
	XtManageChild(info_DI);
}

int
gui_error(message)
char	*message;
{
	XtAppContext	app_context;
	XEvent		app_event;

	XtVaSetValues(error_DI,
		XmNmessageString,XmStringCreateLtoR(message,CHARSET),
		NULL);
	XBell(XtDisplay(error_DI),BELL_VOL);
	XtManageChild(error_DI);

	app_context = XtWidgetToApplicationContext(error_DI);
	button_pressed = NOTHING;
	while (button_pressed == NOTHING)
	{
		XtAppNextEvent(app_context,&app_event);
		(void) XtDispatchEvent(&app_event);
	}
	XtUnmanageChild(error_DI);
	return button_pressed;
}		

char*
gui_prompt(message,value)
char	*message,*value;
{
	XtAppContext	app_context;
	XEvent		app_event;

	XtVaSetValues(prompt_DI,
		XmNselectionLabelString,XmStringCreateLtoR(message,CHARSET),
		XmNtextString,XmStringCreateLtoR(value,CHARSET),
		NULL);
	XBell(XtDisplay(prompt_DI),BELL_VOL);
	XtManageChild(prompt_DI);

	app_context = XtWidgetToApplicationContext(prompt_DI);
	button_pressed = NOTHING;
	while (button_pressed == NOTHING)
	{
		XtAppNextEvent(app_context,&app_event);
		(void) XtDispatchEvent(&app_event);
	}
	if (button_pressed==YES)
	{
		return (prompt_str);
	}
	else
		return NULL;
}

void
gui_errorCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	button_pressed = (int)client_data;
}

void
gui_promptCB(w,client_data,call_data)
Widget	w;
caddr_t	client_data,call_data;
{
	XmSelectionBoxCallbackStruct
		*cb = (XmSelectionBoxCallbackStruct *)call_data;

	button_pressed = (int)client_data;
	if (prompt_str != NULL)
		XtFree(prompt_str);

	prompt_str = gui_XmStringToText(cb->value);
}


void
gui_queryCB(w,client_data)
Widget	w;
caddr_t	client_data;
{
	button_pressed = (int)client_data;
}

char
gui_query(message)
char	*message;
{
	XtAppContext	app_context;
	XEvent		app_event;

	XtVaSetValues(query_DI,
		XmNmessageString,XmStringCreateLtoR(message,CHARSET),
		NULL);
	XBell(XtDisplay(query_DI),BELL_VOL);
	XtManageChild(query_DI);

	app_context = XtWidgetToApplicationContext(query_DI);
	button_pressed = NOTHING;
	while (button_pressed == NOTHING)
	{
		XtAppNextEvent(app_context,&app_event);
		(void) XtDispatchEvent(&app_event);
	}
	return button_pressed;
}

void
time_cursor(w)
Widget w;
{
	Cursor c1;
	
	c1= XCreateFontCursor(XtDisplay(w),XC_watch);
	XDefineCursor(XtDisplay(w),XtWindow(w),c1);
	XFlush(XtDisplay(w));
}

void undo_time_cursor(w)
Widget w;
{
	XUndefineCursor(XtDisplay(w),XtWindow(w));
	XFlush(XtDisplay(toplevel));
	current_cursor(w);
}

void
default_cursor(w)
Widget w;
{
	Cursor c1;
	
	CURRENT_CURSOR=DEFAULT_CURSOR;
	c1= XCreateFontCursor(XtDisplay(w),DEFAULT_CURSOR);
	XDefineCursor(XtDisplay(toplevel),XtWindow(w),c1);
	XFlush(XtDisplay(w));
}

void
current_cursor(w)
Widget w;
{
	Cursor c1;
	
	c1= XCreateFontCursor(XtDisplay(w),CURRENT_CURSOR);
	XDefineCursor(XtDisplay(w),XtWindow(w),c1);
	XFlush(XtDisplay(w));
}

void
gui_createIcon(toplevel)
Widget	toplevel;
{
	Pixmap p;
	Arg arg[10];
	int ac;
	
	p=XCreateBitmapFromData(XtDisplay(toplevel),
		RootWindowOfScreen(XtScreen(toplevel)),
		GloePM,GloePM_height,GloePM_width);
	ac=0;
	XtSetArg(arg[ac],XmNiconPixmap,p);ac++;
	XtSetArg(arg[ac],XmNiconName, "Gloe"); ac++;
	XtSetValues(toplevel,arg,ac);
}

/* Change the name of the icon */
void
set_icon_name(message)
char *message;
{
	int 	n;
	Arg 	args[10];

	n=0;
	XtSetArg(args[n],XmNiconName,message); n++;
	XtSetValues(toplevel,args,n);
}

/* find the line number according to the position in the text */
int
lineNumber(position)
int position;
{
	char 	*text;
	int 	linenum;
	int 	linecount;
	int 	charcount;

	/* Initialise Variables */
	linecount=1;
	charcount=-1;
	/* Get data from jump_to text and text canvas */
	text=XmTextGetString(text_canvas);
	/* Nothing sophisticated, each '\n' represents a new line */
	while (charcount<position-1)
	{
		charcount++;
		if (text[charcount]=='\n')
			linecount++;
	};
	if (text!=NULL)
		XtFree(text);	
	return linecount;
}

/* Change the title message */
void
set_title_message(message)
char *message;
{
	int 	n;
	Arg 	args[10];
	char 	*titleMessage = (char*) malloc(200); 

	n=0;
	/* First put the file name in at the front */
	strcpy(titleMessage,"<");
	if (strrchr(FileName,'/'))
	{
		strcat(titleMessage,strrchr(FileName,'/')+1);
	}
	else
	{
		strcat(titleMessage,FileName);
	}
	strcat(titleMessage,">           ");
	/* Now add the message */
	strcat(titleMessage,message);

	XtSetArg(args[n],XmNtitle,titleMessage); n++;
	XtSetValues(toplevel,args,n);
	/* Make sure the users sees the message straight away */
	XFlush(XtDisplay(toplevel));
	XtFree(titleMessage);
} 

void
gui_createErrorDialog(toplevel)
Widget	toplevel;
{
	int	n=0;
	Arg	args[5];
	error_DI = XmCreateErrorDialog(toplevel,"Editor",args,n);
	XtAddCallback(error_DI,XmNokCallback,gui_errorCB,YES);
	XtAddCallback(error_DI,XmNhelpCallback,gui_errorCB,HELP);
	/* now turn off unwanted buttons */
	XtUnmanageChild(XmMessageBoxGetChild(error_DI,XmDIALOG_CANCEL_BUTTON));
}

void
gui_createInfoDialog(toplevel)
Widget	toplevel;
{
	int	n=0;
	Arg	args[5];
	info_DI = XmCreateInformationDialog(toplevel,"Editor",args,n);
	/* now turn off unwanted buttons */
	XtUnmanageChild(XmMessageBoxGetChild(info_DI,XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(info_DI,XmDIALOG_CANCEL_BUTTON));
}

void
gui_createPromptDialog(toplevel)
Widget	toplevel;
{
	int	n=0;
	Arg	args[5];

	prompt_DI = XmCreatePromptDialog(toplevel,"Excuse Me !",args,n);
	XtAddCallback(prompt_DI,XmNokCallback,gui_promptCB,YES);
	XtAddCallback(prompt_DI,XmNcancelCallback,gui_promptCB,NO);
	XtUnmanageChild(XmSelectionBoxGetChild(prompt_DI,XmDIALOG_HELP_BUTTON));
}

void
gui_createQueryDialog(toplevel)
Widget	toplevel;
{
	Arg	args[5];
	int	n;

	n = 0;
	XtSetArg(args[n],XmNdialogStyle,XmDIALOG_FULL_APPLICATION_MODAL); n++;
	query_DI = XmCreateQuestionDialog(toplevel,"queryDI",args,n);
	XtAddCallback(query_DI,XmNokCallback,gui_queryCB,YES);
	XtAddCallback(query_DI,XmNcancelCallback,gui_queryCB,NO);
	XtUnmanageChild(XmMessageBoxGetChild(query_DI,XmDIALOG_HELP_BUTTON));
}

void
gui_createFileDialog(toplevel)
Widget	toplevel;
{
	Arg	args[5];
	int	n=0;

	#if MOTIF1_1_LINUX
		fileD = XmCreatePromptDialog(toplevel,"Excuse Me !",args,n);
		XtAddCallback(fileD,XmNokCallback,gui_promptCB,YES);
		XtAddCallback(fileD,XmNcancelCallback,gui_promptCB,NO);
		XtUnmanageChild(XmSelectionBoxGetChild(fileD,XmDIALOG_HELP_BUTTON));
	#else
		XtSetArg(args[n],XmNwidth,400); n++;
		XtSetArg(args[n],XmNminWidth,400); n++;
		XtSetArg(args[n],XmNokLabelString,XmStringCreateLtoR("View",CHARSET)); n++;
		XtSetArg(args[n],XmNcancelLabelString,XmStringCreateLtoR("Dismiss",CHARSET)); n++;
		fileD = XmCreateFileSelectionDialog(toplevel,"fileD",args,n);
		XtAddCallback(fileD,XmNokCallback,gui_browseFileCB,NULL);
		XtAddCallback(fileD,XmNcancelCallback,gui_cancelBrowseCB,NULL);
		XtUnmanageChild(XmFileSelectionBoxGetChild(fileD,XmDIALOG_HELP_BUTTON));
	#endif
}

