/*   Copyright (C) 1994 Queen Mary and Westfield College, University of London

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    A copy of the GNU General Public License may be found in
    doc/COPYING in the source tree of this programm.

    This file was written by: Franz Gerschwiler.(goblin@dcs.qmw.ac.uk)


*/
#include "sys_consts.h"
#include "gui_externs.h"
#include "gui_extern_fns.h"
#include <Xm/Xm.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/**************************************/
/*      APPLICATION CLASS             */
/**************************************/
#define APPLICATION_CLASS "Gloe" 

/**************************************/
/*        VARIABLE DECLARATIONS       */
/**************************************/
XtAppContext 	app_context;

/**************************************/
/*       PROCEDURE DECLARATIONS       */
/**************************************/


void
main(argc, argv)
int	argc;
char	**argv;
{
	Display *display;
	Arg	args[10];
	int	n;
	char	*filename;
	char	*temp;
	char	*item=(char*) malloc(100);
	
	/* INITIALISE TOOLKIT AND APPLICATION CONTEXT */
	/**********************************************/
	XtToolkitInitialize ();
	app_context = XtCreateApplicationContext();

	/* OPEN AND CHECK DISPLAY FOR THE APPLICATION */
	/**********************************************/
	display = XtOpenDisplay(app_context,NULL,argv[0],APPLICATION_CLASS,
				NULL,0,&argc,argv);
	if (!display)
		XtError("Can't open display, exiting...");

	screen = DefaultScreen(display);

	/* INITIALISE VARIABLES */
	/************************/
	DEFAULT_CURSOR=XC_hand2;
	CURRENT_CURSOR=XC_hand2;
	
	AUTOSAVE=True;
	SelectedOnly = False;
	LastOp=NONE;
	OldCanvasPosition=0;
	FileName="Untitled.gloe\0";
  	DefaultPrinter=(char*) malloc (100);
  	defaultPrinter=(char*) malloc (100);
	RootDirectory=(char*) malloc (300);

	/* LOAD DEFAULTS */
	/*****************/
	if (!loadConfig())
	{
		setDefaults();
	}
	/* CREATE APPLICATION SHELL */
	/****************************/
	n = 0;
	XtSetArg(args[n],XmNminWidth,550); n++;
	XtSetArg(args[n],XmNminHeight,400); n++;
	XtSetArg(args[n],XmNwidth,600); n++;
	XtSetArg(args[n],XmNheight,600); n++;
	XtSetArg(args[n],XmNiconName,"Gloe"); n++;
	XtSetArg(args[n],XmNtitle,"Gloe"); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_GROW); n++;
	toplevel = XtAppCreateShell (argv[0],APPLICATION_CLASS,
		applicationShellWidgetClass,display,args,n);
	/* CREATE TOOL WIDGETS */
	/***********************/
	gui_createWidgets(display,toplevel);
	gui_createToolBar(toplevel);
	/* CREATE POPUP BOXES AND WIDGETS */
	/**********************************/
	gui_createInfoDialog(toplevel);	
	gui_createPromptDialog(toplevel);
	gui_createConfigPopUp(toplevel);
	gui_createQueryDialog(toplevel);
	gui_createErrorDialog(toplevel);
	gui_createFileDialog(toplevel);
	gui_createHelpPopUp(toplevel);
	gui_createIcon(toplevel);
	/* REALIZE WIDGETS */	
	/*******************/
	XtRealizeWidget(toplevel);
	
	/* INITIALISE INTERFACE */
	/************************/
	gui_createHelpList();
	sprintf(item,"%d",AutoSaveTime);
	XmTextSetString(autosavetimeText,item);
	

	/* LOAD FILE IF GIVEN */
	/**********************/
	if (argc >2)
	{
		/* See if the user is trying to recover from a crash */
		if (strcmp(argv[2],"recover")==0)
		{
			filename=(char*) malloc(strlen(getenv("HOME"))+strlen("/.gloeGuard/")+strlen(argv[1])+1);
			sprintf(filename,"%s/.gloeGuard/%s",getenv("HOME"),argv[1]);
			if (loadfile(filename))
			{
				/*Consider changing to direct assignment and then conditional freeing*/
				OldCanvasValue=XmTextGetString(text_canvas);
				set_title_message("Ok managed to load guard file");
			}	
			else
			{
				OldCanvasValue=NULL;
				EditEvent=False;
				XmTextSetString(text_canvas,OldCanvasValue);
				OldCanvasValue="Woops nothing to undo to : press undo again to undo this";
				if (gui_error("Sorry unable to recover")==HELP)
					gui_info("You may not have specified a valid file name\nOr you may not have had autosave turned on");
			}
			XtFree(filename);
		}
		else
		{
			if (loadfile(argv[1]))
			{
				OldCanvasValue=(char*)XmTextGetString(text_canvas);
			}
			else
			{
				EditEvent=False;
				XmTextSetString(text_canvas,"");
				OldCanvasValue=(char*) malloc(strlen("Woops nothing to undo to : press undo again to undo this")+1);
				sprintf(OldCanvasValue,"Woops nothing to undo to : press undo again to undo this");
			}
		}
	}
	else
	{
		if (argc >1)
		{
			if (loadfile(argv[1]))
			{
				OldCanvasValue=(char*)XmTextGetString(text_canvas);
			}
			else
			{
				EditEvent=False;
				XmTextSetString(text_canvas,"");
				OldCanvasValue=(char*) malloc(strlen("Woops nothing to undo to : press undo again to undo this")+1);
				sprintf(OldCanvasValue,"Woops nothing to undo to : press undo again to undo this");
			}
		}
		else
		{
			EditEvent=False;
			XmTextSetString(text_canvas,"");
			OldCanvasValue=(char*) malloc(strlen("Woops nothing to undo to : press undo again to undo this")+1);
			sprintf(OldCanvasValue,"Woops nothing to undo to : press undo again to undo this");
		}
	}
	/*Check to see if Autosave directory exists */
	/* Theres probably a better way of doing this*/
	/* Can someone tell me if there is */
	filename=(char*) malloc(strlen(getenv("HOME"))+strlen("/.gloeGuard/.testfile")+1);
	sprintf(filename,"%s/.gloeGuard/.testfile",getenv("HOME"));
	if (!fopen(filename,"r"))
	{
		fprintf(stderr,"Just setting up a couple of things\n");
		fprintf(stderr,"Ignore error message regarding 'touch:' if it occurs\n");
		temp=(char*) malloc(strlen("touch ")+strlen(filename)+1);
		sprintf(temp,"touch %s",filename);
		system(temp);
		if (!fopen(filename,"r"))
		{
			temp=(char*)(realloc(temp,(strlen("mkdir ")+strlen(getenv("HOME"))+strlen("/.gloeGuard")+1)));
			sprintf(temp,"mkdir %s/.gloeGuard",getenv("HOME"));
			system(temp);
			temp=(char*)(realloc(temp,strlen("touch ")+strlen(getenv("HOME"))+strlen("/.gloeGuard/.testfile")+1));
			sprintf(temp,"touch %s/.gloeGuard/.testfile",getenv("HOME"));
			system(temp);
			if (!fopen(filename,"r"))
			{
				gui_error("Unable to initialise autosave directory/n Autosave facility not available");
				AUTOSAVE=False;
			}	
		}
		XtFree(temp);
	}
	TextChanged=False;
	default_cursor(toplevel);

	/*MAIN EVENT LOOP*/
	/*****************/
	gui_mainLoop();
}

void
gui_mainLoop()
{
	XEvent	event;
	int	result;
	time_t	lasttime,timenow,timeptr,eyesafetime;
	char *filename=(char*) malloc(100);
	Boolean temp;
	lasttime=time(&timeptr);
	eyesafetime=time(&timeptr);
	timenow=time(&timeptr);
	/* ENTER MAIN EVENT LOOP FOR THE APPLICATION */
	/*********************************************/
	while (True)
	{
		if (AutoSave&&AUTOSAVE)
		{
			while(XtAppPending(app_context)==0)
			{
				timenow=time(&timeptr);
				if ((double)(timenow-lasttime)>(double)AutoSaveTime)
				{	
					time_cursor(toplevel);
					set_title_message("Please wait: Autosaving");
					if (strrchr(FileName,'/'))
					{
						filename=(char*) realloc(filename,strlen(getenv("HOME"))+strlen("/.gloeGuard/")+strlen(strrchr(FileName,'/'))+1);	
						sprintf(filename,"%s/.gloeGuard/%s",getenv("HOME"),strrchr(FileName,'/'));
					}
					else
					{
						filename=(char*) realloc(filename,strlen(getenv("HOME"))+strlen("/.gloeGuard/")+strlen(FileName)+1);	
						sprintf(filename,"%s/.gloeGuard/%s",getenv("HOME"),FileName);
					}
					temp=AutoBackup;
					AutoBackup=False;
					if (!gui_saveFile(filename))
						gui_error("Sorry unable to perform autosave");
					AutoBackup=temp;
					lasttime=time(&timeptr);
					timenow=time(&timeptr);
					set_title_message(" ");
					undo_time_cursor(toplevel);
				}
				if ((double)(timenow-eyesafetime)>(double)EYESAFETIME)
				{	
					eyesafetime=time(&timeptr);
					timenow=time(&timeptr);
					gui_info(" You appear to have been working constantly for a long period\n You are advised to take a short break to avoid eye strain");
				}
			}
		}
		else
		{
			while(XtAppPending(app_context)==0)
			{
				timenow=time(&timeptr);
				if ((double)(timenow-eyesafetime)>(double)EYESAFETIME)
				{	
					eyesafetime=time(&timeptr);
					timenow=time(&timeptr);
					gui_info(" You appear to have been working constantly for a long period\n You are advised to take a short break to avoid eye strain");
				}
			}
		}
		XtAppNextEvent(app_context,&event);
		result = XtDispatchEvent(&event);
	}
}
