/*
	Copyright (c) Frank Klemm 1992. All Rights reserved.
	Frank.Klemm@HpUx.Rz.Uni-Jena.De
 * Frank Klemm DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL HARRY LANGENBACHER BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING 
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


	Ported to linux 5 Feb 93 
	  Ray Balister - balister@cebaf.gov
 * Ray Balister DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL HARRY LANGENBACHER BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING 
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

	Ported to NetBSD-0.9 on 29 Oct 93
	  also gathered into one file.
	  Daisuke Yokota - yokota@tom.comm.waseda.ac.jp
 * Daisuke Yokota DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL HARRY LANGENBACHER BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING 
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

hacked by harry march '94 - no longer good for NetBSD ?
* HARRY LANGENBACHER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL HARRY LANGENBACHER BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING 
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, 
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	"ICD2061A.h"
#define TRUE      1
#define FALSE     0

/**************************************************************************/
/* perm_ports (for Linux) */

/*
** Routine to set the permissions of i/o
** ports used for clock manipulation.  May not
** be clean, but it works.  --  RLB
*/

void perm_ports(int perm)
 {
  ioperm(0x3C2, 1, perm);
  /*ioperm(0x3C4, 1, perm);*/
  /*ioperm(0x3C5, 1, perm);*/
  ioperm(0x3CC, 1, perm);
 }

int main(int argc, char **argv)
 {
  int Hertz , ActualHertz , magic_number ;
  int icdchipreg = 0 ; /* could be 0 1 or 2 */
  float mhz = 0. ;

  if ( argc == 1 )
   {
    fprintf ( stderr , 
         "usage: %s Pixel_clock_in_MHz [anything after that is ignored]\n" ,
          argv [ 0 ] );
    return 1 ;
   }
  if ( 1 != sscanf ( argv [ 1 ] , "%f" , &mhz ) )
   {
    fprintf ( stderr , "%s: first argument \"%s\" was not a number\n" ,
                argv [ 0 ] , argv [ 1 ] ) ;
    return 1 ;
   }

  Hertz = ( 1000000. * mhz ) + .5 ; /* convert to hertz and round off */

  if ( Hertz < 20000000l || Hertz > 50000000l)
   {
    fprintf ( stderr , "20 < Pixel clock must be < 50 (mhz), not %d !\n"
   "this program is for use with a w5186 which has a freq limit of 50Mhz\n" ,
                           Hertz/1000000 ) ;
    return 1 ;
   }

  magic_number = ICD2061ACalcClock ( Hertz , icdchipreg ) ;

  perm_ports( TRUE );  /* set i/o permissions - RLB */

  ICD2061ASetClock ( magic_number ) ;

  perm_ports( FALSE ); /* clear i/o permissions - RLB */

  ActualHertz = ICD2061AGetClock  ( magic_number ) ;
  printf ( "actual freq=%d\n" , ActualHertz ) ; 

  return 0;
}
