#include "decor.h"
#include "aicon/earth0.xbm"
#include "aicon/earth1.xbm"
#include "aicon/earth2.xbm"
#include "aicon/earth3.xbm"
#include "aicon/earth4.xbm"
#include "aicon/earth5.xbm"
#include "aicon/earth6.xbm"
#include "aicon/earth7.xbm"
#include "aicon/earth8.xbm"
#include "aicon/earth9.xbm"
#include "aicon/earth_m.xbm"




void my_usleep (usec)
	long	usec;
	{
	struct timeval		timeout;


	timeout.tv_sec= usec/ SEC;
	timeout.tv_usec= usec% SEC;


	/*** wait for some useconds ***/
	select (0, NULL, NULL, NULL, &timeout);
	}




/*======================================================================*\
 *
 *	Load all specified cursors from a file
 *
\*======================================================================*/
int cursorLoad (display, win, file, mfile, fg, bg, cursor)
	Display	*display;
	Window	win;
	char	*file,
			*mfile;
	XColor	*fg,
			*bg;
	Cursor	*cursor;
	{
	Pixmap		pix, mask;
	unsigned	width, height,
				mwidth, mheight;
	int			xhot= 1, yhot= 1,
				error= -1;


	/*** read in the cursor bitmap file and its mask ***/
	error= XReadBitmapFile (display, win, file, 
	&width, &height, &pix, &xhot, &yhot);
	if (error== BitmapSuccess)
		{
		error= XReadBitmapFile (display, win, mfile, 
		&mwidth, &mheight, &mask, NULL, NULL);

		if (error== BitmapSuccess)
			{
			*cursor= XCreatePixmapCursor (display, pix, mask, fg, bg, 
			xhot, yhot);	
			XFreePixmap (display, pix);

			error= 0;
			}
		else
			printf ("### Error:  Can't load mask file \"%s\"!\n", mfile);
		}
	else
		printf ("### Error:  Can't load cursor file \"%s\"!\n", file);


	return (error);
	}




void cursorSet (display, win, cursor)
	Display	*display;
	Window	win;
	Cursor	cursor;
	{
	XDefineCursor (display, win, cursor);
	XFlush (display);
	}




void cursorLoop (display, win, mode, wait, cursor, num_cursor)
	Display		*display;
	Window		win;
	int			mode,
				wait; 
	Cursor		cursor[];
	int			num_cursor;
	{
	int		previous_rnum= -1,
			rnum,
			c,
			i;


	switch (num_cursor)
		{
		/*** do nothing if no cursors are specified ***/
		case 0:
			break;


		/*** set one single cursor ***/
		case 1:
			cursorSet (display, win, cursor[0]);
			break;


		/*** perform animation of cursors ***/
		default:
			switch (mode)
				{
				/*** Swing:  0, ... n, ... 0, ... ***/
				case (Swing):
					for ( ; ; )
						{
						for (i=0; i<num_cursor; i++)
							{
							cursorSet (display, win, cursor[i]);

							usleep (wait);
							}
						
						for (i=num_cursor-2; i>0; i--)
							{
							cursorSet (display, win, cursor[i]);

							usleep (wait);
							}
						}
					break;


				/*** RSwing:  0, ... a, ... 0, ... b, ... 0, ... c, ... ***/
				case (Random_Swing):
					srandom (time (0));

					for ( ; ; )
						{
						rnum= random ()% (num_cursor- 1)+ 1;

						for (i=0; i<=rnum; i++)
							{
							cursorSet (display, win, cursor[i]);

							usleep (wait);
							}

						for (i=rnum; i>=0; i--)
							{
							cursorSet (display, win, cursor[i]);

							usleep (wait);
							}
						}
					break;


				case (Vibrate):
					srandom (time (0));

					rnum= random ()% num_cursor;
					for ( ; ; )
						{
						while (rnum== previous_rnum)
							rnum= random ()% num_cursor;

						if (previous_rnum< rnum)
							for (i=previous_rnum+ 1; i<=rnum; i++)
								{
								cursorSet (display, win, cursor[i]);

								usleep (wait);
								}
						else
							for (i=previous_rnum- 1; i>=rnum; i--)
								{
								cursorSet (display, win, cursor[i]);

								usleep (wait);
								}


						previous_rnum= rnum;
						}
					break;


				case (Random):
					srandom (time (0));

					for ( ; ; )
						{
						rnum= random ()% num_cursor;

						cursorSet (display, win, cursor[rnum]);
						usleep (wait);
						}
					break;


				/*** Normal:  0, ... n, 0, ... n, ... ***/
				default:
					for ( ; ; )
						for (i=0; i<num_cursor; i++)
							{
							cursorSet (display, win, cursor[i]);

							usleep (wait);
							}
					break;
				}
		}
	}
		



void cursorDemo (display, win, mode, wait, fg, bg)
	Display	*display;
	Window	win;
	int		mode,
			wait;
	XColor	*fg,
			*bg;
	{
	static demo_type	demo_array[]= {
		earth0_width, earth0_height, earth0_x_hot, earth0_y_hot, earth0_bits,
		earth1_width, earth1_height, earth1_x_hot, earth1_y_hot, earth1_bits,
		earth2_width, earth2_height, earth2_x_hot, earth2_y_hot, earth2_bits,
		earth3_width, earth3_height, earth3_x_hot, earth3_y_hot, earth3_bits,
		earth4_width, earth4_height, earth4_x_hot, earth4_y_hot, earth4_bits,
		earth5_width, earth5_height, earth5_x_hot, earth5_y_hot, earth5_bits,
		earth6_width, earth6_height, earth6_x_hot, earth6_y_hot, earth6_bits,
		earth7_width, earth7_height, earth7_x_hot, earth7_y_hot, earth7_bits,
		earth8_width, earth8_height, earth8_x_hot, earth8_y_hot, earth8_bits,
		earth9_width, earth9_height, earth9_x_hot, earth9_y_hot, earth9_bits
		};
	int			num_demo= XtNumber (demo_array),
				i;
	Pixmap		pix,
				mask;
	Cursor		cursor[NUM_DEMO];


	mask= XCreatePixmapFromBitmapData (display, win, earth_m_bits, 
	earth_m_width, earth_m_height, 1, 0, 1);
	for (i=0; i<num_demo; i++)
		{
		pix= XCreatePixmapFromBitmapData (display, win, demo_array[i].bits, 
		demo_array[i].width, demo_array[i].height, 1, 0, 1);

		cursor[i]= XCreatePixmapCursor (display, pix, mask, fg, bg, 
		demo_array[i].x, demo_array[i].y);
		}


	cursorLoop (display, win, mode, wait, cursor, num_demo);
	}
		




