#include <X11/X.h>
#include <X11/Xlib.h>
#include <math.h>
#include "trippy.h"

typedef struct _PointCh
{
  double x,y;
  int charge;
} PointCharge;

PointCharge **field;

void
init_field(int winno)
{
  static int inited=0;
  int i;

  if(!inited)
  {
    field=(PointCharge **)malloc(sizeof(PointCharge *)*options.windows);
    inited=1;
  }

  field[winno]=(PointCharge *)malloc(sizeof(PointCharge)* options.number);
  for(i=0;i<options.number;i++)
  {
    field[winno][i].x=rndm(CX[winno]);
    field[winno][i].y=rndm(CY[winno]);
    field[winno][i].charge=rndm(160)-80;
  }  
}

void
draw_field(int winno)
{
  int i,x,y;
  double q;
  
  for(y=0;y<CY[winno];y++)
  {
    for(x=0;x<CX[winno];x++)
    {
      q=0.0;
      for(i=0;i<options.number;i++)
      {
	int dx,dy;
	    
	if (((dx=x-field[winno][i].x)==0)&&((dy=y-field[winno][i].y)==0))
	  continue;
	    
	q+= (double)field[winno][i].charge*10 / hypot(x-field[winno][i].x,
						      y-field[winno][i].y);
      }

      while(q<=0)
	q+=numcolors;
      XDrawPoint(display,window[winno],
		 color_gcs[((int)q%(numcolors-1))+1],x,y);
    }
  }
}


