/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/timer.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Dave Nichols, Steve Cole (SEP), May 5 1993
 *	wrote timer.c.
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>


#include <stdio.h>
#include <math.h>

#include "object.h" 
#include "tree.h"
#include "builders.h"

typedef struct timerinfo {
    unsigned long interval;
    int running;
    XtIntervalId id;
} _binf;

extern XtAppContext app_con;
extern void timer_sync();

void build_timer(root,parent)
     entry *root;
     Widget parent;
{
    Objdef *object;
    struct timerinfo *timer_info;
    char defname[12];
    Widget timer;
    Arg args[20];
    int narg;
    static int numtim=1;
    extern void timer_callback();
    
    /* create new object */
    object = new_object();

    timer_info = (struct timerinfo*) malloc( sizeof(struct timerinfo) );

    /* construct default timer name */
    sprintf(defname,"timer%d",numtim++);
    
    /* find label, name, action in tree */
    object->name = get_value(root,"name",defname);
    object->action = parse_actions(object->name,root);
    object->info = timer_info;
    object->sync = timer_sync;
    timer_info->interval = 
      (unsigned long)(atof(get_value(root,"interval","60"))*1000.);
    timer_info->running = (int) atoi(get_value(root,"running","1"));

    if( timer_info->running ){
         timer_info->id = XtAppAddTimeOut(app_con, timer_info->interval, 
		timer_callback, (XtPointer)object);
    }
}

/* callback used for timers */
void timer_callback( client_data, id)
XtPointer client_data ;
XtIntervalId* id;
{
    Objdef *object;
    extern int quitflag;
    Arg arg[1];
    struct timerinfo *timer_info;
    
    object = (Objdef *) client_data;
    timer_info = (struct timerinfo*)object->info;

    if( *id != timer_info->id ){
	fprintf(stderr,"Timer callback error, ids do not match %d %d\n",
		*id, timer_info->id );
    }

    if ( perform_actions(object->name,object->action,1) && !quitflag ) 
      quit_xtpanel(0);

    if( timer_info->running ){
         /* re-register the timeout */
         timer_info->id = XtAppAddTimeOut(app_con, timer_info->interval, 
		timer_callback, (XtPointer)object);
    }

}

/*
 * this routine is called when a timer's state (running
 * or not) or interval is changed by the SET action.
 */
void timer_sync(object,tag,value)
Objdef* object;
char* tag;
char* value;
{
    struct timerinfo *timer_info;

    timer_info = (struct timerinfo *) object->info;
    
    /* remove old timeout so we can start over */
    if( timer_info->running ){
       XtRemoveTimeOut(timer_info->id);
    }

    if (!strcmp(tag,"running")) {
       timer_info->running = (int) atoi(value);
    }
    if (!strcmp(tag,"interval")) {
       timer_info->interval = (unsigned long) (atof(value)*1000.);
    }

    if( timer_info->running ){
         timer_info->id = XtAppAddTimeOut(app_con, timer_info->interval, 
		timer_callback, (XtPointer)object);
    } 
}
