/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/grid.c
 *
 * Steve Cole, Dave Nichols (SEP), November 20 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP), May 5 1993
 *	wrote grid.c.
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>

#include "object.h" 
#include "tree.h"
#include "builders.h"
#include "string_buf.h"

#include <stdio.h>
#include <string.h>

typedef struct gridinfo {
    int nx;
    int ny;
    float xmin;
    float ymin;
    float dx;
    float dy;
    char* format;
    char* formtype;
    Widget *widgets;
} _ginfo;

/* translation table used for togglegrid object */
char grid_trans[] =
  "<Leave>:         update_grid()";

extern void grid_callback();
extern void grid_update();
extern void parse_gridstring();

void build_grid(root,parent,type)
     entry *root;
     Widget parent;
     char *type;
{
    Objdef *object;
    entry *curr;
    char* label;
    struct gridinfo *grid_info;
    Arg args[20];
    int narg, nargsv;
    Widget box, scrollbar, form, button, vlabel, labl;
    Widget rowsave, colsave;
    float valmin,valmax,val,top;
    Boolean *values;
    char *valstring;
    int nsamp,isamp,ix,iy;
    char text[100];
    int width,height;
    char defname[20];
    static int numgrid=1;
    static int numtgrid=1;
    
    /* create new object */
    object = new_object();

    /* construct default grid name */
    if (!strcmp(type,"grid"))
     sprintf(defname,"grid%d",numgrid++);
    else
     sprintf(defname,"togglegrid%d",numtgrid++);
    
    /* find name, action, grid info in tree */
    object->name = get_value(root,"name",defname);
    label = get_value(root,"label",object->name);
    object->action = parse_actions(object->name,root);
    grid_info = (struct gridinfo*) malloc( sizeof( struct gridinfo ) );
    object->info = grid_info;
    grid_info->nx = ((int) atoi(get_value(root,"nx","10")));
    grid_info->ny = ((int) atoi(get_value(root,"ny","10")));
    grid_info->xmin = ((float) atof(get_value(root,"xmin","0")));
    grid_info->ymin = ((float) atof(get_value(root,"ymin","0")));
    grid_info->dx = ((float) atof(get_value(root,"dx","1")));
    grid_info->dy = ((float) atof(get_value(root,"dy","1")));
    grid_info->format = get_value(root,"format"," %.0f %.0f");
    if (!strcmp(type,"grid"))
      grid_info->formtype = get_value(root,"formtype","xy");
    else
      grid_info->formtype = get_value(root,"formtype","bits");
    height = (int) atoi(get_value(root,"height","10"));
    width = (int) atoi(get_value(root,"width","10"));

    /* buttons are contained in a form widget */
    narg = 0;
    common_tags(parent,root,args,&narg,SET_COLOR | SET_POSITION | SET_PIXMAP );
    XtSetArg(args[narg], XtNdefaultDistance, 0); narg++;
    if (!strcmp(type,"grid")) 
     form = XtCreateManagedWidget("gridbox",formWidgetClass,parent,args,narg);
    else
     form = XtCreateManagedWidget("togglebox",formWidgetClass,parent,args,narg);
    
    /* use translations to update value whenever mouse leaves the box */
    if (!strcmp(type,"togglegrid")) 
      XtAugmentTranslations(form,XtParseTranslationTable(grid_trans));

    /* allocate space to hold button values and widget names */
    values = (Boolean*) malloc ( grid_info->nx * grid_info->ny * sizeof(Boolean));
    grid_info->widgets = (Widget*) 
              malloc ( grid_info->nx * grid_info->ny * sizeof(Widget));

    /* get the string containing default values */
    valstring = get_value(root,"value","");

    /* decode */
    parse_gridstring(valstring,values,grid_info->nx * grid_info->ny," \n\t",object);

    /* common parameters */
    narg = 0;
    common_tags(form,root,args,&narg,SET_COLOR);

    /* height, width */
    /* done here instead of common_tags so we could have defaults */
    XtSetArg(args[narg], XtNwidth, width); narg++;
    XtSetArg(args[narg], XtNheight, height); narg++;
    /* turn off border and label */
    XtSetArg(args[narg], XtNborderWidth, 0); narg++;
    XtSetArg(args[narg], XtNlabel, ""); narg++;
    /* backgroundPixmap comes from parent box */
    XtSetArg(args[narg], XtNbackgroundPixmap, ParentRelative); narg++;
    /* no highlight border because background
     * pixmap doesn't get restored properly after highlight */
    XtSetArg(args[narg], XtNhighlightThickness, 0); narg++;
    nargsv = narg;

    /* loop over buttons */
    isamp = 0;
    for (iy=0; iy<grid_info->ny; iy++, isamp++) {
    for (ix=0; ix<grid_info->nx; ix++, isamp++) {
	isamp = iy*grid_info->nx + ix;
    
    narg = nargsv;
    /* all but first row go below the previous row */
    if (iy > 0) {  XtSetArg(args[narg], XtNfromVert, rowsave); narg++; }
    /* all but first column go to the right of the previous column */
    if (ix > 0) {  XtSetArg(args[narg], XtNfromHoriz, colsave); narg++; }

    /* button is actually an athena command or toggle widget */
    if (!strcmp(type,"grid")) {
      button = XtCreateManagedWidget(object->name,commandWidgetClass,
                   form,args,narg);
      /* callback responds to each button press in grid */
      XtAddCallback( button, XtNcallback, grid_callback, (XtPointer) object);
    } else {
      /* set its state if appropriate */
      if (values[isamp]) {
         XtSetArg(args[narg], XtNstate, True); narg++;
      }
      button = XtCreateManagedWidget(object->name,toggleWidgetClass,
                   form,args,narg);
    }
    

    /* if at end of a row, save widget for vertical reference for next row */
    if (ix == grid_info->nx-1) rowsave = button;
    /* in any column save widget for horizontal reference */
    colsave = button;

    grid_info->widgets[isamp] = button;
    }
    }
    
    object->value = strdupl(valstring);
    object->widgetname = form;
    if (!strcmp(type,"togglegrid")) object->updater = grid_update;
    
}

/* callback used for buttons */
void
  grid_callback(widget, client_data, callData)
Widget widget;
XtPointer client_data, callData;
{
    Objdef *object;
    struct gridinfo *grid_info;
    extern int quitflag;
    Arg arg[1];
    char text[64];
    string_buf *buffer;
    Boolean state;
    int ix,iy,isamp;
    
    object = (Objdef *) client_data;
    grid_info = (struct gridinfo *) object->info;

    strcpy(object->value,"");
    buffer = buf_start();

    /* figure out which button was pressed */
    for (iy=0; iy < grid_info->ny; iy++) {
    for (ix=0; ix < grid_info->nx; ix++) {
	isamp = iy*grid_info->nx + ix;
	if (widget == grid_info->widgets[isamp]) {
		sprintf(text, grid_info->format,
		 (float) grid_info->xmin + ix * grid_info->dx,
		 (float) grid_info->ymin + iy * grid_info->dy);
		buf_cat( buffer,text,strlen(text));
		object->value = buf_fetch(buffer);
	}
    }
    }
    if ( perform_actions(object->name,object->action,1) && !quitflag)
      quit_xtpanel(0);
}

/* gets called to change the value of a togglegrid object */
void grid_update(object, value)
Objdef *object;
char *value;
{
    struct gridinfo *grid_info;
    Arg arg[1];
    Boolean *values;
    string_buf *buffer;
    int isamp,ix,iy;

    grid_info = (struct gridinfo *) object->info;
    values = (Boolean*) malloc ( grid_info->nx*grid_info->ny * sizeof(Boolean));

    strcpy(object->value,"");
    buffer = buf_start();

    /* decode */
    parse_gridstring(value,values,grid_info->nx*grid_info->ny," \n\t",object);

    for (iy=0; iy < grid_info->ny; iy++) {
    for (ix=0; ix < grid_info->nx; ix++) {
	isamp = iy*grid_info->nx + ix;

    if (values[isamp] == True) {
          XtSetArg(arg[0], XtNstate, True);
	  buf_cat( buffer,"1",1);
    } else {
          XtSetArg(arg[0], XtNstate, False);
	  buf_cat( buffer,"0",1);
    }
    XtSetValues( grid_info->widgets[isamp], arg, ONE );
    }
    /* write each row separately if using 0's and 1's */
    if (strcmp(grid_info->formtype,"xy")) buf_cat( buffer,"\n",1);
    }
    object->value = buf_fetch(buffer);
    perform_actions(object->name,object->action,0);
}

/* this gets called whenever we leave a togglegrid object */
void grid_update_callback( w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
    Objdef *object;
    struct gridinfo *grid_info;
    extern int quitflag;
    Arg arg[1];
    char text[64];
    string_buf *buffer;
    Boolean state;
    int ix,iy,isamp;
    
    object = find_by_widget(w);
    grid_info = (struct gridinfo *) object->info;

    strcpy(object->value,"");
    buffer = buf_start();

    /* figure out which toggles are set */
    for (iy=0; iy < grid_info->ny; iy++) {
    for (ix=0; ix < grid_info->nx; ix++) {
	isamp = iy*grid_info->nx + ix;
        /* get the current state of the toggle */
        XtSetArg( arg[0], XtNstate, &state );
        XtGetValues( grid_info->widgets[isamp], arg, ONE );
        if (!strcmp(grid_info->formtype,"xy")) {
	if (state == TRUE) {
		sprintf(text, grid_info->format,
		 (float) grid_info->xmin + ix * grid_info->dx,
		 (float) grid_info->ymin + iy * grid_info->dy);
		buf_cat( buffer,text,strlen(text));
	}
        } else {
	if (state == TRUE)
		buf_cat( buffer,"1",1);
	else
		buf_cat( buffer,"0",1);
        }
    }
    /* write each row separately if using 0's and 1's */
    if (strcmp(grid_info->formtype,"xy")) buf_cat( buffer,"\n",1);
    }
    object->value = buf_fetch(buffer);
    perform_actions(object->name,object->action,1);
}

void parse_gridstring(valstring,values,nsamp,separator,object)
    char *valstring;
    Boolean *values;
    int nsamp;
    char *separator;
    Objdef *object;
{
    struct gridinfo *grid_info;
    char *item1,*item2;
    int isamp,jsamp,ix,iy;
    float x,y;

    grid_info = (struct gridinfo *) object->info;

    /* first set all values to False */
    for( isamp=0; isamp<grid_info->nx*grid_info->ny; isamp++) {
	values[isamp] = False;
    }

    /* valstring contains x and y values of toggles to be set */
    if (!strcmp(grid_info->formtype,"xy")) {
      for( item1=strtok(valstring,separator),item2=strtok((char*)0,separator),
           isamp=0;
         item2 != (char*)0 && isamp <nsamp ;
         item1 =strtok((char*)0,separator),item2=strtok((char*)0,separator),
           isamp++){
                sscanf(item1,"%f",&x);
                sscanf(item2,"%f",&y);
         /* set the value */
         ix = (x - grid_info->xmin) / grid_info->dx;
	 if (ix < 0) ix = 0;
	 if (ix > grid_info->nx) ix = grid_info->nx;
         iy = (y - grid_info->ymin) / grid_info->dy;
	 if (iy < 0) iy = 0;
	 if (iy > grid_info->ny) iy = grid_info->ny;
         jsamp = iy * grid_info->nx + ix;
         values[jsamp] = True;
      }
    /* valstring contains a string of 0's and 1's */
    } else {
      for( isamp=0; isamp<strlen(valstring); isamp++ ) {
	if (!strncmp(&valstring[isamp],"1",1))
		values[isamp] = True;
	else
		values[isamp] = False;
      }
      /* if valstring does not contain enough samples, reuse it */
      if ((isamp > 0) && (isamp < grid_info->nx*grid_info->ny)) {
        for (jsamp=isamp; jsamp<grid_info->nx*grid_info->ny; jsamp++) {
                values[jsamp] = values[jsamp%isamp];
        }
      }
    }
}
