/* Variable definition for NoImake */
/* Martin Karrenbach   8-25-92     */

HOME            =/usr/local

BINDIR          =${HOME}/bin/X11
MANDIR          =${HOME}/man
USRLIBDIR       =${HOME}/lib
LIBDIR          =${USRLIBDIR}/X11
INCDIR          =${HOME}/include

#if defined(HP700)
LIBDIR          =/usr/lib/X11R4
#endif

RESOURCES       =${LIBDIR}/app-defaults
APPDEFAULTS     =Xtpanel

/* you normally should not have to modify below here, unless you add */
/* specific options for new machines                                 */

SUBDIRS = help generator examples

CPP             = /lib/cpp

CCOPTIONS       = -O

#if defined(SUN4)
CCOPTIONS       = -O -pipe
#endif

#if defined(HP700)
CCOPTIONS       = -O -Aa -D_HPUX_SOURCE
#endif

STD_DEFINES    = -D_NO_PROTO 

#if defined(RS6000)
STD_DEFINES    = -DSYSV -DAIXV3
#endif

EXTRA_DEFINES  = -DSYS_XTPANELDIR=\"$(SYS_XTPANELDIR)\" 

STD_INCLUDES   = -I$(INCDIR) -I.

XAWCLIENTLIBS  = $(XPMLIB) -lXaw -lXmu -lXt -lXext -lX11

INCLUDES =  $(EXTRA_INCLUDES) $(STD_INCLUDES)
DEFINES  =  $(STD_DEFINES)    $(EXTRA_DEFINES) 

CFLAGS  = $(CDEBUGFLAGS) $(CCOPTIONS) $(DEFINES) $(INCLUDES) 

SYSLIBS = $(SYS_LIBRARIES) $(EXTRA_LIBRARIES)

LDOPTIONS = $(CDEBUGFLAGS) $(CCOPTIONS) $(LOCAL_LDFLAGS) -L$(LIBDIR) \
            -L$(USRLIBDIR) $(LIBS)

RM      =  /bin/rm -f *.o core

RM_CMD      =  /bin/rm -f

INSTALL = install

MKDIRHIER = mkdirhier

/* all makefiles will have these rules  */
all::

clean::
	$(RM_CMD) "#"*
