#include "lattice.h"

float grd2rad = 180.0/M_PI; // Umrechnung grad -> radian
static int debug = 0;

lattice_window::lattice_window(window & parent, int w, int h, int x, int y) :
    coord_window(parent,w,h,x,y,2,2,2,2) // free rand : hor, vert : 2 Pix
{ 
   scptr = NULL;
   ncolors = 100;
   ixstart = 0; ixend = 0;
   iystart = 0; iyend = 0; rand = 0;
   external_colors = NULL; 
}

// draw clipped lines using global clip vectors y_top, y_bot
// lastp : draw last point of line (1) or not (0)
void lattice_window::cline(XPoint a, XPoint b, int lastp) {
  int sx,sy,dx,dy,x,y,visible,visible_p,ytt,ybb,up,down;
  int ex = 0, ey = 0;
  XPoint ax;
  if (debug) printf(" %d %d %d %d ",a.x,a.y,b.x,b.y);
  
  dx = b.x - a.x; dy = b.y - a.y;
  sx = (dx > 0) ? 1 : ((dx < 0) ? -1 : 0);
  sy = (dy > 0) ? 1 : ((dy < 0) ? -1 : 0);

  x = a.x; y = a.y; 
  dx = abs(dx); dy = abs(dy);

  do { 
    up = (y > y_top[x]); down = (y < y_bot[x]); 
    if (up) ytt = y; if (down) ybb = y;
    visible = up || down; 
    int endp = (x == b.x) && (y == b.y);
    if (endp &&  ! lastp) break;

    if (visible) DrawPoint(x,y); 

    if (dy < dx) {
      if (up) y_top[x] = ytt; if (down) y_bot[x] = ybb; 
      x += sx; ey += dy;  
      if (2*ey > dx) { y += sy; ey -= dx; } 
    } else {
      y += sy; ex += dx;
      if (2*ex > dy) {  
	if (up) y_top[x] = ytt; if (down) y_bot[x] = ybb; 
	x += sx; ex -= dy; }
    }
    if (endp) break; 
  } while (1);  
}

// fills from the line (a,b) up to the boundaries y_top, y_bot
// if (lastp) including the endpoint, 
// if (dofill) really fill, else only set boundaries
void lattice_window::fill(XPoint a, XPoint b, int lastp, int dofill) {
  int sx,sy,dx,dy,x,y,up,down;
  int ex = 0, ey = 0;

  dx = b.x - a.x; dy = b.y - a.y;
  sx = (dx > 0) ? 1 : ((dx < 0) ? -1 : 0);
  sy = (dy > 0) ? 1 : ((dy < 0) ? -1 : 0);

  x = a.x; y = a.y; 
  dx = abs(dx); dy = abs(dy);

  if (dy < dx) { 
    do {
      int endp = (x == b.x) && (y == b.y);
      if (endp &&  ! lastp) break;

      if (y > y_top[x]) { if (dofill) line(x,y,x,y_top[x]); y_top[x] = y; }
      if (y < y_bot[x]) { if (dofill) line(x,y,x,y_bot[x]); y_bot[x] = y; }
      x += sx; ey += dy;  
      if (2*ey > dx) { y += sy; ey -= dx; } 
      if (endp) break; 
    } while (1);  
  } else {
    do {
      int endp = (x == b.x) && (y == b.y);
      if (endp &&  ! lastp) break;

      y += sy; ex += dx;
      if (2*ex > dy) {  
	if (y > y_top[x]) { if (dofill) line(x,y,x,y_top[x]); y_top[x] = y; }
        if (y < y_bot[x]) { if (dofill) line(x,y,x,y_bot[x]); y_bot[x] = y; }
	x += sx; ex -= dy; }
    
      if (endp) break; 
    } while (1);  
  }
}

struct XPoint lattice_window::screen_project(float x, float y, float z)
{
  float xs,ys,yss,zss,t,dx,dy; 
  // printf(" %f %f %f \n",x,y,z);
  dx = x - xp; dy = y - yp;
  xs = ca*dx - sa*dy;  ys = ca*dy + sa*dx;     // Drehung x,y-Ebene
  zss = cb*z - sb*ys; yss = cb*ys + sb*z;      // Drehung ys,z-Ebene
    
  // Zentral-Projektion mit Perspektive
  // exakt gilt: temp.y = arcsin(yss/(distance - zss)) = y-Betrachtungs-winkel
  // wobei distance der Abstand Betrachter - Koordinatenursprung ist

  t = (dist == 0.0) ? 1.0 : 1.0/(1.0 - dist*zss/xp); 	   
  XPoint temp = p_window(t*xs,t*yss);

  // this should not happen, it would overflow y_top, y_bot indicees
  // only possible if dist too large, set them to the limit values
  if (temp.x < 0 ) temp.x = 0; else if (temp.x >= width) temp.x = width-1;
  return temp;
}

void reverse(int &x1, int &x2, int &dx) {
  int tmp = x1; x1 = x2; x2 = tmp; dx = -dx;
}

// alpha, beta : Drehwinkel (hier rad!), gamma : z-Faktor,
void lattice_window::make_lattice(int nx, int ny, float *FF, 
		    float alpha, float beta, float gamma, int opaque, 
		    float distance)
{ 
  float (*ff)[ny] = (float (*) [ny]) FF;
  int x,y; 
  y_bot = new int[width]; y_top = new int[width]; 
  for (x=0; x < width; x++) { y_top[x] = 0; y_bot[x] = height; }

  ca = cos(alpha); sa = sin(alpha); cb = cos(beta); sb = sin(beta);
  dist = distance;
  //  printf(" %d %d %f %f %f\n",nx,ny,alpha,beta,gamma);

  // der ix-Brereich [xstart .. xend] wird auf [0..xdraw-1] abgebildet
  int xdraw,ydraw;     // die x,y-Gitterpunktzahlen, die dargestellt sollen
  if (ixend == 0) ixend = nx; // am Anfang mit 0 initialisiert
  if (iyend == 0) iyend = ny;
  xdraw = ixend - ixstart + 2; // + 2 Punkte fuer Rand
  ydraw = iyend - iystart + 2;
  
  xspan = ixend - ixstart - 1; yspan = iyend - iystart -1;
  xp = 0.5*xspan; yp= 0.5*yspan; // Drehpunkt der x,y-Ebene
  
  float xmax,ymax;
  ymax = xmax = 0.5*sqrt(xspan*xspan + yspan*yspan); 

  //    printf( "%d %d %d %d \n",ixstart,iystart,xdraw,ydraw);
  define_coord(-xmax, -ymax, xmax, ymax); 

  int ix,iy;
  float zh,xh,yh;
  zmax = -1E30;

  struct XPoint scp[xdraw][ydraw]; // alle gitter-punkte nach trafo
  // x,y : Indizess von scp ; 
  // xh,yh,z : 3d-Koordinaten
  // ix,iy : Indizees von ff 
  // die Ecken zB. (xh,yh,zh) = (0,0,0) -> werden dreifach abgebildet nach :
  //                x,y = (0,0) (0,1) (1,0) 
  // xh,yh : (0,0,zh) -> (1,1)
  znorm = gamma * xmax;
  for (x = 1, ix = ixstart, xh = .0; x < xdraw-1; x++, ix++, xh += 1.0) { 
    for (y = 1, iy = iystart, yh = .0; y < ydraw-1; y++, iy++, yh += 1.0 ) {
      zh = znorm *ff[ix][iy]; if (zh > zmax) zmax = zh;
      scp[x][y] = screen_project(xh,yh,zh);
    }
  }
  yh = ydraw-3;
  for (x = 1, xh = 0.0; x<xdraw-1; x++, xh += 1.0) { 
    scp[x][0] = screen_project(xh,0,0);
    scp[x][ydraw-1] = screen_project(xh,yh,0); 
  }
  
  xh = xdraw-3;
  for (y = 1, yh = 0.0; y<ydraw-1; y++, yh += 1.0) { 
    scp[0][y] = screen_project(0,yh,0);
    scp[xdraw-1][y] = screen_project(xh,yh,0); 
  }
  scp[0][0] = scp[0][1];  scp[0][ydraw-1] = scp[0][ydraw-2];  
  scp[xdraw-1][0] = scp[xdraw-2][0];  
  scp[xdraw-1][ydraw-1] = scp[xdraw-2][ydraw-2]; 

  int x0,y0,dx,dy,xx,yy,yt,x1,y1;

  XPoint sc00 = screen_project(0,0,0),       // the origin   
         scxy = screen_project(xdraw-3,ydraw-3,0), // the opposite edge       
         scx = screen_project(xdraw-3,0,0),  // x,0
         scy = screen_project(0,ydraw-3,0),  // 0,y
         sczm = screen_project(0,0,zmax);   
  pline(sc00,sczm);       // z-axis
  
  int i, dzy = sczm.y - sc00.y, nti; // draw z-ticks with numbers
  nti = (abs(dzy) > 60) ? 5 : abs(dzy) / 15; // number of ticks 
  for (i=1; i< nti+1; i++) { 
    float zi = i/float(nti);
    int x = sc00.x, y = sc00.y + int(zi*dzy); 
    line(x,y,x-4,y); // z tick
    char ticks[20]; sprintf(ticks,"%g",zi*zmax/znorm);
    int xs = (x < width/2) ? x+3 : x - 6*strlen(ticks) - 6; // string Position
    DrawString(xs,y+5,ticks);
  }

 
  // Bestimung der Laufrichtung der for-loops xx,yy
  // so, dass y stets abnimmt, dh Start immer im vordersten Punkt 
  // rand = 1 : Darstellung mit Rand-Linien, 
  // sonst rand = 0 : dh nur von x = 1 .. xdraw-2 darstellen
  int orand = ! rand; // 0/1
  x0 = orand; x1 = xdraw-orand-1; dx = 1;
  if (sin(alpha) < 0.) reverse(x0,x1,dx);

  y0 = orand; y1 = ydraw-orand-1; dy = 1;
  if (cos(alpha) < 0.) reverse(y0,y1,dy);
 
  for (yy = y0 ; ; yy+= dy) {
      for (xx = x0 ; ; xx+= dx) 
	{ XPoint sc = scp[xx][yy];
	  if (debug) printf("\n %d %d ", xx, yy);
	  if (xx != x1) xline(sc,scp[xx+dx][yy],1);
          if (yy != y1) xline(sc,scp[xx][yy+dy],0); 
	  if (xx == x1) break;
	} 
      if (yy == y1) break;
  }
  // at least draw the xy axes
  if (orand) { cline(sc00,scx,1); cline(sc00,scy,1); } 
  
   delete[] y_top; delete[] y_bot;
}

palette_popup *pal_win = NULL; // popup window der color palette 

// Zeichnet eine perspektivische Darstellung der Gitterfunktion FF
// mit shading Algorithmus
void lattice_window::make_body(int nx, int ny, float *FF, 
			     float alpha, float beta, float gamma, int opaque, 
			     float distance, float al, float bl) {
  float (*ff)[ny] = (float (*) [ny]) FF;
  y_bot = new int[width]; y_top = new int[width]; 
  int x,y; 
  for (x=0; x < width; x++) { y_top[x] = 0; y_bot[x] = height; }

  // eigentlich koennen hier alle Projektionen und clippings entfallen !
  if (flat_mode) { alpha = beta = distance = 0; }

  ca = cos(alpha); sa = sin(alpha); cb = cos(beta); sb = sin(beta);
  dist = distance;
  //  printf(" %d %d %f %f %f\n",nx,ny,alpha,beta,gamma);

  if (ixend == 0) ixend = nx; // am Anfang mit 0 initialisiert
  if (iyend == 0) iyend = ny;
  xspan = ixend - ixstart - 1; yspan = iyend - iystart -1;
  xp = 0.5*xspan; yp= 0.5*yspan; // Drehpunkt der x,y-Ebene

  float xmax,ymax;
  if (flat_mode) { xmax = xp; ymax= yp; } else
  ymax = xmax = 0.5*sqrt(xspan*xspan + yspan*yspan); 

  define_coord(-xmax, -ymax, xmax, ymax); 

  int ix,iy;
  float zh,xh,yh;
  zmax = -1E30;
  if (scptr) delete[] scptr; 
  scptr = new XPoint[nx*ny]; 
  // alle nx*ny gitter-punkte nach trafo, adressiert als scp[nx][ny]
  struct XPoint (*scp)[ny] = (XPoint (*) [ny]) scptr; 
  znorm = gamma * xmax;
  for (ix = ixstart, xh = .0; ix < ixend; ix++, xh += 1.0) { 
    for (iy = iystart, yh = .0; iy < iyend; iy++, yh += 1.0 ) {
      zh = znorm * ff[ix][iy]; if (zh > zmax) zmax = zh;
      if (flat_mode) { 
	scp[ix][iy] = p_window(xh - xp,yh - yp);
      } else
      scp[ix][iy] = screen_project(xh, yh, zh);
    }
  }  

  int colors[nx][ny];

  if (! external_colors) { 
    // sonst vorgegebene Farben fuer Flaechen -> keine Berechnung    
    // Berechnung der Reflektionskoeffizienten der Gitterpunkte
    // Subtraktion der Drehwinkel -> feststehende Lichtquelle 
    // sonst : mitgedrehte Lichtquelle
    // Nachteil bei feststehender Quelle : 
    // Beim Drehen geht schnell die Orientierung verloren
    float e_alpha = al /* -alpha */ , e_beta = bl /* -beta */ ;
    float ex = cos(e_alpha)*cos(e_beta), ey = sin(e_alpha)*cos(e_beta), 
    ez = sin(e_beta); // (ex,ey,ez) = Einfallnormale Strahl 

    float rpp[nx][ny];
    float rmax = -1, rmin = 1, mu = 1/SQR(gamma); 
    for (ix = ixstart+1; ix < ixend; ix++) { 
      for (iy = iystart+1; iy < iyend; iy++) {
	float z00 = ff[ix][iy];
	float z10 = ff[ix-1][iy], z01 = ff[ix][iy-1], z11 = ff[ix-1][iy-1];
	// Berechnung der Normalen zu (x,y) (x+1,y) (x,y+1) :
	// n = (zx, zy, 1)/|N|
	float zxp = z01 - z11,  zyp = z10 - z11; // steigende Differenzen
	float zxm = z00 - z10,  zym = z00 - z01; // fallende Differenzen
	// fuer Quadrate benutze mittlere Ableitung
         zxp += zxm; zyp += zym; 
	//            Skalarprodukt n * E
	rpp[ix][iy]= opaque ? (zxp*ex+zyp*ey+ez)/sqrt(zxp*zxp + zyp*zyp + mu) 
	                    : - (z00+z01+z10+z11); // prop. z
	rmax = MAX(rpp[ix][iy], rmax);  // fuer Normierung der Skalarprodukte
	rmin = MIN(rpp[ix][iy], rmin);
      }
    }
    for (ix = ixstart+1; ix < ixend; ix++)  
      for (iy = iystart+1; iy < iyend; iy++)
	// Normierung des Skalarprod. s = [rmin..rmax] -> [0..ncolors-1]
	colors[ix][iy] = (int) ((ncolors-1)*(rpp[ix][iy]-rmin)/(rmax-rmin));
  }

  // Bestimmung der Laufparameter der for-loops, so dass stets mit dem
  // Zeichnen der vorderen (untersten) Ecke begonnen wird
  // xs,ys sind die offsets zwischen ix,iy und dem 
  //       index der skalarprodukt-Felder, die von 1,1 indiziert sind
  // Beispiele : ixstart = 0, ixend = 10, 
  //                	x0   	x1  	dx  	xs
  // alpha = 0..90   	0    	1   	1  	0
  // alpha = -90..0  	9    	8	-1	1

  int x0 = ixstart, x1 = ixstart+1, dx = 1, xx = ixend-ixstart-1, xs = 0;
  if (sa < 0.) { x0 = ixend-1; x1 = ixend-2; dx = -1; xs = 1; }

  int y0 = iystart, y1 = iystart+1, dy = 1, yy = iyend-iystart-1, ys = 0;
  if (ca < 0.) { y0 = iyend-1; y1 = iyend-2; dy = -1; ys = 1; }

  {
    // Randwerte y_top, y_bot bestimmen, ohne zu zeichnen
    for (ix=x1, x=0; x < xx; ix+=dx, x++) fill(scp[ix][y0],scp[ix-dx][y0],1,0);
    for (iy=y1, y=0; y < yy; iy+=dy, y++) fill(scp[x0][iy],scp[x0][iy-dy],1,0);
 
    for (ix=x1, x=0; x < xx; ix+=dx, x++) {
      for (iy=y1, y=0; y < yy; iy+=dy, y++) { 
        XPoint p00 = scp[ix][iy], p10 = scp[ix-dx][iy], p01 = scp[ix][iy-dy];
        int color;
        if (external_colors) color = external_colors[(ix+xs)*ny + iy+ys];
        else {
	  int pixr = colors[ix+xs][iy+ys];
	  color = pal_win->color_cells[pixr].pixel;
        } 
        set_color(color);  
        //  fill(p01,p10,0,1); -> unteres Dreieck
        // oberes Dreieck bzw komplettes Viereck 
        fill(p00, p10, 0, 1); fill(p00, p01, 0, 1);   
      }
    }
  }

  
  set_color(1); // reset gc_copy !  
  XPoint sc00 = screen_project(0,0,0),       // the origin
         sczm = screen_project(0,0,zmax); 
  pline(sc00,sczm);     // z-axis to zmax
  int i, dzy = sczm.y - sc00.y, nti;  // draw z-ticks with numbers
  nti = (abs(dzy) > 60) ? 5 : abs(dzy) / 15; // number of ticks 
  for (i=1; i< nti+1; i++) { 
    float zi = i/float(nti);
    int x = sc00.x, y = sc00.y + int(zi*dzy); 
    line(x,y,x-4,y); // z tick
    char ticks[20]; sprintf(ticks,"%g",zi*zmax/znorm);
    int xs = (x < width/2) ? x+3 : x - 6*strlen(ticks) - 6; // string Position
    DrawString(xs,y+5,ticks);
  }
  if (rand) {
    for (ix = ixstart+1,x=1; ix < ixend; ix++,x++) {
      cline(scp[ix][iystart],screen_project(x,0,0),0);
      cline(scp[ix][iyend-1],screen_project(x,yspan,0),0);
    }
    for (iy = iystart+1,y=1; iy < iyend; iy++,y++) {
      cline(scp[ixstart][iy],screen_project(0,y,0),0);
      cline(scp[ixend-1][iy],screen_project(xspan,y,0),0);
    }
  }
  // x y Achsen
  XPoint sc10 = screen_project(xspan,0,0), sc01 = screen_project(0,yspan,0),
         sc11 = screen_project(xspan,yspan,0);
  
  cline(sc00,sc10,1);  cline(sc00,sc01,1);
  cline(sc11,sc10,1);  cline(sc11,sc01,1);
  delete[] y_top; delete[] y_bot;
}

