#include <stdio.h>
#include "window.h"
#include "files.h"

#define MAXLINES 2000   // max 2000 lines
#define MAXCHARS 100000 // with max 100,000 chars

// read opened FILE f into char array text, with line pointers lptr
// returns : number of lines read; fina only for print
int read_file (FILE *f, char **lptr, char *text, char *fina) {
  char *tptr = text;
  int zz = 0; 
  while (lptr[zz++] = fgets(tptr,200,f)) { 
    tptr+= strlen(tptr); *(tptr-1)= 0;  // the NL is  replaced by 0
    if (zz == MAXLINES-1 || tptr-text > MAXCHARS-200) { 
      printf("too large file truncated !\n"); break;
    }
  }
 
  printf("file %s has %d lines and %d chars \n",fina,zz,tptr-text);
  return zz;
}

// reads a new file and displays it in ts, 
// in fina the cosed file name is returned
void open_new_file(text_viewer *ts, char **lptr, char *text, char *fina) {
  char *defname = "*.c"; 
  FILE *fload;
  fload = open_file_interactive(defname,fina,MODE_READ);
  if (fload == NULL) return; 
  int zz = read_file(fload,lptr,text,fina);
  ts->reset(lptr,zz);
  fclose(fload);
  XStoreName(display,ts->mainw->Win,fina); // set WM name
}

int top = 0;

void spawn(char *last_fina) { // creates a new window with the last file
  int ww = 300, wh = 300;
  char *fina = new char [200]; strcpy(fina,last_fina);

  char **lptr = new char* [MAXLINES]; 
  char *text = new char [MAXCHARS];

  FILE *f = fopen(fina,"r"); 
  if (f == NULL) { printf("cannot open file '%s'\n",fina); return; }

  int zz = read_file(f,lptr,text,fina);
  main_window *sw = new main_window(fina,ww,wh+20);
  text_viewer *tv = new text_viewer(*sw,ww,wh,0,20,lptr,zz); 

  menu_bar *mb = new menu_bar(*sw,ww,20,0,0);
  button *bb[] = { 
     new function_button(*mb,"new file",(CB) open_new_file,tv,lptr,text,fina),
     new function_button(*mb,"spawn",(CB) spawn,fina) 
  };

  // only the top window has a quit button the others have delete_buttons
  // that delete the sw-window tree
  // upon delete also the new arrays (lptr, text, fina) should be deleted
  button *qb = (top == 0) ? new quit_button(*mb) : new delete_button(*mb,sw);

  // to have only one main_loop :
  if (top++ == 0) sw->main_loop(); else sw->RealizeChildren();
 
}

int main(int argc, char **argv) {
  // if argument given : display it
  char *fina = (argc > 1) ? argv[1] : "files.c"; 
  spawn(fina) ;
}




