/*
 * Copyright (C) 1994, Jettero Heller
 *
 * You may distribute under the terms of the GNU Library General Public 
 * License as specified in the COPYING file that comes with the Xarm library.
 *
 */
/* ToggleBG.C,v 1.3 1994/10/27 23:27:00 pgw Exp */
#include <Xarm/ToggleBG.h>
/* ToggleButtonGadgetClass Members */
/* callbacks */
void
ToggleButtonGadgetClass::armCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNarmCallback,funcp,data);
}

void
ToggleButtonGadgetClass::disarmCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNdisarmCallback,funcp,data);
}

void
ToggleButtonGadgetClass::valueChangedCallback(XtCallbackProc funcp, XtPointer data)
{
   addCallback(XmNvalueChangedCallback,funcp,data);
}

/* convenience routines */
Boolean 
ToggleButtonGadgetClass::getState()
{
   return XmToggleButtonGetState(widget());
}

void 
ToggleButtonGadgetClass::setState(Boolean state, Boolean notify)
{
   XmToggleButtonSetState(widget(), state, notify);
}

/* resources */
void
ToggleButtonGadgetClass::fillOnSelect(Boolean b)
{
   XtVaSetValues(widget(), XmNfillOnSelect, b, NULL);
}

Boolean
ToggleButtonGadgetClass::fillOnSelect()
{
   Boolean b;
   XtVaGetValues(widget(), XmNfillOnSelect, &b, NULL);
   return b;
}

void
ToggleButtonGadgetClass::indicatorOn(Boolean b)
{
   XtVaSetValues(widget(), XmNindicatorOn, b, NULL);
}

Boolean
ToggleButtonGadgetClass::indicatorOn()
{
   Boolean b;
   XtVaGetValues(widget(), XmNindicatorOn, &b, NULL);
   return b;
}

void
ToggleButtonGadgetClass::indicatorSize(Dimension d)
{
   XtVaSetValues(widget(), XmNindicatorSize, d, NULL);
}

Dimension
ToggleButtonGadgetClass::indicatorSize()
{
   Dimension d;
   XtVaGetValues(widget(), XmNindicatorSize, &d, NULL);
   return d;
}

void
ToggleButtonGadgetClass::indicatorType(unsigned char c)
{
   XtVaSetValues(widget(), XmNindicatorType, c, NULL);
}

unsigned char
ToggleButtonGadgetClass::indicatorType()
{
   unsigned char c;
   XtVaGetValues(widget(), XmNindicatorType, &c, NULL);
   return c;
}

void
ToggleButtonGadgetClass::selectColor(Pixel p)
{
   XtVaSetValues(widget(), XmNselectColor, p, NULL);
}

Pixel
ToggleButtonGadgetClass::selectColor()
{
   Pixel p;
   XtVaGetValues(widget(), XmNselectColor, &p, NULL);
   return p;
}

void
ToggleButtonGadgetClass::selectInsensitivePixmap(Pixmap p)
{
   XtVaSetValues(widget(), XmNselectInsensitivePixmap, p, NULL);
}

Pixmap
ToggleButtonGadgetClass::selectInsensitivePixmap()
{
   Pixmap p;
   XtVaGetValues(widget(), XmNselectInsensitivePixmap, &p, NULL);
   return p;
}

void
ToggleButtonGadgetClass::set(Boolean b)
{
   XtVaSetValues(widget(), XmNset, b, NULL);
}

Boolean
ToggleButtonGadgetClass::set()
{
   Boolean b;
   XtVaGetValues(widget(), XmNset, &b, NULL);
   return b;
}

void
ToggleButtonGadgetClass::spacing(Dimension d)
{
   XtVaSetValues(widget(), XmNspacing, d, NULL);
}

Dimension
ToggleButtonGadgetClass::spacing()
{
   Dimension d;
   XtVaGetValues(widget(), XmNspacing, &d, NULL);
   return d;
}

void
ToggleButtonGadgetClass::visibleWhenOff(Boolean b)
{
   XtVaSetValues(widget(), XmNvisibleWhenOff, b, NULL);
}

Boolean 
ToggleButtonGadgetClass::visibleWhenOff()
{
   Boolean b;
   XtVaGetValues(widget(), XmNvisibleWhenOff, &b, NULL);
   return b;
}

/* constructors */
ToggleButtonGadget::ToggleButtonGadget(Widget parent, char *str, KeySym mn,
                                       String acc, char *accText) 
{
   Widget w = XtVaCreateWidget("XmToggleButtonGadget",
                               xmToggleButtonGadgetClass,
                               parent,
                               NULL);
   widget(w);
   labelString(str);
   manage();

   alignment(XmALIGNMENT_BEGINNING);
   if(mn != 0) mnemonic(mn);
   if(acc) accelerator(acc);
   if(accText) acceleratorText(accText);
}

ToggleButtonGadget::ToggleButtonGadget(Widget parent, ArgList arglist, 
                                       Cardinal cnt)
{
   Widget w = XmCreateToggleButtonGadget(parent, "XmToggleButtonGadget", 
                                         arglist,cnt);
   widget(w);
   manage();
}

